/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions.tests;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.api.editor.EditorSupport;
import org.netbeans.modules.php.api.editor.PhpClass;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.api.PhpProjectUtils;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.spi.gototest.TestLocator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class GoToTest
implements TestLocator {
    private static final Logger LOGGER = Logger.getLogger(GoToTest.class.getName());

    public boolean appliesTo(FileObject fo) {
        return FileUtils.isPhpFile((FileObject)fo);
    }

    public boolean asynchronous() {
        return false;
    }

    public void findOpposite(FileObject fo, int caretOffset, TestLocator.LocationListener callback) {
        throw new UnsupportedOperationException("GotoTest is synchronous");
    }

    public TestLocator.LocationResult findOpposite(FileObject fo, int caretOffset) {
        PhpProject project = this.findPhpProject(fo);
        if (project == null) {
            LOGGER.log(Level.INFO, "PHP project was not found for file {0}", fo);
            return null;
        }
        if (CommandUtils.isUnderTests(project, fo, false)) {
            return this.findSource(project, fo);
        }
        if (CommandUtils.isUnderSources(project, fo)) {
            return GoToTest.findTest(project, fo);
        }
        return null;
    }

    public TestLocator.FileType getFileType(FileObject fo) {
        PhpProject project = this.findPhpProject(fo);
        if (project == null) {
            LOGGER.log(Level.INFO, "PHP project was not found for file {0}", fo);
            return TestLocator.FileType.NEITHER;
        }
        if (CommandUtils.isUnderTests(project, fo, false)) {
            String name = fo.getNameExt();
            if (!name.equals("Test.php") && name.endsWith("Test.php")) {
                return TestLocator.FileType.TEST;
            }
        } else if (CommandUtils.isUnderSources(project, fo)) {
            return TestLocator.FileType.TESTED;
        }
        return TestLocator.FileType.NEITHER;
    }

    private TestLocator.LocationResult findSource(PhpProject project, FileObject testFo) {
        FileObject sources = GoToTest.getSources(project);
        assert (sources != null) : "Project sources must be found";
        EditorSupport editorSupport = (EditorSupport)Lookup.getDefault().lookup(EditorSupport.class);
        assert (editorSupport != null) : "Editor support must exist";
        Collection classes = editorSupport.getClasses(testFo);
        for (PhpClass phpClass : classes) {
            String clsFQName = phpClass.getFullyQualifiedName();
            if (!clsFQName.endsWith("Test")) continue;
            int lastIndexOf = phpClass.getName().lastIndexOf("Test");
            assert (lastIndexOf != -1);
            String srcClassName = phpClass.getName().substring(0, lastIndexOf);
            lastIndexOf = clsFQName.lastIndexOf("Test");
            String srcClassFQName = clsFQName.substring(0, lastIndexOf);
            Collection files = editorSupport.filesForClass(sources, new PhpClass(srcClassName, srcClassFQName, -1));
            for (FileObject fileObject : files) {
                if (!FileUtils.isPhpFile((FileObject)fileObject) || !FileUtil.isParentOf((FileObject)sources, (FileObject)fileObject)) continue;
                return new TestLocator.LocationResult(fileObject, -1);
            }
        }
        return new TestLocator.LocationResult(NbBundle.getMessage(GoToTest.class, (String)"MSG_SrcNotFound", (Object)testFo.getNameExt()));
    }

    public static TestLocator.LocationResult findTest(PhpProject project, FileObject srcFo) {
        FileObject tests = GoToTest.getTests(project);
        if (tests != null) {
            EditorSupport editorSupport = (EditorSupport)Lookup.getDefault().lookup(EditorSupport.class);
            assert (editorSupport != null) : "Editor support must exist";
            Collection classes = editorSupport.getClasses(srcFo);
            for (PhpClass phpClass : classes) {
                String testClsName = phpClass.getName() + "Test";
                String testClsFQName = phpClass.getFullyQualifiedName() + "Test";
                Collection files = editorSupport.filesForClass(tests, new PhpClass(testClsName, testClsFQName, -1));
                for (FileObject fileObject : files) {
                    if (!FileUtils.isPhpFile((FileObject)fileObject) || !FileUtil.isParentOf((FileObject)tests, (FileObject)fileObject)) continue;
                    return new TestLocator.LocationResult(fileObject, -1);
                }
            }
        }
        return new TestLocator.LocationResult(NbBundle.getMessage(GoToTest.class, (String)"MSG_TestNotFound", (Object)srcFo.getNameExt()));
    }

    private PhpProject findPhpProject(FileObject fo) {
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project == null || !PhpProjectUtils.isPhpProject(project)) {
            return null;
        }
        return (PhpProject)project;
    }

    public static FileObject getSources(PhpProject project) {
        return ProjectPropertiesSupport.getSourcesDirectory(project);
    }

    public static FileObject getTests(PhpProject project) {
        return ProjectPropertiesSupport.getTestDirectory(project, false);
    }
}

