/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.refactoring.ui;

import java.util.Collection;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.editor.api.AstPath;
import org.netbeans.modules.groovy.editor.api.AstUtilities;
import org.netbeans.modules.groovy.editor.api.lexer.LexUtilities;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParserResult;
import org.netbeans.modules.groovy.editor.api.parser.SourceUtils;
import org.netbeans.modules.groovy.refactoring.GroovyRefactoringElement;
import org.netbeans.modules.groovy.refactoring.Utils;
import org.netbeans.modules.groovy.refactoring.ui.WhereUsedQueryUI;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.refactoring.spi.ui.ActionsImplementationProvider;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class GroovyRefactoringActionsProvider
extends ActionsImplementationProvider {
    private static boolean isFindUsages;

    public boolean canFindUsages(Lookup lookup) {
        Collection collection = lookup.lookupAll(Node.class);
        if (collection.size() != 1) {
            return false;
        }
        Node node = (Node)collection.iterator().next();
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject == null) {
            return false;
        }
        FileObject fileObject = dataObject.getPrimaryFile();
        if (GroovyRefactoringActionsProvider.isOutsideGroovy(lookup, fileObject)) {
            return false;
        }
        return dataObject != null && Utils.isGroovyOrGspFile(fileObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFindUsages(Lookup lookup) {
        EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
        FileObject fileObject = (FileObject)lookup.lookup(FileObject.class);
        UserTask userTask = GroovyRefactoringActionsProvider.isFromEditor(editorCookie) ? new TextComponentTask(editorCookie, fileObject){

            @Override
            protected RefactoringUI createRefactoringUI(GroovyRefactoringElement groovyRefactoringElement, int n, int n2, GroovyParserResult groovyParserResult) {
                return new WhereUsedQueryUI(groovyRefactoringElement);
            }
        } : new NodeToElementTask(lookup.lookupAll(Node.class), fileObject){

            @Override
            protected RefactoringUI createRefactoringUI(GroovyRefactoringElement groovyRefactoringElement, GroovyParserResult groovyParserResult) {
                return new WhereUsedQueryUI(groovyRefactoringElement);
            }
        };
        try {
            isFindUsages = true;
            userTask.run();
        }
        finally {
            isFindUsages = false;
        }
    }

    private static boolean isOutsideGroovy(Lookup lookup, FileObject fileObject) {
        EditorCookie editorCookie;
        if (Utils.isGspFile(fileObject) && GroovyRefactoringActionsProvider.isFromEditor(editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class))) {
            JEditorPane jEditorPane = editorCookie.getOpenedPanes()[0];
            Document document = jEditorPane.getDocument();
            if (!(document instanceof BaseDocument)) {
                return true;
            }
            int n = jEditorPane.getCaretPosition();
            if (LexUtilities.getToken((BaseDocument)((BaseDocument)document), (int)n) == null) {
                return true;
            }
        }
        return false;
    }

    private static boolean isFromEditor(EditorCookie editorCookie) {
        return editorCookie != null && editorCookie.getOpenedPanes() != null;
    }

    public static abstract class NodeToElementTask
    extends UserTask
    implements Runnable {
        private Node node;
        private RefactoringUI ui;
        private final FileObject fileObject;

        public NodeToElementTask(Collection<? extends Node> collection, FileObject fileObject) {
            assert (collection.size() == 1);
            this.node = collection.iterator().next();
            this.fileObject = fileObject;
        }

        public void run(ResultIterator resultIterator) throws Exception {
            GroovyParserResult groovyParserResult = AstUtilities.getParseResult((Parser.Result)resultIterator.getParserResult());
            ModuleNode moduleNode = AstUtilities.getRoot((ParserResult)groovyParserResult);
            if (moduleNode != null) {
                GroovyRefactoringElement groovyRefactoringElement = new GroovyRefactoringElement(groovyParserResult, moduleNode, (ASTNode)moduleNode, groovyParserResult.getSnapshot().getSource().getFileObject());
                this.ui = this.createRefactoringUI(groovyRefactoringElement, groovyParserResult);
            }
        }

        @Override
        public final void run() {
            DataObject dataObject = (DataObject)this.node.getCookie(DataObject.class);
            try {
                SourceUtils.runUserActionTask((FileObject)this.fileObject, (UserTask)this);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
            UI.openRefactoringUI((RefactoringUI)this.ui);
        }

        protected abstract RefactoringUI createRefactoringUI(GroovyRefactoringElement var1, GroovyParserResult var2);
    }

    public static abstract class TextComponentTask
    extends UserTask
    implements Runnable {
        private JTextComponent textC;
        private int caret;
        private int start;
        private int end;
        private RefactoringUI ui;
        private final FileObject fileObject;

        public TextComponentTask(EditorCookie editorCookie, FileObject fileObject) {
            this.textC = editorCookie.getOpenedPanes()[0];
            this.caret = this.textC.getCaretPosition();
            this.start = this.textC.getSelectionStart();
            this.end = this.textC.getSelectionEnd();
            this.fileObject = fileObject;
            assert (this.caret != -1);
            assert (this.start != -1);
            assert (this.end != -1);
        }

        public void run(ResultIterator resultIterator) throws Exception {
            GroovyParserResult groovyParserResult = AstUtilities.getParseResult((Parser.Result)resultIterator.getParserResult());
            ModuleNode moduleNode = AstUtilities.getRoot((ParserResult)groovyParserResult);
            if (moduleNode == null) {
                System.out.println("FAILURE - can't refactor uncompileable sources");
                return;
            }
            BaseDocument baseDocument = Utils.getDocument((ParserResult)groovyParserResult, this.fileObject);
            AstPath astPath = new AstPath((ASTNode)moduleNode, this.caret, baseDocument);
            GroovyRefactoringElement groovyRefactoringElement = new GroovyRefactoringElement(groovyParserResult, moduleNode, astPath.leaf(), this.fileObject);
            if (groovyRefactoringElement.getSimpleName() == null) {
                return;
            }
            this.ui = this.createRefactoringUI(groovyRefactoringElement, this.start, this.end, groovyParserResult);
        }

        @Override
        public final void run() {
            try {
                SourceUtils.runUserActionTask((FileObject)this.fileObject, (UserTask)this);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
            TopComponent topComponent = TopComponent.getRegistry().getActivated();
            if (this.ui != null) {
                UI.openRefactoringUI((RefactoringUI)this.ui, (TopComponent)topComponent);
            } else {
                String string = "ERR_CannotRenameLoc";
                if (isFindUsages) {
                    string = "ERR_CannotFindUsages";
                }
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(GroovyRefactoringActionsProvider.class, (String)string));
            }
        }

        protected abstract RefactoringUI createRefactoringUI(GroovyRefactoringElement var1, int var2, int var3, GroovyParserResult var4);
    }
}

