/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import oracle.toplink.essentials.exceptions.ConversionException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.security.Securable;

public class JCEEncryptor
implements Securable {
    private Cipher m_cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
    private final String m_algorithm = "DES";
    private final String m_padding = "DES/ECB/PKCS5Padding";

    public synchronized String encryptPassword(String password) {
        try {
            this.m_cipher.init(1, Synergizer.getMultitasker("DES"));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CipherOutputStream cos = new CipherOutputStream(baos, this.m_cipher);
            ObjectOutputStream oos = new ObjectOutputStream(cos);
            oos.writeObject(password);
            oos.flush();
            oos.close();
            return Helper.buildHexStringFromBytes(baos.toByteArray());
        }
        catch (Exception e) {
            throw ValidationException.errorEncryptingPassword(e);
        }
    }

    public synchronized String decryptPassword(String encryptedPswd) {
        String password = "";
        try {
            this.m_cipher.init(2, Synergizer.getMultitasker("DES"));
            byte[] bytePassword = Helper.buildBytesFromHexString(encryptedPswd);
            ByteArrayInputStream bais = new ByteArrayInputStream(bytePassword);
            CipherInputStream cis = new CipherInputStream(bais, this.m_cipher);
            ObjectInputStream ois = new ObjectInputStream(cis);
            password = (String)ois.readObject();
            ois.close();
        }
        catch (IOException e) {
            password = encryptedPswd;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            password = encryptedPswd;
        }
        catch (ConversionException e) {
            password = encryptedPswd;
        }
        catch (Exception e) {
            throw ValidationException.errorDecryptingPassword(e);
        }
        return password;
    }

    private static class Synergizer {
        private static String multitasker = "E60B80C7AEC78038";

        private Synergizer() {
        }

        public static SecretKey getMultitasker(String algorithm) throws Exception {
            SecretKeyFactory skf = SecretKeyFactory.getInstance(algorithm);
            return skf.generateSecret(new DESKeySpec(Helper.buildBytesFromHexString(multitasker)));
        }
    }
}

