/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.api.support;

import java.net.ConnectException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.modules.dlight.api.execution.AttachableTarget;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.DLightTargetChangeEvent;
import org.netbeans.modules.dlight.api.execution.SubstitutableTarget;
import org.netbeans.modules.dlight.api.support.NativeExecutableTargetConfiguration;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.NativeProcessChangeEvent;
import org.netbeans.modules.nativeexecution.api.execution.NativeExecutionDescriptor;
import org.netbeans.modules.nativeexecution.api.execution.NativeExecutionService;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ExternalTerminal;
import org.netbeans.modules.nativeexecution.api.util.Signal;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;

public final class NativeExecutableTarget
extends DLightTarget
implements SubstitutableTarget,
AttachableTarget,
ChangeListener {
    private static final Logger log = DLightLogger.getLogger(NativeExecutableTarget.class);
    private final ExecutionEnvironment execEnv;
    private final String templateCMD;
    private final Map<String, String> envs;
    private final String workingDirectory;
    private final ExternalTerminal externalTerminal;
    private final String[] templateArgs;
    private final InputOutput io;
    private String[] args;
    private String cmd;
    private boolean x11forwarding;
    private Future<Integer> targetFutureResult;
    private volatile int pid = -1;
    private volatile Integer status = null;
    private final StateLock stateLock = new StateLock();
    private volatile DLightTarget.State state;
    private ExecutionDescriptor.LineConvertorFactory outConvertorFactory;
    private ExecutionDescriptor.LineConvertorFactory errConvertorFactory;

    public NativeExecutableTarget(NativeExecutableTargetConfiguration configuration) {
        super(new NativeExecutableTargetExecutionService());
        this.execEnv = configuration.getExecutionEvnitoment();
        this.cmd = configuration.getCmd();
        this.args = configuration.getArgs();
        this.workingDirectory = configuration.getWorkingDirectory();
        this.envs = new HashMap<String, String>();
        this.envs.putAll(configuration.getEnv());
        ExternalTerminal term = configuration.getExternalTerminal();
        if (term != null) {
            term = term.setTitle(this.cmd + ' ' + Utilities.escapeParameters((String[])this.args));
        }
        this.externalTerminal = term;
        if (this.externalTerminal == null) {
            this.outConvertorFactory = configuration.getOutConvertorFactory();
            this.errConvertorFactory = configuration.getErrConvertorFactory();
        }
        this.templateCMD = this.cmd;
        Map<String, String> info = configuration.getInfo();
        for (Map.Entry<String, String> entry : info.entrySet()) {
            this.putToInfo(entry.getKey(), entry.getValue());
        }
        this.templateArgs = (String[])this.args.clone();
        this.io = configuration.getIO();
        this.x11forwarding = configuration.getX11Forwarding();
    }

    @Override
    public int getPID() {
        return this.pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DLightTarget.State getState() {
        StateLock stateLock = this.stateLock;
        synchronized (stateLock) {
            return this.state;
        }
    }

    public String toString() {
        return "Executable target: " + this.cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(ChangeEvent e) {
        if (!(e instanceof NativeProcessChangeEvent)) {
            return;
        }
        NativeProcessChangeEvent event = (NativeProcessChangeEvent)e;
        NativeProcess process = (NativeProcess)event.getSource();
        DLightTarget.State newState = null;
        boolean doNotify = true;
        boolean doResume = false;
        StateLock stateLock = this.stateLock;
        synchronized (stateLock) {
            switch (event.state) {
                case INITIAL: {
                    this.state = DLightTarget.State.INIT;
                    break;
                }
                case STARTING: {
                    this.state = DLightTarget.State.STARTING;
                    break;
                }
                case RUNNING: {
                    this.state = DLightTarget.State.RUNNING;
                    this.pid = event.pid;
                    break;
                }
                case CANCELLED: {
                    doNotify = false;
                    this.state = DLightTarget.State.TERMINATED;
                    log.log(Level.FINE, "NativeTask {0} cancelled!", process.toString());
                    break;
                }
                case ERROR: {
                    doNotify = false;
                    this.state = DLightTarget.State.FAILED;
                    log.log(Level.FINE, "NativeTask {0} finished with error! ", process.toString());
                    break;
                }
                case FINISHED: {
                    doNotify = false;
                    this.state = DLightTarget.State.DONE;
                    this.status = process.exitValue();
                }
            }
            newState = this.state;
        }
        if (doNotify) {
            Integer notificationValue = newState == DLightTarget.State.RUNNING ? Integer.valueOf(this.pid) : this.status;
            this.notifyListeners(new DLightTargetChangeEvent(this, newState, notificationValue));
        }
        if (doResume) {
            this.resume();
        }
    }

    @Override
    public int getExitCode() throws InterruptedException {
        if (this.targetFutureResult != null) {
            try {
                return this.targetFutureResult.get();
            }
            catch (ExecutionException ex) {
                DLightLogger.instance.warning(ex.getMessage());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return -1;
    }

    @Override
    public boolean canBeSubstituted() {
        return true;
    }

    @Override
    public void substitute(String cmd, String[] args) {
        this.cmd = cmd;
        ArrayList<String> allArgs = new ArrayList<String>(Arrays.asList(args));
        allArgs.add(this.templateCMD);
        if (this.templateArgs != null) {
            allArgs.addAll(Arrays.asList(this.templateArgs));
        }
        this.args = allArgs.toArray(new String[0]);
    }

    @Override
    public ExecutionEnvironment getExecEnv() {
        return this.execEnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(DLightTarget.ExecutionEnvVariablesProvider executionEnvProvider) {
        NativeExecutableTarget nativeExecutableTarget = this;
        synchronized (nativeExecutableTarget) {
            NativeExecutionDescriptor descr = new NativeExecutionDescriptor();
            descr = descr.controllable(true).frontWindow(true);
            NativeProcessBuilder pb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.execEnv);
            pb.setExecutable(this.cmd).setArguments(this.args);
            pb.addNativeProcessListener((ChangeListener)this);
            pb.setWorkingDirectory(this.workingDirectory);
            pb.getEnvironment().putAll(this.envs);
            pb.setX11Forwarding(this.x11forwarding);
            if (this.execEnv.isLocal() && this.externalTerminal != null) {
                pb = pb.useExternalTerminal(this.externalTerminal);
                descr = descr.inputVisible(false);
                if (this.io != null) {
                    descr = descr.inputOutput(this.io);
                    this.io.setInputVisible(false);
                }
            } else {
                pb = pb.unbufferOutput(true);
                descr = descr.inputVisible(true);
                if (this.io != null) {
                    descr = descr.inputOutput(this.io);
                    this.io.setInputVisible(true);
                }
            }
            if (this.externalTerminal == null) {
                if (this.outConvertorFactory != null) {
                    descr = descr.outConvertorFactory(this.outConvertorFactory);
                }
                if (this.errConvertorFactory != null) {
                    descr = descr.errConvertorFactory(this.errConvertorFactory);
                }
            }
            if (executionEnvProvider != null) {
                try {
                    executionEnvProvider.setupEnvironment(this, pb.getEnvironment());
                }
                catch (ConnectException ex) {
                    log.severe(ex.getMessage());
                }
            }
            descr = descr.postExecution(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Integer statusToNotify;
                    DLightTarget.State stateToNotify;
                    NativeExecutableTarget nativeExecutableTarget = NativeExecutableTarget.this;
                    synchronized (nativeExecutableTarget) {
                        stateToNotify = NativeExecutableTarget.this.state == null ? DLightTarget.State.FAILED : NativeExecutableTarget.this.state;
                        statusToNotify = NativeExecutableTarget.this.status == null ? Integer.MIN_VALUE : NativeExecutableTarget.this.status;
                    }
                    NativeExecutableTarget.this.notifyListeners(new DLightTargetChangeEvent(NativeExecutableTarget.this, stateToNotify, statusToNotify));
                }
            });
            Charset charset = Charset.defaultCharset();
            String charsetName = this.getInfo(Charset.class.getName());
            if (charsetName != null) {
                try {
                    charset = Charset.forName(charsetName);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            descr.charset(charset);
            NativeExecutionService es = NativeExecutionService.newService((NativeProcessBuilder)pb, (NativeExecutionDescriptor)descr, (String)this.toString());
            this.targetFutureResult = es.run();
        }
    }

    private void resume() {
        CommonTasksSupport.sendSignal((ExecutionEnvironment)this.execEnv, (int)this.pid, (Signal)Signal.SIGCONT, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminate() {
        NativeExecutableTarget nativeExecutableTarget = this;
        synchronized (nativeExecutableTarget) {
            if (this.targetFutureResult != null) {
                this.targetFutureResult.cancel(true);
            }
        }
    }

    private static final class StateLock {
        private StateLock() {
        }
    }

    private static final class NativeExecutableTargetExecutionService
    implements DLightTarget.DLightTargetExecutionService<NativeExecutableTarget> {
        private NativeExecutableTargetExecutionService() {
        }

        @Override
        public InputOutput start(final NativeExecutableTarget target, final DLightTarget.ExecutionEnvVariablesProvider executionEnvProvider) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    target.start(executionEnvProvider);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                DLightExecutorService.submit((Runnable)r, (String)("Start target " + this.toString()));
            } else {
                r.run();
            }
            return target.io;
        }

        @Override
        public void terminate(NativeExecutableTarget target) {
            target.terminate();
        }
    }
}

