/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.converter.wizard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.DocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.commands.CommandCD;
import org.netbeans.modules.vmd.midp.components.displayables.AlertCD;
import org.netbeans.modules.vmd.midp.components.displayables.CanvasCD;
import org.netbeans.modules.vmd.midp.components.displayables.DisplayableCD;
import org.netbeans.modules.vmd.midp.components.displayables.FormCD;
import org.netbeans.modules.vmd.midp.components.displayables.ListCD;
import org.netbeans.modules.vmd.midp.components.displayables.ScreenCD;
import org.netbeans.modules.vmd.midp.components.displayables.TextBoxCD;
import org.netbeans.modules.vmd.midp.components.items.ChoiceGroupCD;
import org.netbeans.modules.vmd.midp.components.items.CustomItemCD;
import org.netbeans.modules.vmd.midp.components.items.DateFieldCD;
import org.netbeans.modules.vmd.midp.components.items.GaugeCD;
import org.netbeans.modules.vmd.midp.components.items.ImageItemCD;
import org.netbeans.modules.vmd.midp.components.items.ItemCD;
import org.netbeans.modules.vmd.midp.components.items.SpacerCD;
import org.netbeans.modules.vmd.midp.components.items.StringItemCD;
import org.netbeans.modules.vmd.midp.components.items.TextFieldCD;
import org.netbeans.modules.vmd.midp.components.resources.TickerCD;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterBuilt;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterDisplayables;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterItem;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterItems;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterResources;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterSVG;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterUtil;
import org.netbeans.modules.vmd.midp.palette.wizard.ComponentInstaller;
import org.netbeans.modules.vmd.midpnb.components.displayables.AbstractInfoScreenCD;
import org.netbeans.modules.vmd.midpnb.components.displayables.SplashScreenCD;
import org.netbeans.modules.vmd.midpnb.components.displayables.WaitScreenCD;
import org.netbeans.modules.vmd.midpnb.components.items.TableItemCD;
import org.netbeans.modules.vmd.midpnb.components.resources.SimpleCancellableTaskCD;
import org.netbeans.modules.vmd.midpnb.components.resources.SimpleTableModelCD;
import org.netbeans.modules.vmd.midpnb.components.svg.SVGAnimatorWrapperCD;
import org.netbeans.modules.vmd.midpnb.components.svg.SVGImageCD;
import org.netbeans.modules.vmd.midpnb.components.svg.SVGMenuCD;
import org.netbeans.modules.vmd.midpnb.components.svg.SVGSplashScreenCD;
import org.netbeans.modules.vmd.midpnb.components.svg.SVGWaitScreenCD;
import org.openide.util.Utilities;

public class ConverterCustom {
    static void loadItemsToRegistry(final List<ConverterItem> list, DesignDocument designDocument) {
        final DescriptorRegistry descriptorRegistry = designDocument.getDescriptorRegistry();
        final HashSet hashSet = new HashSet();
        descriptorRegistry.readAccess(new Runnable(){

            @Override
            public void run() {
                for (ConverterItem converterItem : list) {
                    String string;
                    if (!ConverterCustom.isClassComponent(converterItem) || descriptorRegistry.getComponentDescriptor(new TypeID(TypeID.Kind.COMPONENT, string = converterItem.getTypeID())) != null) continue;
                    hashSet.add(string);
                }
            }
        });
        if (!hashSet.isEmpty()) {
            Map map = ComponentInstaller.search((Project)ProjectUtils.getProject((DesignDocument)designDocument));
            ArrayList<ComponentInstaller.Item> arrayList = new ArrayList<ComponentInstaller.Item>();
            for (String string : hashSet) {
                ComponentInstaller.Item item = (ComponentInstaller.Item)map.get(string);
                if (item == null) continue;
                arrayList.add(item);
            }
            ComponentInstaller.install((Map)map, arrayList);
        }
    }

    static boolean isClassComponent(ConverterItem converterItem) {
        return Utilities.isJavaIdentifier((String)converterItem.getID()) && MidpTypes.isValidFQNClassName((String)converterItem.getTypeID());
    }

    static void convertCustom(HashMap<String, ConverterItem> hashMap, ConverterItem converterItem, DesignDocument designDocument) {
        TypeID typeID = new TypeID(TypeID.Kind.COMPONENT, converterItem.getTypeID());
        ComponentProducer componentProducer = DocumentSupport.getComponentProducer((DesignDocument)designDocument, (String)typeID.toString());
        if (componentProducer == null) {
            return;
        }
        DesignComponent designComponent = designDocument.createComponent(componentProducer.getMainComponentTypeID());
        componentProducer.postInitialize(designDocument, designComponent);
        ConverterCustom.convertCustomProperties(hashMap, converterItem, designComponent, designComponent.getComponentDescriptor());
    }

    private static void convertCustomProperties(HashMap<String, ConverterItem> hashMap, ConverterItem converterItem, DesignComponent designComponent, ComponentDescriptor componentDescriptor) {
        if (componentDescriptor == null) {
            return;
        }
        TypeID typeID = componentDescriptor.getTypeDescriptor().getThisType();
        if (DisplayableCD.TYPEID.equals((Object)typeID)) {
            ConverterDisplayables.convertDisplayable(hashMap, converterItem, designComponent);
        } else if (CanvasCD.TYPEID.equals((Object)typeID)) {
            ConverterDisplayables.convertCanvas(hashMap, converterItem, designComponent);
        } else if (ScreenCD.TYPEID.equals((Object)typeID)) {
            ConverterDisplayables.convertScreen(hashMap, converterItem, designComponent);
        } else if (AlertCD.TYPEID.equals((Object)typeID)) {
            ConverterDisplayables.convertAlertCore(hashMap, converterItem, designComponent);
        } else if (FormCD.TYPEID.equals((Object)typeID)) {
            ConverterDisplayables.convertFormCore(hashMap, converterItem, designComponent);
        } else if (ListCD.TYPEID.equals((Object)typeID)) {
            ConverterDisplayables.convertListCore(hashMap, converterItem, designComponent);
        } else if (TextBoxCD.TYPEID.equals((Object)typeID)) {
            ConverterDisplayables.convertTextBoxCore(hashMap, converterItem, designComponent);
        } else if (ItemCD.TYPEID.equals((Object)typeID)) {
            ConverterItems.convertItem(hashMap, converterItem, designComponent);
        } else if (CustomItemCD.TYPEID.equals((Object)typeID)) {
            ConverterItems.convertCustomItem(hashMap, converterItem, designComponent);
        } else if (DateFieldCD.TYPEID.equals((Object)typeID)) {
            ConverterItems.convertDateFieldCore(hashMap, converterItem, designComponent);
        } else if (ChoiceGroupCD.TYPEID.equals((Object)typeID)) {
            ConverterItems.convertChoiceGroupCore(hashMap, converterItem, designComponent);
        } else if (GaugeCD.TYPEID.equals((Object)typeID)) {
            ConverterItems.convertGaugeCore(hashMap, converterItem, designComponent);
        } else if (ImageItemCD.TYPEID.equals((Object)typeID)) {
            ConverterItems.convertImageItemCore(hashMap, converterItem, designComponent);
        } else if (SpacerCD.TYPEID.equals((Object)typeID)) {
            ConverterItems.convertSpacerCore(hashMap, converterItem, designComponent);
        } else if (StringItemCD.TYPEID.equals((Object)typeID)) {
            ConverterItems.convertStringItemCore(hashMap, converterItem, designComponent);
        } else if (TextFieldCD.TYPEID.equals((Object)typeID)) {
            ConverterItems.convertTextFieldCore(hashMap, converterItem, designComponent);
        } else if (AbstractInfoScreenCD.TYPEID.equals((Object)typeID)) {
            ConverterBuilt.convertAbstractInfoScreen(hashMap, converterItem, designComponent);
        } else if (SimpleCancellableTaskCD.TYPEID.equals((Object)typeID)) {
            ConverterBuilt.convertSimpleCancellableTask(hashMap, converterItem, designComponent.getDocument());
        } else if (SimpleTableModelCD.TYPEID.equals((Object)typeID)) {
            ConverterBuilt.convertSimpleTableModel(hashMap, converterItem, designComponent.getDocument());
        } else if (SplashScreenCD.TYPEID.equals((Object)typeID)) {
            ConverterBuilt.convertSplashScreen(hashMap, converterItem, designComponent.getDocument());
        } else if (TableItemCD.TYPEID.equals((Object)typeID)) {
            ConverterBuilt.convertTableItem(hashMap, converterItem, designComponent.getDocument());
        } else if (WaitScreenCD.TYPEID.equals((Object)typeID)) {
            ConverterBuilt.convertWaitScreen(hashMap, converterItem, designComponent.getDocument());
        } else if (CommandCD.TYPEID.equals((Object)typeID)) {
            ConverterResources.convertCommand(converterItem, designComponent.getDocument());
        } else if (TickerCD.TYPEID.equals((Object)typeID)) {
            ConverterResources.convertTicker(converterItem, designComponent.getDocument());
        } else if (SVGImageCD.TYPEID.equals((Object)typeID)) {
            ConverterSVG.convertImage(hashMap, converterItem, designComponent.getDocument());
        } else if (SVGAnimatorWrapperCD.TYPEID.equals((Object)typeID)) {
            ConverterSVG.convertPlayer(hashMap, converterItem, designComponent.getDocument());
        } else if (SVGMenuCD.TYPEID.equals((Object)typeID)) {
            ConverterSVG.convertMenu(hashMap, converterItem, designComponent.getDocument());
        } else if (SVGSplashScreenCD.TYPEID.equals((Object)typeID)) {
            ConverterSVG.convertSplashScreen(hashMap, converterItem, designComponent.getDocument());
        } else if (SVGWaitScreenCD.TYPEID.equals((Object)typeID)) {
            ConverterSVG.convertWaitScreen(hashMap, converterItem, designComponent.getDocument());
        } else {
            ConverterCustom.convertCustomProperties(hashMap, converterItem, designComponent, componentDescriptor.getSuperDescriptor());
            String string = MidpTypes.getFQNClassName((TypeID)typeID);
            for (PropertyDescriptor propertyDescriptor : componentDescriptor.getPropertyDescriptors()) {
                String string2 = string + "#";
                String string3 = propertyDescriptor.getName();
                if (!string3.startsWith(string2)) continue;
                int n = (string3 = string3.substring(string2.length())).indexOf(35);
                if (n >= 0) {
                    string2 = "%%" + string3.substring(0, n) + "_" + string3.substring(n + 1) + "_";
                    String string4 = null;
                    for (String string5 : converterItem.getPropertyNames()) {
                        if (!string5.startsWith(string2)) continue;
                        string4 = string5;
                        break;
                    }
                    if (string4 == null) continue;
                    ConverterUtil.convertToPropertyValue(designComponent, propertyDescriptor.getName(), propertyDescriptor.getType(), converterItem.getPropertyValue(string4));
                    continue;
                }
                if (!string3.startsWith("set")) continue;
                string3 = string3.substring("set".length());
                if (converterItem.isPropertyValueSet("%" + string3)) {
                    ConverterUtil.convertToPropertyValue(designComponent, propertyDescriptor.getName(), propertyDescriptor.getType(), converterItem.getPropertyValue("%" + string3));
                    continue;
                }
                if (string3.length() <= 0) continue;
                string3 = Character.toLowerCase(string3.charAt(0)) + string3.substring(1);
                if (!converterItem.isPropertyValueSet("%" + string3)) continue;
                ConverterUtil.convertToPropertyValue(designComponent, propertyDescriptor.getName(), propertyDescriptor.getType(), converterItem.getPropertyValue("%" + string3));
            }
        }
    }
}

