/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.instrument.classloading.oc4j;

import java.lang.instrument.ClassFileTransformer;
import oracle.classloader.util.ClassLoaderUtilities;
import oracle.classloader.util.ClassPreprocessor;
import org.springframework.instrument.classloading.LoadTimeWeaver;
import org.springframework.instrument.classloading.oc4j.OC4JClassPreprocessorAdapter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class OC4JLoadTimeWeaver
implements LoadTimeWeaver {
    private final ClassLoader classLoader;

    public OC4JLoadTimeWeaver() {
        this(ClassUtils.getDefaultClassLoader());
    }

    public OC4JLoadTimeWeaver(ClassLoader classLoader) {
        Assert.notNull(classLoader, "ClassLoader must not be null");
        this.classLoader = classLoader;
    }

    public void addTransformer(ClassFileTransformer transformer) {
        Assert.notNull(transformer, "Transformer must not be null");
        OC4JClassPreprocessorAdapter processor = new OC4JClassPreprocessorAdapter(transformer);
        ClassLoaderUtilities.addPreprocessor((ClassLoader)this.classLoader, (ClassPreprocessor)processor);
    }

    public ClassLoader getInstrumentableClassLoader() {
        return this.classLoader;
    }

    public ClassLoader getThrowawayClassLoader() {
        return ClassLoaderUtilities.copy((ClassLoader)this.classLoader);
    }
}

