/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.php.api.editor.PhpBaseElement;
import org.netbeans.modules.php.api.editor.PhpClass;
import org.netbeans.modules.php.api.editor.PhpVariable;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.ParameterElement;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.api.elements.TypeResolver;
import org.netbeans.modules.php.editor.elements.TypeResolverImpl;
import org.netbeans.modules.php.editor.elements.VariableElementImpl;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.CodeMarker;
import org.netbeans.modules.php.editor.model.ConstantElement;
import org.netbeans.modules.php.editor.model.FieldElement;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.IndexScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.Occurence;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.model.impl.AssignmentImpl;
import org.netbeans.modules.php.editor.model.impl.CodeMarkerBuilder;
import org.netbeans.modules.php.editor.model.impl.ConstantElementImpl;
import org.netbeans.modules.php.editor.model.impl.FieldElementImpl;
import org.netbeans.modules.php.editor.model.impl.FileScopeImpl;
import org.netbeans.modules.php.editor.model.impl.FunctionScopeImpl;
import org.netbeans.modules.php.editor.model.impl.IndexScopeImpl;
import org.netbeans.modules.php.editor.model.impl.ModelBuilder;
import org.netbeans.modules.php.editor.model.impl.ModelElementFactory;
import org.netbeans.modules.php.editor.model.impl.NamespaceScopeImpl;
import org.netbeans.modules.php.editor.model.impl.OccurenceBuilder;
import org.netbeans.modules.php.editor.model.impl.ScalarConstantElementImpl;
import org.netbeans.modules.php.editor.model.impl.ScopeImpl;
import org.netbeans.modules.php.editor.model.impl.VarAssignmentImpl;
import org.netbeans.modules.php.editor.model.impl.VariableNameFactory;
import org.netbeans.modules.php.editor.model.impl.VariableNameImpl;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.model.nodes.ClassConstantDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.ConstantDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.PhpDocTypeTagInfo;
import org.netbeans.modules.php.editor.nav.NavUtils;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayElement;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.CatchClause;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ClassName;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.ConstantDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.DoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ForEachStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ForStatement;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionName;
import org.netbeans.modules.php.editor.parser.astnodes.GlobalStatement;
import org.netbeans.modules.php.editor.parser.astnodes.GotoLabel;
import org.netbeans.modules.php.editor.parser.astnodes.GotoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.IfStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Include;
import org.netbeans.modules.php.editor.parser.astnodes.InstanceOfExpression;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.LambdaFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocBlock;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocVarTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPVarComment;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Reference;
import org.netbeans.modules.php.editor.parser.astnodes.ReflectionVariable;
import org.netbeans.modules.php.editor.parser.astnodes.ReturnStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.StaticConstantAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.SwitchStatement;
import org.netbeans.modules.php.editor.parser.astnodes.TryStatement;
import org.netbeans.modules.php.editor.parser.astnodes.UseStatementPart;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.VariableBase;
import org.netbeans.modules.php.editor.parser.astnodes.WhileStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultTreePathVisitor;
import org.netbeans.modules.php.project.api.PhpEditorExtender;
import org.netbeans.modules.php.spi.editor.EditorExtender;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class ModelVisitor
extends DefaultTreePathVisitor {
    private final FileScopeImpl fileScope;
    private Map<VariableNameFactory, Map<String, VariableNameImpl>> vars;
    private final Map<String, List<PhpDocTypeTagInfo>> varTypeComments;
    private volatile OccurenceBuilder occurencesBuilder;
    private volatile CodeMarkerBuilder markerBuilder;
    private final ModelBuilder modelBuilder;
    private final ParserResult info;
    private boolean askForEditorExtensions = true;
    private List<PhpBaseElement> baseElements;
    private static Set<String> recursionDetection = new HashSet<String>();

    public ModelVisitor(ParserResult info) {
        this.fileScope = new FileScopeImpl(info);
        this.varTypeComments = new HashMap<String, List<PhpDocTypeTagInfo>>();
        this.occurencesBuilder = new OccurenceBuilder();
        this.markerBuilder = new CodeMarkerBuilder();
        this.modelBuilder = new ModelBuilder(this.fileScope);
        this.info = info;
        this.baseElements = new ArrayList<PhpBaseElement>();
    }

    public ParserResult getCompilationInfo() {
        return this.info;
    }

    @Override
    public void scan(ASTNode node) {
        super.scan(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PhpBaseElement> extendedElements() {
        ModelVisitor modelVisitor = this;
        synchronized (modelVisitor) {
            if (!this.askForEditorExtensions) {
                return new ArrayList<PhpBaseElement>(this.baseElements);
            }
            this.askForEditorExtensions = false;
        }
        this.baseElements.clear();
        FileObject fileObject = this.fileScope.getFileObject();
        EditorExtender editorExtender = PhpEditorExtender.forFileObject((FileObject)fileObject);
        List elements = editorExtender.getElementsForCodeCompletion(fileObject);
        this.baseElements.addAll(elements);
        if (elements.size() > 0) {
            for (PhpBaseElement element : elements) {
                if (!(element instanceof PhpVariable)) continue;
                assert (element != null);
                PhpVariable phpVariable = (PhpVariable)element;
                Collection<? extends NamespaceScope> declaredNamespaces = this.fileScope.getDeclaredNamespaces();
                for (NamespaceScope namespaceScope : declaredNamespaces) {
                    NamespaceScopeImpl namespaceScope2 = (NamespaceScopeImpl)namespaceScope;
                    if (namespaceScope2 == null) continue;
                    String varName = phpVariable.getName();
                    VariableNameImpl variable = this.findVariable((Scope)namespaceScope, varName);
                    PhpClass type = phpVariable.getType();
                    if (variable != null) {
                        variable.indexedElement = VariableElementImpl.create(varName, phpVariable.getOffset(), phpVariable.getFile(), null, type != null ? TypeResolverImpl.parseTypes(type.getFullyQualifiedName()) : Collections.emptySet());
                        continue;
                    }
                    int offset = namespaceScope2.getOffset();
                    VariableElementImpl var = VariableElementImpl.create(varName, offset, phpVariable.getFile(), null, type != null ? TypeResolverImpl.parseTypes(type.getFullyQualifiedName()) : Collections.emptySet());
                    namespaceScope2.createElement(var);
                }
            }
        }
        return new ArrayList<PhpBaseElement>(this.baseElements);
    }

    @Override
    public void visit(PHPDocTag node) {
        super.visit(node);
        PHPDocTag.Type kind = node.getKind();
        ScopeImpl currentScope = this.modelBuilder.getCurrentScope();
        if (currentScope instanceof TypeScope && kind.equals((Object)PHPDocTag.Type.METHOD)) {
            this.modelBuilder.buildMagicMethod(node, this.occurencesBuilder);
        }
    }

    @Override
    public void visit(ReturnStatement node) {
        ScopeImpl currentScope = this.modelBuilder.getCurrentScope();
        this.markerBuilder.prepare(node, (Scope)currentScope);
        String typeName = null;
        if (currentScope instanceof FunctionScope) {
            FunctionScopeImpl functionScope = (FunctionScopeImpl)currentScope;
            Expression expression = node.getExpression();
            if (expression instanceof ClassInstanceCreation) {
                ClassInstanceCreation instanceCreation = (ClassInstanceCreation)expression;
                ASTNodeInfo<ClassInstanceCreation> inf = ASTNodeInfo.create(instanceCreation);
                typeName = inf.getQualifiedName().toString();
            } else if (expression instanceof VariableBase && (typeName = VariousUtils.extractTypeFroVariableBase((VariableBase)expression)) != null) {
                Collection<? extends VariableName> allVariables = VariousUtils.getAllVariables(functionScope, typeName);
                Map<String, String> var2Type = new HashMap<String, String>();
                for (VariableName variableName : allVariables) {
                    String name = variableName.getName();
                    String type = this.resolveVariableType(name, functionScope, node);
                    if (type == null) {
                        var2Type = Collections.emptyMap();
                        break;
                    }
                    var2Type.put(name, type);
                }
                if (!var2Type.isEmpty()) {
                    typeName = VariousUtils.replaceVarNames(typeName, var2Type);
                }
            }
            if (typeName != null) {
                HashSet<String> types = new HashSet<String>();
                if (functionScope.returnType != null) {
                    String[] split;
                    for (String tp : split = functionScope.returnType.split("\\|")) {
                        types.add(tp);
                    }
                }
                String tp = QualifiedName.create(typeName).toString();
                if (types.isEmpty()) {
                    functionScope.returnType = tp;
                } else if (types.add(tp)) {
                    functionScope.returnType = functionScope.returnType + "|" + tp;
                }
            }
        }
        super.visit(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String resolveVariableType(String varName, FunctionScopeImpl varScope, ReturnStatement node) {
        try {
            if (varName != null && recursionDetection.add(varName)) {
                String typeName;
                AssignmentImpl assignment;
                if (varName.equalsIgnoreCase("$this") && varScope instanceof MethodScope) {
                    String string = varScope.getInScope().getName();
                    return string;
                }
                VariableNameImpl var = (VariableNameImpl)ModelUtils.getFirst(varScope.getDeclaredVariables(), varName);
                if (var != null && (assignment = var.findVarAssignment(node.getStartOffset())) != null && (typeName = assignment.typeNameFromUnion()) != null) {
                    if (!typeName.contains("@")) {
                        String string = typeName;
                        return string;
                    }
                    String variableName = ModelVisitor.getName(typeName, VariousUtils.Kind.VAR, true);
                    if (variableName != null && !variableName.equalsIgnoreCase(varName)) {
                        String string = this.resolveVariableType(variableName, varScope, node);
                        return string;
                    }
                    String string = typeName;
                    return string;
                }
            }
        }
        finally {
            if (varName != null) {
                recursionDetection.remove(varName);
            }
        }
        return null;
    }

    @Override
    public void visit(GotoLabel label) {
        super.visit(label);
        this.occurencesBuilder.prepare(label, this.modelBuilder.getCurrentScope());
    }

    @Override
    public void visit(GotoStatement statement) {
        super.visit(statement);
        this.occurencesBuilder.prepare(statement, this.modelBuilder.getCurrentScope());
    }

    public static String getName(String semiType, VariousUtils.Kind kind, boolean strict) {
        String[] split;
        String prefix;
        if (semiType != null && semiType.startsWith(prefix = "@" + kind.toString()) && (split = semiType.split(prefix, 2)).length > 1) {
            if (split[1].contains("@")) {
                if (strict) {
                    return null;
                }
                if ((split = split[1].split("@")).length < 1) {
                    return null;
                }
                return split[0];
            }
            return split[1];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(Program program) {
        this.modelBuilder.setProgram(program);
        this.fileScope.setBlockRange(program);
        this.vars = new HashMap<VariableNameFactory, Map<String, VariableNameImpl>>();
        try {
            this.prepareVarComments(program);
            super.visit(program);
            this.handleVarComments();
        }
        finally {
            program = null;
        }
    }

    @Override
    public void visit(Include node) {
        this.modelBuilder.build(node, this.occurencesBuilder);
        super.visit(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(NamespaceDeclaration node) {
        this.modelBuilder.build(node, this.occurencesBuilder);
        try {
            super.visit(node);
        }
        finally {
            this.modelBuilder.reset();
        }
    }

    @Override
    public void visit(NamespaceName namespaceName) {
        super.visit(namespaceName);
        this.occurencesBuilder.prepare(ASTNodeInfo.Kind.CONSTANT, namespaceName, (Scope)this.fileScope);
    }

    @Override
    public void visit(UseStatementPart statementPart) {
        ASTNodeInfo<UseStatementPart> info = ASTNodeInfo.create(statementPart);
        this.modelBuilder.getCurrentNameSpace().createUseStatementPart(info);
        super.visit(statementPart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(ClassDeclaration node) {
        this.modelBuilder.build(node, this.occurencesBuilder);
        this.checkComments(node);
        try {
            super.visit(node);
        }
        finally {
            this.modelBuilder.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(InterfaceDeclaration node) {
        this.modelBuilder.build(node, this.occurencesBuilder);
        try {
            super.visit(node);
        }
        finally {
            this.modelBuilder.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(MethodDeclaration node) {
        this.modelBuilder.build(node, this.occurencesBuilder);
        this.markerBuilder.prepare(node, (Scope)this.modelBuilder.getCurrentScope());
        this.checkComments(node);
        try {
            this.scan(node.getFunction().getFormalParameters());
            this.scan(node.getFunction().getBody());
        }
        finally {
            this.modelBuilder.reset();
        }
    }

    @Override
    public void visit(FieldsDeclaration node) {
        this.modelBuilder.build(node, this.occurencesBuilder);
        this.checkComments(node);
        super.visit(node);
    }

    @Override
    public void visit(ClassInstanceCreation node) {
        this.occurencesBuilder.prepare(node, (Scope)this.modelBuilder.getCurrentScope());
        this.scan(node.ctorParams());
    }

    @Override
    public void visit(InstanceOfExpression node) {
        Expression expression;
        this.occurencesBuilder.prepare(node.getClassName(), (Scope)this.modelBuilder.getCurrentScope());
        String clsName = CodeUtils.extractClassName(node.getClassName());
        if (clsName != null && (expression = node.getExpression()) instanceof Variable) {
            Variable var = (Variable)expression;
            ScopeImpl currentScope = this.modelBuilder.getCurrentScope();
            VariableNameImpl varN = this.findVariable((Scope)currentScope, var);
            if (varN != null) {
                varN.addElement(new VarAssignmentImpl(varN, (Scope)currentScope, true, this.getBlockRange(currentScope), ASTNodeInfo.create(var).getRange(), clsName));
            }
        }
        super.visit(node);
    }

    @Override
    public void visit(MethodInvocation node) {
        this.occurencesBuilder.prepare(node, (Scope)this.modelBuilder.getCurrentScope());
        this.scan(node.getDispatcher());
        this.scan(node.getMethod().getParameters());
    }

    @Override
    public void visit(Scalar scalar) {
        String stringValue = scalar.getStringValue();
        if (stringValue != null && stringValue.trim().length() > 0 && scalar.getScalarType() == Scalar.Type.STRING && !NavUtils.isQuoted(stringValue)) {
            this.occurencesBuilder.prepare(ASTNodeInfo.Kind.CONSTANT, scalar, (Scope)this.fileScope);
        }
        super.visit(scalar);
    }

    @Override
    public void visit(StaticMethodInvocation node) {
        ScopeImpl scope = this.modelBuilder.getCurrentScope();
        this.occurencesBuilder.prepare(node, (Scope)scope);
        Expression className = node.getClassName();
        if (className instanceof Variable) {
            this.scan(className);
        } else {
            this.occurencesBuilder.prepare(ASTNodeInfo.Kind.CLASS, node.getClassName(), (Scope)scope);
        }
        this.scan(node.getMethod().getParameters());
    }

    @Override
    public void visit(ClassName node) {
        ScopeImpl scope = this.modelBuilder.getCurrentScope();
        this.occurencesBuilder.prepare(node, (Scope)scope);
    }

    @Override
    public void visit(StaticConstantAccess node) {
        ScopeImpl scope = this.modelBuilder.getCurrentScope();
        this.occurencesBuilder.prepare(node, (Scope)scope);
        this.occurencesBuilder.prepare(ASTNodeInfo.Kind.CLASS, node.getClassName(), (Scope)scope);
        this.occurencesBuilder.prepare(ASTNodeInfo.Kind.IFACE, node.getClassName(), (Scope)scope);
    }

    @Override
    public void visit(ConstantDeclaration node) {
        ScopeImpl scope = this.modelBuilder.getCurrentScope();
        if (scope instanceof NamespaceScope) {
            List<? extends ConstantDeclarationInfo> constantDeclarationInfos = ConstantDeclarationInfo.create(node);
            for (ConstantDeclarationInfo constantDeclarationInfo : constantDeclarationInfos) {
                ConstantElementImpl createElement = this.modelBuilder.getCurrentNameSpace().createElement(constantDeclarationInfo);
                this.occurencesBuilder.prepare(constantDeclarationInfo, (ConstantElement)createElement);
            }
        } else {
            List<? extends ClassConstantDeclarationInfo> constantDeclarationInfos = ClassConstantDeclarationInfo.create(node);
            for (ClassConstantDeclarationInfo classConstantDeclarationInfo : constantDeclarationInfos) {
                this.occurencesBuilder.prepare(classConstantDeclarationInfo, ModelElementFactory.create(classConstantDeclarationInfo, this.modelBuilder));
            }
        }
        super.visit(node);
    }

    @Override
    public void visit(SingleFieldDeclaration node) {
        this.scan(node.getValue());
    }

    @Override
    public void visit(ReflectionVariable node) {
        Expression name = node.getName();
        while (name instanceof ReflectionVariable) {
            ReflectionVariable refName = (ReflectionVariable)name;
            name = refName.getName();
        }
        if (name instanceof Variable) {
            this.scan(name);
        }
    }

    @Override
    public void visit(Variable node) {
        String varName = CodeUtils.extractVariableName(node);
        if (varName == null) {
            return;
        }
        Scope scope = this.modelBuilder.getCurrentScope();
        this.occurencesBuilder.prepare(node, scope);
        if (scope instanceof VariableNameFactory) {
            ASTNodeInfo<Variable> varInfo = ASTNodeInfo.create(node);
            if (scope instanceof MethodScope && varInfo.getName().equals("$this")) {
                scope = scope.getInScope();
            }
            if (scope instanceof VariableNameFactory) {
                this.createVariable((VariableNameFactory)scope, node);
            }
        } else assert (scope instanceof TypeScope) : scope;
        super.visit(node);
    }

    @Override
    public void visit(GlobalStatement node) {
        super.visit(node);
        List<Variable> variables = node.getVariables();
        for (Variable var : variables) {
            ScopeImpl scope;
            String varName = CodeUtils.extractVariableName(var);
            if (varName == null || !((scope = this.modelBuilder.getCurrentScope()) instanceof VariableNameFactory)) continue;
            VariableNameFactory vc = (VariableNameFactory)((Object)scope);
            List<? extends VariableName> variablesImpl = ModelUtils.filter(vc.getDeclaredVariables(), varName);
            VariableNameImpl varElem = (VariableNameImpl)ModelUtils.getFirst(variablesImpl);
            if (varElem != null) {
                varElem.setGloballyVisible(true);
                continue;
            }
            vc = this.modelBuilder.getCurrentNameSpace();
            variablesImpl = ModelUtils.filter(vc.getDeclaredVariables(), varName);
            varElem = (VariableNameImpl)ModelUtils.getFirst(variablesImpl);
            if (varElem == null) continue;
            varElem.setGloballyVisible(true);
        }
    }

    @Override
    public void visit(FieldAccess node) {
        this.occurencesBuilder.prepare(node, (Scope)this.modelBuilder.getCurrentScope());
        Variable field = node.getField();
        if (field instanceof ArrayAccess) {
            ArrayAccess access = (ArrayAccess)field;
            this.scan(access.getIndex());
            VariableBase name = access.getName();
            while (name instanceof ArrayAccess) {
                ArrayAccess access1 = (ArrayAccess)name;
                this.scan(access1.getIndex());
                name = access1.getName();
            }
        }
        this.scan(node.getDispatcher());
    }

    @Override
    public void visit(FunctionName node) {
    }

    private Map<String, AssignmentImpl> getAssignmentMap(Scope scope, VariableBase leftHandSide) {
        HashMap<String, AssignmentImpl> allAssignments = new HashMap<String, AssignmentImpl>();
        if (scope instanceof VariableScope) {
            VariableScope variableScope = (VariableScope)scope;
            Collection<? extends VariableName> declaredVariables = variableScope.getDeclaredVariables();
            for (VariableName variableName : declaredVariables) {
                VariableNameImpl vni;
                AssignmentImpl ai;
                if (!(variableName instanceof VariableNameImpl) || (ai = (vni = (VariableNameImpl)variableName).findVarAssignment(leftHandSide.getStartOffset())) == null) continue;
                allAssignments.put(vni.getName(), ai);
            }
        }
        return allAssignments;
    }

    @Override
    public void visit(Assignment node) {
        ScopeImpl scope = this.modelBuilder.getCurrentScope();
        VariableBase leftHandSide = node.getLeftHandSide();
        Expression rightHandSide = node.getRightHandSide();
        super.scan(leftHandSide);
        if (leftHandSide instanceof Variable) {
            VariableNameImpl varN = this.findVariable((Scope)scope, leftHandSide);
            if (varN != null) {
                Map<String, AssignmentImpl> allAssignments = this.getAssignmentMap(scope, leftHandSide);
                Variable var = (Variable)leftHandSide;
                if (rightHandSide instanceof ArrayCreation) {
                    ArrayCreation arrayCreation = (ArrayCreation)rightHandSide;
                    List<ArrayElement> elements = arrayCreation.getElements();
                    if (!elements.isEmpty()) {
                        for (ArrayElement arrayElement : elements) {
                            Expression expression = arrayElement.getValue();
                            String typeName = VariousUtils.extractVariableTypeFromExpression(expression, allAssignments);
                            ASTNode conditionalNode = this.findConditionalStatement(this.getPath());
                            VarAssignmentImpl vAssignment = new VarAssignmentImpl(varN, (Scope)scope, conditionalNode != null, this.getBlockRange(conditionalNode, scope), new OffsetRange(var.getStartOffset(), var.getEndOffset()), typeName);
                            vAssignment.setAsArrayAccess(true);
                        }
                    } else {
                        String typeName = VariousUtils.extractVariableTypeFromExpression(rightHandSide, allAssignments);
                        ASTNode conditionalNode = this.findConditionalStatement(this.getPath());
                        new VarAssignmentImpl(varN, (Scope)scope, conditionalNode != null, this.getBlockRange(conditionalNode, scope), new OffsetRange(var.getStartOffset(), var.getEndOffset()), typeName);
                    }
                } else {
                    ASTNode conditionalNode = this.findConditionalStatement(this.getPath());
                    varN.createAssignment(scope, conditionalNode != null, this.getBlockRange(conditionalNode, scope), new OffsetRange(var.getStartOffset(), var.getEndOffset()), node, allAssignments);
                }
                this.occurencesBuilder.prepare((Variable)leftHandSide, (Scope)scope);
            }
        } else if (leftHandSide instanceof FieldAccess) {
            FieldAccess fieldAccess = (FieldAccess)leftHandSide;
            VariableNameImpl varN = this.findVariable((Scope)this.modelBuilder.getCurrentScope(), fieldAccess.getDispatcher());
            if (varN != null) {
                varN.createLazyFieldAssignment(fieldAccess, node, scope);
                ClassScope classScope = null;
                ASTNodeInfo<FieldAccess> fieldAccessInfo = ASTNodeInfo.create(fieldAccess);
                if (varN.representsThis()) {
                    if (scope instanceof ClassScope) {
                        classScope = (ClassScope)((Object)scope);
                    } else if (scope.getInScope() instanceof ClassScope) {
                        classScope = (ClassScope)scope.getInScope();
                    }
                } else {
                    Collection<? extends String> typeNames = varN.getTypeNames(fieldAccessInfo.getRange().getStart());
                    HashSet<ElementFilter> filters = new HashSet<ElementFilter>();
                    for (String string : typeNames) {
                        filters.add(ElementFilter.forName(NameKind.exact(QualifiedName.create(string))));
                    }
                    HashSet<? extends ClassScope> declaredClasses = new HashSet<ClassScope>();
                    declaredClasses.addAll(ModelUtils.getDeclaredClasses(this.fileScope));
                    Set set = ElementFilter.anyOf(filters).filter(declaredClasses);
                    if (!set.isEmpty()) {
                        classScope = (ClassScope)set.iterator().next();
                    }
                }
                if (classScope != null) {
                    String name = fieldAccessInfo.getName();
                    if (name == null) {
                        this.showAssertionFor185229(fieldAccessInfo.getOriginalNode());
                    } else {
                        Set declaredFields = new HashSet<FieldElement>();
                        declaredFields.addAll(classScope.getDeclaredFields());
                        declaredFields = ElementFilter.forName(NameKind.exact(name)).filter(declaredFields);
                        if (declaredFields.isEmpty()) {
                            String typeName = VariousUtils.extractVariableTypeFromExpression(rightHandSide, new HashMap<String, AssignmentImpl>());
                            new FieldElementImpl((Scope)classScope, typeName, fieldAccessInfo);
                        }
                    }
                }
            }
        } else if (leftHandSide instanceof StaticFieldAccess) {
            StaticFieldAccess sfa = (StaticFieldAccess)leftHandSide;
        }
        super.scan(rightHandSide);
    }

    private void showAssertionFor185229(FieldAccess originalNode) {
        Variable field;
        boolean showAssertFor185229 = false;
        if (!$assertionsDisabled) {
            showAssertFor185229 = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (showAssertFor185229 && (field = originalNode.getField()) instanceof ReflectionVariable) {
            return;
        }
        if (showAssertFor185229) {
            FileObject fileObject = this.fileScope.getFileObject();
            if (fileObject != null) {
                try {
                    assert (false) : fileObject.asText();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            assert (false);
        }
    }

    @Override
    public void visit(ForEachStatement node) {
        ScopeImpl scope = this.modelBuilder.getCurrentScope();
        super.visit(node);
        Expression expression = node.getExpression();
        Expression value = node.getValue();
        if (expression instanceof Variable && value instanceof Variable) {
            VariableNameImpl varArray = this.findVariable((Scope)scope, (Variable)expression);
            VariableNameImpl varValue = this.findVariable((Scope)scope, (Variable)value);
            if (varArray != null && varValue != null) {
                varValue.setTypeResolutionKind(VariableNameImpl.TypeResolutionKind.MERGE_ASSIGNMENTS);
                Collection<? extends String> typeNames = varArray.getArrayAccessTypeNames(node.getStartOffset());
                for (String string : typeNames) {
                    new VarAssignmentImpl(varValue, (Scope)scope, true, this.getBlockRange(scope), new OffsetRange(value.getStartOffset(), value.getEndOffset()), string);
                }
            }
        }
    }

    @Override
    public void visit(FormalParameter node) {
        Expression parameterName = node.getParameterName();
        Expression parameterType = node.getParameterType();
        ScopeImpl scp = this.modelBuilder.getCurrentScope();
        FunctionScopeImpl fncScope = (FunctionScopeImpl)scp;
        while (parameterName instanceof Reference) {
            Reference ref = (Reference)parameterName;
            Expression expression = ref.getExpression();
            if (!(expression instanceof Variable) && !(expression instanceof Reference)) continue;
            parameterName = expression;
        }
        List<? extends ParameterElement> parameters = fncScope.getParameters();
        if (parameterName instanceof Variable) {
            for (ParameterElement parameterElement : parameters) {
                Set<TypeResolver> types = parameterElement.getTypes();
                String typeName = null;
                for (TypeResolver typeResolver : types) {
                    QualifiedName typeQualifiedName;
                    if (!typeResolver.isResolved() || (typeQualifiedName = typeResolver.getTypeName(false)) == null) continue;
                    typeName = typeQualifiedName.toString();
                }
                VariableNameImpl var = this.createParameter(fncScope, parameterElement);
                if (types.isEmpty() || var == null) continue;
                var.addElement(new VarAssignmentImpl(var, (Scope)fncScope, false, fncScope.getBlockRange(), parameterElement.getOffsetRange(), typeName));
            }
        }
        if (parameterName instanceof Variable) {
            this.occurencesBuilder.prepare(ASTNodeInfo.Kind.CLASS, parameterType, (Scope)fncScope);
            this.occurencesBuilder.prepare(ASTNodeInfo.Kind.IFACE, parameterType, (Scope)fncScope);
            this.occurencesBuilder.prepare((Variable)parameterName, (Scope)fncScope);
        }
        super.visit(node);
    }

    @Override
    public void visit(CatchClause node) {
        VariableNameImpl varNameImpl;
        Variable variable = node.getVariable();
        ScopeImpl scope = this.modelBuilder.getCurrentScope();
        if (scope instanceof VariableNameFactory && (varNameImpl = this.createVariable((VariableNameFactory)((Object)scope), variable)) != null) {
            varNameImpl.addElement(new VarAssignmentImpl(varNameImpl, (Scope)scope, true, new OffsetRange(node.getStartOffset(), node.getEndOffset()), VariableNameImpl.toOffsetRange(variable), CodeUtils.extractUnqualifiedTypeName(node)));
        }
        this.occurencesBuilder.prepare(ASTNodeInfo.Kind.CLASS, node.getClassName(), (Scope)scope);
        this.occurencesBuilder.prepare(variable, (Scope)scope);
        this.scan(node.getBody());
    }

    @Override
    public void visit(LambdaFunctionDeclaration node) {
        ScopeImpl scope = this.modelBuilder.getCurrentScope();
        FunctionScopeImpl fncScope = FunctionScopeImpl.createElement(scope, node);
        scope = fncScope;
        this.modelBuilder.setCurrentScope(scope);
        List<Expression> lexicalVariables = node.getLexicalVariables();
        for (Expression expression : lexicalVariables) {
            if (!(expression instanceof Variable)) continue;
            Variable variable = (Variable)expression;
            VariableNameImpl varNameImpl = this.createVariable((VariableNameFactory)((Object)scope), variable);
            varNameImpl.setGloballyVisible(true);
        }
        this.scan(lexicalVariables);
        scope.setBlockRange(node.getBody());
        this.scan(node.getFormalParameters());
        this.scan(node.getBody());
        this.modelBuilder.reset();
    }

    @Override
    public void visit(FunctionDeclaration node) {
        ScopeImpl scope = this.modelBuilder.getCurrentScope();
        assert (scope != null && (scope instanceof FunctionScope || scope instanceof MethodScope || scope instanceof NamespaceScopeImpl));
        if (scope instanceof NamespaceScopeImpl) {
            NamespaceScopeImpl ps = (NamespaceScopeImpl)scope;
            FunctionScopeImpl fncScope = ps.createElement(this.modelBuilder.getProgram(), node);
            scope = fncScope;
            this.modelBuilder.setCurrentScope(scope);
            this.occurencesBuilder.prepare(node, fncScope);
            this.markerBuilder.prepare(node, (Scope)this.modelBuilder.getCurrentScope());
            this.checkComments(node);
        } else if (!(scope instanceof NamespaceScope)) {
            Scope tmpScope = scope;
            while (!(tmpScope instanceof NamespaceScope)) {
                tmpScope = tmpScope.getInScope();
            }
            if (tmpScope instanceof NamespaceScopeImpl) {
                NamespaceScopeImpl ps = (NamespaceScopeImpl)tmpScope;
                FunctionScopeImpl fncScope = ps.createElement(this.modelBuilder.getProgram(), node);
                scope = fncScope;
                this.modelBuilder.setCurrentScope(scope);
                this.occurencesBuilder.prepare(node, fncScope);
                this.markerBuilder.prepare(node, (Scope)this.modelBuilder.getCurrentScope());
                this.checkComments(node);
            }
        }
        scope.setBlockRange(node.getBody());
        this.scan(node.getFormalParameters());
        this.scan(node.getBody());
        this.modelBuilder.reset();
    }

    @Override
    public void visit(FunctionInvocation node) {
        Scalar scalar;
        Expression d;
        ScopeImpl scope = this.modelBuilder.getCurrentScope();
        this.occurencesBuilder.prepare(node, (Scope)scope);
        ASTNodeInfo<FunctionInvocation> nodeInfo = ASTNodeInfo.create(node);
        String name = nodeInfo.getName();
        if ("define".equals(name) && node.getParameters().size() == 2) {
            Scalar scalar2;
            String value;
            Expression d2 = node.getParameters().get(0);
            if (d2 instanceof Scalar && ((Scalar)d2).getScalarType() == Scalar.Type.STRING && NavUtils.isQuoted(value = (scalar2 = (Scalar)d2).getStringValue())) {
                ASTNodeInfo<Scalar> scalarInfo = ASTNodeInfo.create(ASTNodeInfo.Kind.CONSTANT, scalar2);
                Expression parameterExpression = node.getParameters().get(1);
                String parameterValue = parameterExpression instanceof Scalar ? ((Scalar)parameterExpression).getStringValue() : null;
                ScalarConstantElementImpl constantImpl = this.modelBuilder.getCurrentNameSpace().createConstantElement(scalarInfo, parameterValue);
                this.occurencesBuilder.prepare(scalarInfo, (ConstantElement)constantImpl);
            }
        } else if ("constant".equals(name) && node.getParameters().size() == 1 && (d = node.getParameters().get(0)) instanceof Scalar && (scalar = (Scalar)d).getScalarType() == Scalar.Type.STRING && NavUtils.isQuoted(scalar.getStringValue())) {
            this.occurencesBuilder.prepare(ASTNodeInfo.Kind.CONSTANT, scalar, (Scope)this.fileScope);
        }
        super.visit(node);
    }

    @Override
    public void visit(StaticFieldAccess node) {
        ScopeImpl scope = this.modelBuilder.getCurrentScope();
        this.occurencesBuilder.prepare(node, (Scope)scope);
        this.occurencesBuilder.prepare(ASTNodeInfo.Kind.CLASS, node.getClassName(), (Scope)scope);
        Variable field = node.getField();
        if (field instanceof ArrayAccess) {
            ArrayAccess access = (ArrayAccess)field;
            this.scan(access.getIndex());
            VariableBase name = access.getName();
            while (name instanceof ArrayAccess) {
                ArrayAccess access1 = (ArrayAccess)name;
                this.scan(access1.getIndex());
                name = access1.getName();
            }
        }
    }

    @Override
    public void visit(PHPDocTypeTag node) {
        this.occurencesBuilder.prepare(node, (Scope)this.modelBuilder.getCurrentScope());
        super.visit(node);
    }

    @Override
    public void visit(PHPDocVarTypeTag node) {
        ScopeImpl currentScope = this.modelBuilder.getCurrentScope();
        StringBuilder sb = new StringBuilder();
        List<? extends PhpDocTypeTagInfo> tagInfos = PhpDocTypeTagInfo.create((PHPDocTypeTag)node, currentScope);
        Iterator<? extends PhpDocTypeTagInfo> it = tagInfos.iterator();
        while (it.hasNext()) {
            String typeName;
            PhpDocTypeTagInfo phpDocTypeTagInfo = it.next();
            if (phpDocTypeTagInfo.getKind().equals((Object)ASTNodeInfo.Kind.FIELD)) {
                typeName = phpDocTypeTagInfo.getTypeName();
                if (typeName != null) {
                    if (sb.length() > 0) {
                        sb.append("|");
                    }
                    sb.append(typeName);
                }
                if (!(currentScope instanceof ClassScope) || it.hasNext()) continue;
                new FieldElementImpl((Scope)currentScope, sb.length() > 0 ? sb.toString() : null, phpDocTypeTagInfo);
                continue;
            }
            if (!node.getKind().equals((Object)PHPDocTag.Type.GLOBAL) || !phpDocTypeTagInfo.getKind().equals((Object)ASTNodeInfo.Kind.VARIABLE)) continue;
            typeName = phpDocTypeTagInfo.getTypeName();
            String varName = phpDocTypeTagInfo.getName();
            VariableScope variableScope = this.getVariableScope(node.getStartOffset());
            if (variableScope == null) continue;
            VariableNameImpl varN = this.findVariable((Scope)variableScope, varName);
            if (varN == null && variableScope instanceof VariableNameFactory) {
                VariableNameFactory factory = (VariableNameFactory)variableScope;
                OffsetRange nameRange = new OffsetRange(node.getStartOffset(), node.getEndOffset());
                varN = new VariableNameImpl((Scope)factory, varName, variableScope.getFile(), nameRange, true);
            }
            if (varN == null) continue;
            varN.addElement(new VarAssignmentImpl(varN, (Scope)variableScope, false, variableScope.getBlockRange(), varN.getNameRange(), typeName));
        }
        this.occurencesBuilder.prepare(node, (Scope)currentScope);
        super.visit(node);
    }

    public FileScope getFileScope() {
        return this.fileScope;
    }

    @CheckForNull
    public CodeMarker getCodeMarker(int offset) {
        this.buildCodeMarks(offset);
        return this.findStrictCodeMarker((FileScopeImpl)this.getFileScope(), offset, null);
    }

    private void checkComments(ASTNode node) {
        block4: {
            Comment comment;
            block3: {
                Comment comment2 = comment = node instanceof Comment ? (Comment)node : Utils.getCommentForNode(this.modelBuilder.getProgram(), node);
                if (!(comment instanceof PHPDocBlock)) break block3;
                PHPDocBlock phpDoc = (PHPDocBlock)comment;
                for (PHPDocTag tag : phpDoc.getTags()) {
                    this.scan(tag);
                }
                break block4;
            }
            if (!(comment instanceof PHPVarComment)) break block4;
            PHPDocVarTypeTag typeTag = ((PHPVarComment)comment).getVariable();
            List<? extends PhpDocTypeTagInfo> tagInfos = PhpDocTypeTagInfo.create((PHPDocTypeTag)typeTag, this.fileScope);
            for (PhpDocTypeTagInfo phpDocTypeTagInfo : tagInfos) {
                if (!phpDocTypeTagInfo.getKind().equals((Object)ASTNodeInfo.Kind.VARIABLE)) continue;
                String name = phpDocTypeTagInfo.getName();
                List<PhpDocTypeTagInfo> infos = this.varTypeComments.get(name);
                if (infos == null) {
                    infos = new ArrayList<PhpDocTypeTagInfo>();
                    this.varTypeComments.put(name, infos);
                }
                infos.add(phpDocTypeTagInfo);
            }
        }
    }

    private VariableNameImpl findVariable(Scope scope, String varName) {
        VariableNameImpl retval = null;
        if (varName != null) {
            Map<String, VariableNameImpl> varnames = this.vars.get(scope);
            while (scope != null && (varnames == null || (retval = varnames.get(varName)) == null)) {
                scope = scope.getInScope();
                varnames = this.vars.get(scope);
            }
        }
        return retval;
    }

    private VariableNameImpl findVariable(Scope scope, VariableBase leftHandSide) {
        String varName = null;
        if (leftHandSide instanceof Variable) {
            varName = VariableNameImpl.toName((Variable)leftHandSide);
        }
        return varName != null ? this.findVariable(scope, varName) : null;
    }

    private VariableNameImpl createParameter(FunctionScopeImpl fncScope, ParameterElement parameter) {
        String name;
        VariableNameImpl varInstance;
        FunctionScopeImpl varContainer = fncScope;
        Map<String, VariableNameImpl> map = this.vars.get(varContainer);
        if (map == null) {
            map = new HashMap<String, VariableNameImpl>();
            this.vars.put(varContainer, map);
        }
        if ((varInstance = map.get(name = parameter.getName())) == null && ModelUtils.filter(varContainer.getDeclaredVariables(), name).isEmpty()) {
            varInstance = new VariableNameImpl((Scope)fncScope, name, fncScope.getFile(), parameter.getOffsetRange(), false);
            fncScope.addElement(varInstance);
            map.put(name, varInstance);
        }
        return varInstance;
    }

    private VariableNameImpl createVariable(VariableNameFactory varContainer, Variable node) {
        String name;
        VariableNameImpl retval;
        Map<String, VariableNameImpl> map = this.vars.get(varContainer);
        if (map == null) {
            map = new HashMap<String, VariableNameImpl>();
            this.vars.put(varContainer, map);
        }
        if ((retval = map.get(name = VariableNameImpl.toName(node))) == null && ModelUtils.filter(varContainer.getDeclaredVariables(), name).isEmpty()) {
            retval = varContainer.createElement(node);
            map.put(name, retval);
        }
        return retval;
    }

    @CheckForNull
    private ASTNode findConditionalStatement(List<ASTNode> path) {
        for (ASTNode aSTNode : path) {
            if (aSTNode instanceof IfStatement) {
                return aSTNode;
            }
            if (aSTNode instanceof WhileStatement) {
                return aSTNode;
            }
            if (aSTNode instanceof DoStatement) {
                return aSTNode;
            }
            if (aSTNode instanceof ForEachStatement) {
                return aSTNode;
            }
            if (aSTNode instanceof ForStatement) {
                return aSTNode;
            }
            if (aSTNode instanceof CatchClause) {
                return aSTNode;
            }
            if (aSTNode instanceof SwitchStatement) {
                return aSTNode;
            }
            if (aSTNode instanceof TryStatement) {
                return aSTNode;
            }
            if (!(aSTNode instanceof InstanceOfExpression)) continue;
            return aSTNode;
        }
        return null;
    }

    private CodeMarker findStrictCodeMarker(FileScopeImpl scope, int offset, CodeMarker atOffset) {
        List<? extends CodeMarker> markers = scope.getMarkers();
        for (CodeMarker codeMarker : markers) {
            assert (codeMarker != null);
            if (!codeMarker.getOffsetRange().containsInclusive(offset)) continue;
            atOffset = codeMarker;
        }
        return atOffset;
    }

    @CheckForNull
    public Occurence getOccurence(int offset) {
        if (this.occurencesBuilder != null) {
            return this.occurencesBuilder.build(this.fileScope, offset);
        }
        return null;
    }

    @CheckForNull
    public List<Occurence> getOccurence(ModelElement element) {
        if (this.occurencesBuilder != null) {
            return this.occurencesBuilder.build(this.fileScope, element);
        }
        return Collections.emptyList();
    }

    public ModelElement findDeclaration(PhpElement element) {
        int offset = element.getOffset();
        List<? extends ModelElement> elements = ModelUtils.getElements(this.getFileScope(), true);
        for (ModelElement modelElement : elements) {
            if (!modelElement.getNameRange().overlaps(new OffsetRange(offset, offset + element.getName().length()))) continue;
            return modelElement;
        }
        return null;
    }

    public VariableScope getNearestVariableScope(int offset) {
        return this.findNearestVarScope((FileScopeImpl)this.getFileScope(), offset, null);
    }

    public VariableScope getVariableScope(int offset) {
        Scope retval = null;
        ArrayList<? extends ModelElement> elements = new ArrayList<ModelElement>();
        elements.add(this.getFileScope());
        elements.addAll(ModelUtils.getElements(this.getFileScope(), true));
        for (ModelElement modelElement : elements) {
            if (modelElement instanceof VariableScope) {
                VariableScope varScope = (VariableScope)modelElement;
                OffsetRange blockRange = varScope.getBlockRange();
                if (blockRange == null || !blockRange.containsInclusive(offset) || retval != null && !retval.getBlockRange().overlaps(varScope.getBlockRange())) continue;
                retval = varScope;
                continue;
            }
            if (!(modelElement instanceof ClassScope)) continue;
            ClassScope clsScope = (ClassScope)modelElement;
            Collection<? extends MethodScope> allMethods = clsScope.getDeclaredMethods();
            for (MethodScope methodScope : allMethods) {
                OffsetRange blockRange = methodScope.getBlockRange();
                if (blockRange == null || !blockRange.containsInclusive(offset) || retval != null && !retval.getBlockRange().overlaps(methodScope.getBlockRange())) continue;
                retval = methodScope;
            }
        }
        return retval;
    }

    public static IndexScope getIndexScope(ParserResult info) {
        return new IndexScopeImpl(info);
    }

    public static IndexScope getIndexScope(ElementQuery.Index idx) {
        return new IndexScopeImpl(idx);
    }

    private void buildCodeMarks(int offset) {
        if (this.markerBuilder != null) {
            this.fileScope.clearMarkers();
            this.markerBuilder.build(this.fileScope, offset);
        }
    }

    private VariableScope findNearestVarScope(Scope scope, int offset, VariableScope atOffset) {
        List<? extends ModelElement> elements = scope.getElements();
        for (ModelElement modelElement : elements) {
            VariableScope variableScope;
            OffsetRange blockRange;
            FileObject fileObject;
            if (modelElement instanceof ClassScope || modelElement instanceof NamespaceScope) {
                atOffset = this.findNearestVarScope((Scope)modelElement, offset, atOffset);
            }
            if (!(modelElement instanceof VariableScope) || modelElement.getNameRange().getStart() > offset || atOffset != null && atOffset.getOffset() >= modelElement.getOffset() || !(modelElement instanceof VariableScope) || (fileObject = modelElement.getFileObject()) != scope.getFileObject() || (blockRange = (variableScope = (VariableScope)modelElement).getBlockRange()) != null && !blockRange.containsInclusive(offset)) continue;
            atOffset = variableScope;
        }
        if (atOffset == null) {
            OffsetRange blockRange;
            while (scope != null && !(scope instanceof VariableScope)) {
                scope = scope.getInScope();
            }
            if (scope != null && ((blockRange = scope.getBlockRange()) == null || blockRange.containsInclusive(offset))) {
                atOffset = (VariableScope)scope;
            }
        }
        return atOffset;
    }

    private OffsetRange getBlockRange(Scope currentScope) {
        ASTNode conditionalNode = this.findConditionalStatement(this.getPath());
        return this.getBlockRange(conditionalNode, currentScope);
    }

    private OffsetRange getBlockRange(ASTNode conditionalNode, Scope currentScope) {
        OffsetRange scopeRange = conditionalNode != null ? new OffsetRange(conditionalNode.getStartOffset(), conditionalNode.getEndOffset()) : currentScope.getBlockRange();
        return scopeRange;
    }

    private void handleVarComments() {
        Set<String> varCommentNames = this.varTypeComments.keySet();
        for (String name : varCommentNames) {
            List<PhpDocTypeTagInfo> varComments = this.varTypeComments.get(name);
            if (varComments == null) continue;
            for (PhpDocTypeTagInfo phpDocTypeTagInfo : varComments) {
                VariableScope varScope = this.getVariableScope(phpDocTypeTagInfo.getRange().getStart());
                VariableNameImpl varInstance = null;
                if (varScope instanceof Scope) {
                    VariableScope scp = varScope;
                    varInstance = (VariableNameImpl)ModelUtils.getFirst(ModelUtils.filter(varScope.getDeclaredVariables(), name));
                    if (varInstance == null) {
                        varInstance = new VariableNameImpl((Scope)scp, name, scp.getFile(), phpDocTypeTagInfo.getRange(), scp instanceof NamespaceScopeImpl);
                    }
                }
                if (varInstance != null) {
                    ASTNode conditionalNode = this.findConditionalStatement(this.getPath());
                    VarAssignmentImpl vAssignment = new VarAssignmentImpl(varInstance, (Scope)varScope, conditionalNode != null, this.getBlockRange(varScope), phpDocTypeTagInfo.getRange(), phpDocTypeTagInfo.getTypeName());
                    varInstance.addElement(vAssignment);
                }
                this.occurencesBuilder.prepare(phpDocTypeTagInfo.getTypeTag(), (Scope)varScope);
            }
        }
    }

    private void prepareVarComments(Program program) {
        List<Comment> comments = program.getComments();
        for (Comment comment : comments) {
            Comment.Type type = comment.getCommentType();
            if (!type.equals((Object)Comment.Type.TYPE_VARTYPE)) continue;
            this.checkComments(comment);
        }
    }
}

