/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.indent;

import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.spi.editor.bracesmatching.BracesMatcher;
import org.netbeans.spi.editor.bracesmatching.MatcherContext;

public final class PHPBracesMatcher
implements BracesMatcher {
    MatcherContext context;

    public PHPBracesMatcher(MatcherContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findOrigin() throws InterruptedException, BadLocationException {
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            BaseDocument doc = (BaseDocument)this.context.getDocument();
            int offset = this.context.getSearchOffset();
            TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, offset);
            if (ts != null) {
                ts.move(offset);
                if (!ts.moveNext()) {
                    int[] nArray = null;
                    return nArray;
                }
                Token token = ts.token();
                if (token == null) {
                    int[] nArray = null;
                    return nArray;
                }
                TokenId id = token.id();
                if (LexUtilities.textEquals(token.text(), '(')) {
                    int[] nArray = new int[]{ts.offset(), ts.offset() + token.length()};
                    return nArray;
                }
                if (LexUtilities.textEquals(token.text(), ')')) {
                    int[] nArray = new int[]{ts.offset(), ts.offset() + token.length()};
                    return nArray;
                }
                if (id == PHPTokenId.PHP_CURLY_OPEN) {
                    int[] nArray = new int[]{ts.offset(), ts.offset() + token.length()};
                    return nArray;
                }
                if (id == PHPTokenId.PHP_CURLY_CLOSE) {
                    int[] nArray = new int[]{ts.offset(), ts.offset() + token.length()};
                    return nArray;
                }
                if (LexUtilities.textEquals(token.text(), '[')) {
                    int[] nArray = new int[]{ts.offset(), ts.offset() + token.length()};
                    return nArray;
                }
                if (LexUtilities.textEquals(token.text(), ']')) {
                    int[] nArray = new int[]{ts.offset(), ts.offset() + token.length()};
                    return nArray;
                }
            }
            int[] nArray = null;
            return nArray;
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findMatches() throws InterruptedException, BadLocationException {
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            BaseDocument doc = (BaseDocument)this.context.getDocument();
            int offset = this.context.getSearchOffset();
            TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, offset);
            if (ts != null) {
                ts.move(offset);
                if (!ts.moveNext()) {
                    int[] nArray = null;
                    return nArray;
                }
                Token token = ts.token();
                if (token == null) {
                    int[] nArray = null;
                    return nArray;
                }
                TokenId id = token.id();
                if (LexUtilities.textEquals(token.text(), '(')) {
                    OffsetRange r = LexUtilities.findFwd(doc, ts, PHPTokenId.PHP_TOKEN, '(', PHPTokenId.PHP_TOKEN, ')');
                    int[] nArray = new int[]{r.getStart(), r.getEnd()};
                    return nArray;
                }
                if (LexUtilities.textEquals(token.text(), ')')) {
                    OffsetRange r = LexUtilities.findBwd(doc, ts, PHPTokenId.PHP_TOKEN, '(', PHPTokenId.PHP_TOKEN, ')');
                    int[] nArray = new int[]{r.getStart(), r.getEnd()};
                    return nArray;
                }
                if (id == PHPTokenId.PHP_CURLY_OPEN) {
                    OffsetRange r = LexUtilities.findFwd(doc, ts, PHPTokenId.PHP_CURLY_OPEN, '{', PHPTokenId.PHP_CURLY_CLOSE, '}');
                    int[] nArray = new int[]{r.getStart(), r.getEnd()};
                    return nArray;
                }
                if (id == PHPTokenId.PHP_CURLY_CLOSE) {
                    OffsetRange r = LexUtilities.findBwd(doc, ts, PHPTokenId.PHP_CURLY_OPEN, '{', PHPTokenId.PHP_CURLY_CLOSE, '}');
                    int[] nArray = new int[]{r.getStart(), r.getEnd()};
                    return nArray;
                }
                if (LexUtilities.textEquals(token.text(), '[')) {
                    OffsetRange r = LexUtilities.findFwd(doc, ts, PHPTokenId.PHP_TOKEN, '[', PHPTokenId.PHP_TOKEN, ']');
                    int[] nArray = new int[]{r.getStart(), r.getEnd()};
                    return nArray;
                }
                if (LexUtilities.textEquals(token.text(), ']')) {
                    OffsetRange r = LexUtilities.findBwd(doc, ts, PHPTokenId.PHP_TOKEN, '[', PHPTokenId.PHP_TOKEN, ']');
                    int[] nArray = new int[]{r.getStart(), r.getEnd()};
                    return nArray;
                }
            }
            int[] nArray = null;
            return nArray;
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
    }
}

