/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.context;

import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpUtils;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.ServletWrapper;
import org.apache.tomcat.util.StringManager;

class RedirectHandler
extends ServletWrapper {
    static StringManager sm = StringManager.getManager("org.apache.tomcat.resources");

    RedirectHandler() {
        this.initialized = true;
        this.internal = true;
        this.name = "tomcat.redirectHandler";
    }

    public void doService(Request req, Response res) throws Exception {
        String location = (String)req.getAttribute("javax.servlet.error.message");
        Context ctx = req.getContext();
        location = this.makeAbsolute(req, location);
        if (this.debug > 0) {
            ctx.log("Redirect " + location + " " + req);
        }
        res.setContentType("text/html");
        res.setHeader("Location", location);
        StringBuffer buf = new StringBuffer();
        buf.append("<head><title>").append(sm.getString("defaulterrorpage.documentmoved")).append("</title></head>\r\n<body><h1>").append(sm.getString("defaulterrorpage.documentmoved")).append("</h1>\r\n").append(sm.getString("defaulterrorpage.thisdocumenthasmoved")).append(" <a href=\"").append(location).append("\">here</a>.<p>\r\n</body>\r\n");
        String body = buf.toString();
        res.setContentLength(body.length());
        if (res.isUsingStream()) {
            ServletOutputStream out = res.getOutputStream();
            out.print(body);
            out.flush();
        } else {
            PrintWriter out = res.getWriter();
            out.print(body);
            out.flush();
        }
    }

    private String makeAbsolute(Request req, String location) {
        URL url = null;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException malformedURLException) {
            String requrl = HttpUtils.getRequestURL((HttpServletRequest)req.getFacade()).toString();
            try {
                url = new URL(new URL(requrl), location);
            }
            catch (MalformedURLException malformedURLException2) {
                return location;
            }
        }
        return url.toString();
    }
}

