/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.url;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.url.Parser;
import org.netbeans.spi.editor.highlighting.HighlightsChangeListener;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsLayer;
import org.netbeans.spi.editor.highlighting.HighlightsLayerFactory;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.ZOrder;

public final class HighlightURLs
implements HighlightsContainer {
    private static final Logger LOG = Logger.getLogger(HighlightURLs.class.getName());
    private final BaseDocument doc;
    private final AttributeSet coloring;

    public HighlightURLs(BaseDocument doc) {
        this.doc = doc;
        String mimeType = DocumentUtilities.getMimeType((Document)doc);
        FontColorSettings fcs = mimeType == null ? null : (FontColorSettings)MimeLookup.getLookup((String)mimeType).lookup(FontColorSettings.class);
        this.coloring = fcs == null ? null : fcs.getTokenFontColors("url");
    }

    public HighlightsSequence getHighlights(int startOffset, int endOffset) {
        if (this.coloring == null) {
            return HighlightsSequence.EMPTY;
        }
        LinkedList<int[]> highlights = new LinkedList<int[]>();
        try {
            startOffset = Utilities.getRowStart((BaseDocument)this.doc, (int)startOffset);
            endOffset = Math.min(this.doc.getLength(), endOffset);
            endOffset = Utilities.getRowEnd((BaseDocument)this.doc, (int)endOffset);
            CharSequence text = DocumentUtilities.getText((Document)this.doc, (int)startOffset, (int)(endOffset - startOffset));
            for (int[] span : Parser.recognizeURLs(text)) {
                highlights.add(new int[]{startOffset + span[0], startOffset + span[1]});
            }
            return new SeqImpl(highlights, this.coloring);
        }
        catch (BadLocationException e) {
            LOG.log(Level.WARNING, null, e);
            return HighlightsSequence.EMPTY;
        }
    }

    public void addHighlightsChangeListener(HighlightsChangeListener listener) {
    }

    public void removeHighlightsChangeListener(HighlightsChangeListener listener) {
    }

    public static final class FactoryImpl
    implements HighlightsLayerFactory {
        public HighlightsLayer[] createLayers(HighlightsLayerFactory.Context context) {
            Document doc = context.getDocument();
            if (!(doc instanceof BaseDocument)) {
                return null;
            }
            HighlightURLs c = new HighlightURLs((BaseDocument)doc);
            return new HighlightsLayer[]{HighlightsLayer.create((String)HighlightURLs.class.getName(), (ZOrder)ZOrder.SYNTAX_RACK.forPosition(4950), (boolean)false, (HighlightsContainer)c)};
        }
    }

    private static final class SeqImpl
    implements HighlightsSequence {
        private int[] current;
        private final List<int[]> highlights;
        private final AttributeSet as;

        public SeqImpl(List<int[]> highlights, AttributeSet as) {
            this.highlights = highlights;
            this.as = as;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("SeqImpl:");
                for (int[] span : highlights) {
                    LOG.fine("span: " + span[0] + "-" + span[1]);
                }
            }
        }

        public boolean moveNext() {
            if (this.highlights.isEmpty()) {
                return false;
            }
            this.current = this.highlights.remove(0);
            return true;
        }

        public int getStartOffset() {
            return this.current[0];
        }

        public int getEndOffset() {
            return this.current[1];
        }

        public AttributeSet getAttributes() {
            return this.as;
        }
    }
}

