/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.OpenProjectListSettings;
import org.netbeans.modules.project.ui.ProjectChooserAccessory;
import org.netbeans.modules.project.ui.ProjectUtilities;
import org.netbeans.modules.project.ui.actions.BasicAction;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public class OpenProject
extends BasicAction {
    private static final String DISPLAY_NAME = NbBundle.getMessage(OpenProject.class, (String)"LBL_OpenProjectAction_Name");
    private static final String _SHORT_DESCRIPTION = NbBundle.getMessage(OpenProject.class, (String)"LBL_OpenProjectAction_Tooltip");

    public OpenProject() {
        super(DISPLAY_NAME, ImageUtilities.loadImageIcon((String)"org/netbeans/modules/project/ui/resources/openProject.png", (boolean)false));
        this.putValue("iconBase", "org/netbeans/modules/project/ui/resources/openProject.png");
        this.putValue("ShortDescription", _SHORT_DESCRIPTION);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Project mainProject;
        Project[] projectsArray;
        OpenProjectListSettings opls;
        JFileChooser chooser;
        Project projectToExpand;
        block7: {
            int option;
            projectToExpand = null;
            chooser = ProjectChooserAccessory.createProjectChooser(true);
            chooser.setMultiSelectionEnabled(true);
            for (DataObject d : Utilities.actionsGlobalContext().lookupAll(DataObject.class)) {
                File dir;
                Project selected = FileOwnerQuery.getOwner((FileObject)d.getPrimaryFile());
                if (selected == null || OpenProjectList.getDefault().isOpen(selected) || (dir = FileUtil.toFile((FileObject)selected.getProjectDirectory())) == null) continue;
                chooser.setCurrentDirectory(dir.getParentFile());
                chooser.setSelectedFiles(new File[]{dir});
                break;
            }
            opls = OpenProjectListSettings.getInstance();
            while ((option = chooser.showOpenDialog(WindowManager.getDefault().getMainWindow())) == 0) {
                File[] projectDirs = chooser.isMultiSelectionEnabled() ? chooser.getSelectedFiles() : new File[]{chooser.getSelectedFile()};
                ArrayList<Project> projects = new ArrayList<Project>(projectDirs.length);
                for (File d : projectDirs) {
                    Project p = OpenProjectList.fileToProject(FileUtil.normalizeFile((File)d));
                    if (p == null) continue;
                    projects.add(p);
                }
                if (projects.isEmpty()) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(OpenProject.class, (String)"MSG_notProjectDir"), 2));
                    continue;
                }
                projectsArray = new Project[projects.size()];
                projects.toArray(projectsArray);
                mainProject = null;
                if (opls.isOpenAsMain() && projectsArray.length == 1) {
                    mainProject = projectsArray[0];
                }
                if (projectsArray.length == 1) {
                    projectToExpand = projectsArray[0];
                }
                break block7;
            }
            return;
        }
        OpenProjectList.getDefault().open(projectsArray, opls.isOpenSubprojects(), true, mainProject);
        ProjectUtilities.makeProjectTabVisible();
        if (projectToExpand != null) {
            ProjectUtilities.selectAndExpandProject(projectToExpand);
        }
        opls.setLastOpenProjectDir(chooser.getCurrentDirectory().getPath());
    }
}

