/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.io.providers;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.DesignDocumentAwareness;
import org.netbeans.modules.vmd.api.io.providers.IOSupport;
import org.netbeans.modules.vmd.api.io.serialization.DocumentErrorHandler;
import org.netbeans.modules.vmd.api.io.serialization.DocumentErrorHandlerSupport;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.DocumentInterface;
import org.netbeans.modules.vmd.io.DocumentInterfaceImpl;
import org.netbeans.modules.vmd.io.DocumentLoad;
import org.netbeans.modules.vmd.io.DocumentSave;
import org.openide.ErrorManager;
import org.openide.awt.UndoRedo;
import org.openide.util.RequestProcessor;

public final class DocumentSerializer {
    private CopyOnWriteArrayList<DesignDocumentAwareness> listeners;
    private DataObjectContext context;
    private DesignDocument document;
    private UndoRedo.Manager undoRedoManager;
    private ArrayList<WeakReference<DocumentInterface>> documentInterfaces = new ArrayList();
    private volatile boolean loaded = false;
    private volatile boolean loading = false;
    private Runnable loader = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DataObjectContext context = DocumentSerializer.this.context;
            if (context == null || context.getProjectType() == null) {
                return;
            }
            DocumentSerializer.this.undoRedoManager.discardAllEdits();
            DocumentInterfaceImpl loadingDocumentInterface = new DocumentInterfaceImpl(context, DocumentSerializer.this.undoRedoManager);
            DocumentSerializer.this.documentInterfaces.add(new WeakReference<DocumentInterfaceImpl>(loadingDocumentInterface));
            DesignDocument loadingDocument = new DesignDocument((DocumentInterface)loadingDocumentInterface);
            DocumentErrorHandler errorHandler = new DocumentErrorHandler();
            DocumentLoad.load(context, loadingDocument, errorHandler);
            if (!errorHandler.getErrors().isEmpty()) {
                DocumentErrorHandlerSupport.showDocumentErrorHandlerDialog(errorHandler, context.getDataObject().getPrimaryFile());
                IOSupport.getCloneableEditorSupport(context.getDataObject()).close();
                return;
            }
            if (!errorHandler.getWarnings().isEmpty()) {
                DocumentErrorHandlerSupport.showDocumentErrorHandlerDialog(errorHandler, context.getDataObject().getPrimaryFile());
            }
            IOSupport.resetCodeResolver(context.getDataObject(), loadingDocument);
            loadingDocumentInterface.enable();
            DocumentSerializer documentSerializer = DocumentSerializer.this;
            synchronized (documentSerializer) {
                if (DocumentSerializer.this.context == null) {
                    return;
                }
                DocumentSerializer.this.document = loadingDocument;
                DocumentSerializer.this.loaded = true;
                DocumentSerializer.this.loading = false;
                DocumentSerializer.this.notifyAll();
            }
            DocumentSerializer.this.fireDesignDocumentAwareness(DocumentSerializer.this.document);
        }
    };

    DocumentSerializer(DataObjectContext context) {
        this.context = context;
        this.listeners = new CopyOnWriteArrayList();
        this.undoRedoManager = new UndoRedo.Manager();
    }

    public DesignDocument getDocument() {
        this.startLoadingDocument();
        return this.getActualDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DesignDocument getActualDocument() {
        DocumentSerializer documentSerializer = this;
        synchronized (documentSerializer) {
            return this.document;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLoadingOrLoaded() {
        DocumentSerializer documentSerializer = this;
        synchronized (documentSerializer) {
            return this.loading || this.loaded;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startLoadingDocument() {
        DocumentSerializer documentSerializer = this;
        synchronized (documentSerializer) {
            if (this.loaded || this.loading) {
                return;
            }
            this.loading = true;
            RequestProcessor.getDefault().post(this.loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartLoadingDocument() {
        DocumentSerializer documentSerializer = this;
        synchronized (documentSerializer) {
            this.loaded = false;
            this.startLoadingDocument();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitDocumentLoaded() {
        this.startLoadingDocument();
        try {
            DocumentSerializer documentSerializer = this;
            synchronized (documentSerializer) {
                if (this.loaded) {
                    return;
                }
                if (this.loading) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDocument() {
        DesignDocument savingDocument;
        this.waitDocumentLoaded();
        DocumentSerializer documentSerializer = this;
        synchronized (documentSerializer) {
            savingDocument = this.document;
        }
        savingDocument.getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                DocumentSave.save(DocumentSerializer.this.context, savingDocument);
            }
        });
    }

    public void addDesignDocumentAwareness(DesignDocumentAwareness listener) {
        this.listeners.add(listener);
        listener.setDesignDocument(this.getActualDocument());
    }

    public void removeDesignDocumentAwareness(DesignDocumentAwareness listener) {
        this.listeners.remove(listener);
    }

    private void fireDesignDocumentAwareness(DesignDocument newDocument) {
        for (DesignDocumentAwareness listener : this.listeners) {
            listener.setDesignDocument(newDocument);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UndoRedo.Manager getUndoRedoManager() {
        DocumentSerializer documentSerializer = this;
        synchronized (documentSerializer) {
            return this.undoRedoManager;
        }
    }

    public String getProjectType() {
        return DocumentLoad.loadProjectType(this.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyDataObjectClosed() {
        DocumentSerializer documentSerializer = this;
        synchronized (documentSerializer) {
            this.document = null;
            this.undoRedoManager = null;
            this.context = null;
        }
        this.fireDesignDocumentAwareness(null);
        this.listeners.clear();
    }

    boolean hasDocumentInterface(DocumentInterface documentInterface) {
        if (documentInterface == null) {
            return false;
        }
        for (WeakReference<DocumentInterface> ref : this.documentInterfaces) {
            if (ref.get() != documentInterface) continue;
            return true;
        }
        return false;
    }
}

