/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.io;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.EventListener;
import java.util.Set;
import org.netbeans.modules.vmd.api.io.DataEditorView;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.DesignDocumentAwareness;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.common.ActiveDocumentSupport;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakSet;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class ActiveViewSupport {
    private static final String MODE_EDITOR = "editor";
    private static final ActiveViewSupport support = new ActiveViewSupport();
    private final WeakSet<Listener> listeners = new WeakSet();
    private ActiveViewObserver topComponentListener = null;
    private DataObjectContext context = null;
    private final ActiveDocumentObserver awereness = new ActiveDocumentObserver();

    private ActiveViewSupport() {
        if (this.topComponentListener == null) {
            this.topComponentListener = new ActiveViewObserver();
            TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this.topComponentListener);
        }
    }

    public static ActiveViewSupport getDefault() {
        return support;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActiveViewListener(Listener listener) {
        WeakSet<Listener> weakSet = this.listeners;
        synchronized (weakSet) {
            this.listeners.add((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActiveViewListener(Listener listener) {
        WeakSet<Listener> weakSet = this.listeners;
        synchronized (weakSet) {
            this.listeners.remove((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataEditorView getActiveView() {
        WeakSet<Listener> weakSet = this.listeners;
        synchronized (weakSet) {
            return this.topComponentListener != null ? this.topComponentListener.activeView : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActiveViewChanged(DataEditorView deactivatedView, DataEditorView activatedView) {
        DataObjectContext newContext;
        Listener[] activeViewListeners;
        WeakSet<Listener> weakSet = this.listeners;
        synchronized (weakSet) {
            activeViewListeners = (Listener[])this.listeners.toArray((Object[])new Listener[this.listeners.size()]);
        }
        for (Listener listener : activeViewListeners) {
            if (listener == null) continue;
            listener.activeViewChanged(deactivatedView, activatedView);
        }
        DataObjectContext dataObjectContext = newContext = activatedView != null ? activatedView.getContext() : null;
        if (this.context != newContext) {
            if (this.context != null) {
                this.context.removeDesignDocumentAwareness(this.awereness);
            }
            this.context = newContext;
            if (this.context != null) {
                this.context.addDesignDocumentAwareness(this.awereness);
            } else {
                this.awereness.setDesignDocument(null);
            }
        }
    }

    private static Mode findEditorMode() {
        Set modes = WindowManager.getDefault().getModes();
        for (Object o : modes) {
            Mode m = (Mode)o;
            if (m == null || !MODE_EDITOR.equals(m.getName())) continue;
            return m;
        }
        return null;
    }

    public static interface Listener
    extends EventListener {
        public void activeViewChanged(DataEditorView var1, DataEditorView var2);
    }

    private class ActiveDocumentObserver
    implements DesignDocumentAwareness {
        private ActiveDocumentObserver() {
        }

        @Override
        public void setDesignDocument(DesignDocument designDocument) {
            ActiveDocumentSupport.getDefault().setActiveDocument(designDocument);
        }
    }

    private class ActiveViewObserver
    implements PropertyChangeListener,
    LookupListener {
        private Lookup.Result<DataEditorView> result;
        private DataEditorView activeView;

        private ActiveViewObserver() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            TopComponent component;
            if (!"activated".equals(evt.getPropertyName())) {
                return;
            }
            Mode m = ActiveViewSupport.findEditorMode();
            TopComponent topComponent = component = m != null ? m.getSelectedTopComponent() : null;
            if (this.result != null) {
                this.result.removeLookupListener((LookupListener)this);
            }
            Lookup.Result<DataEditorView> result = this.result = component != null ? component.getLookup().lookupResult(DataEditorView.class) : null;
            if (this.result != null) {
                this.result.addLookupListener((LookupListener)this);
            }
            this.update();
        }

        public void resultChanged(LookupEvent ev) {
            this.update();
        }

        private void update() {
            Collection dataEditorViews;
            DataEditorView lastView = this.activeView;
            this.activeView = this.result != null ? ((dataEditorViews = this.result.allInstances()).isEmpty() ? null : (DataEditorView)dataEditorViews.iterator().next()) : null;
            if (lastView != this.activeView) {
                ActiveViewSupport.this.fireActiveViewChanged(lastView, this.activeView);
            }
        }
    }
}

