/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api.elements;

import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.groovy.editor.api.GroovyIndex;
import org.netbeans.modules.groovy.editor.api.elements.IndexedElement;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;

public class IndexedField
extends IndexedElement {
    private final String name;
    private final String type;
    private boolean inherited;
    private boolean smart;

    private IndexedField(String name, String type, GroovyIndex index, IndexResult result, String classFqn, String attributes, int flags) {
        super(index, result, classFqn, attributes, flags);
        this.name = name;
        this.type = type;
    }

    public static IndexedField create(GroovyIndex index, String name, String type, String classFqn, IndexResult result, String attributes, int flags) {
        IndexedField m = new IndexedField(name, type, index, result, classFqn, attributes, flags);
        return m;
    }

    public boolean isSmart() {
        return this.smart;
    }

    public void setSmart(boolean smart) {
        this.smart = smart;
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.FIELD;
    }

    @Override
    public String getSignature() {
        return this.classFqn + "#" + this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexedField other = (IndexedField)obj;
        if (!(this.name == other.name || this.name != null && this.name.equals(other.name))) {
            return false;
        }
        if (!(this.classFqn == other.classFqn || this.classFqn != null && this.classFqn.equals(other.classFqn))) {
            return false;
        }
        return this.flags == other.flags;
    }

    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 43 * hash + (this.classFqn != null ? this.classFqn.hashCode() : 0);
        hash = 53 * hash + this.flags;
        return hash;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public void setInherited(boolean inherited) {
        this.inherited = inherited;
    }

    public boolean isProperty() {
        int separatorIndex;
        if (this.attributes != null && (separatorIndex = this.attributes.indexOf(59)) != -1) {
            return Boolean.parseBoolean(this.attributes.substring(separatorIndex + 1));
        }
        return false;
    }

    public static String decodeFlags(int flags) {
        return IndexedElement.decodeFlags(flags);
    }
}

