/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.javadoc.search.DocIndexItem;
import org.netbeans.modules.javadoc.search.IndexSearch;
import org.netbeans.modules.javadoc.search.IndexSearchThread;
import org.netbeans.modules.javadoc.search.JavadocRegistry;
import org.netbeans.modules.javadoc.search.JavadocSearchEngine;
import org.netbeans.modules.javadoc.search.JavadocSearchType;
import org.netbeans.modules.javadoc.search.NoJavadocException;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

final class JavadocSearchEngineImpl
extends JavadocSearchEngine {
    private final List<IndexSearchThread> tasks = new ArrayList<IndexSearchThread>();
    private IndexSearchThread.DocIndexItemConsumer diiConsumer;
    private boolean isStopped = false;

    JavadocSearchEngineImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void search(String[] stringArray, final JavadocSearchEngine.SearchEngineCallback searchEngineCallback) throws NoJavadocException {
        IndexSearchThread[] indexSearchThreadArray;
        this.diiConsumer = new IndexSearchThread.DocIndexItemConsumer(){

            @Override
            public void addDocIndexItem(DocIndexItem docIndexItem) {
                searchEngineCallback.addItem(docIndexItem);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void indexSearchThreadFinished(IndexSearchThread indexSearchThread) {
                boolean bl;
                JavadocSearchEngineImpl javadocSearchEngineImpl = JavadocSearchEngineImpl.this;
                synchronized (javadocSearchEngineImpl) {
                    IndexSearch.LOG.log(Level.FINE, "JavadocSearchEngineImpl.indexSearchThreadFinished: tasks: {0}", JavadocSearchEngineImpl.this.tasks.size());
                    JavadocSearchEngineImpl.this.tasks.remove(indexSearchThread);
                    bl = JavadocSearchEngineImpl.this.tasks.isEmpty();
                }
                if (bl) {
                    searchEngineCallback.finished();
                }
            }
        };
        FileObject[] fileObjectArray = JavadocRegistry.getDefault().getDocRoots();
        Object object2 = this;
        synchronized (object2) {
            if (this.isStopped) {
                return;
            }
        }
        if (fileObjectArray.length <= 0) {
            searchEngineCallback.finished();
            throw new NoJavadocException();
        }
        object2 = stringArray[0];
        for (int i = 0; i < fileObjectArray.length; ++i) {
            JavadocSearchType object = JavadocRegistry.getDefault().findSearchType(fileObjectArray[i]);
            if (object == null) {
                ErrorManager.getDefault().log("NO Search type for " + fileObjectArray[i]);
                continue;
            }
            FileObject fileObject = object.getDocFileObject(fileObjectArray[i]);
            if (fileObject == null) {
                ErrorManager.getDefault().log("NO Index files fot " + fileObjectArray[i]);
                continue;
            }
            IndexSearchThread indexSearchThread = object.getSearchThread((String)object2, fileObject, this.diiConsumer);
            JavadocSearchEngineImpl javadocSearchEngineImpl = this;
            synchronized (javadocSearchEngineImpl) {
                if (this.isStopped) {
                    return;
                }
                this.tasks.add(indexSearchThread);
                continue;
            }
        }
        JavadocSearchEngineImpl javadocSearchEngineImpl = this;
        synchronized (javadocSearchEngineImpl) {
            indexSearchThreadArray = this.tasks.toArray(new IndexSearchThread[this.tasks.size()]);
        }
        for (IndexSearchThread indexSearchThread : indexSearchThreadArray) {
            if (this.isStopped) {
                return;
            }
            indexSearchThread.go();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        IndexSearchThread[] indexSearchThreadArray = null;
        IndexSearchThread[] indexSearchThreadArray2 = this;
        synchronized (this) {
            if (this.isStopped) {
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
            this.isStopped = true;
            boolean bl = this.tasks.isEmpty();
            if (!bl) {
                indexSearchThreadArray = this.tasks.toArray(new IndexSearchThread[this.tasks.size()]);
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            IndexSearch.LOG.fine("JavadocSearchEngineImpl.stop");
            if (bl) {
                this.diiConsumer.indexSearchThreadFinished(null);
                return;
            }
            for (IndexSearchThread indexSearchThread : indexSearchThreadArray) {
                indexSearchThread.finish();
            }
            return;
        }
    }
}

