/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.indent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.editor.structure.formatting.JoinedTokenSequence;
import org.netbeans.modules.editor.structure.formatting.TagBasedLexerFormatter;
import org.netbeans.modules.xml.text.folding.TokenElement;

public class XMLLexerFormatter
extends TagBasedLexerFormatter {
    private static final String TAG_OPENING_PREFIX = "<";
    private static final String TAG_CLOSING_PREFIX = "</";
    private final LanguagePath languagePath;
    private int spacesPerTab = 4;

    public XMLLexerFormatter(LanguagePath languagePath) {
        this.languagePath = languagePath;
    }

    protected boolean isOpeningTag(JoinedTokenSequence jts, int tagTokenOffset) {
        Token token = this.getTokenAtOffset(jts, tagTokenOffset);
        return token != null && token.id() == XMLTokenId.TAG && ((Object)token.text()).toString().startsWith(TAG_OPENING_PREFIX) && !((Object)token.text()).toString().startsWith(TAG_CLOSING_PREFIX);
    }

    protected boolean isClosingTag(JoinedTokenSequence jts, int tagTokenOffset) {
        Token token = this.getTokenAtOffset(jts, tagTokenOffset);
        return token != null && token.id() == XMLTokenId.TAG && ((Object)token.text()).toString().startsWith(TAG_CLOSING_PREFIX);
    }

    protected boolean areTagNamesEqual(String tagName1, String tagName2) {
        return tagName1.equalsIgnoreCase(tagName2);
    }

    protected boolean isClosingTagRequired(BaseDocument doc, String tagName) {
        return true;
    }

    protected boolean isUnformattableToken(JoinedTokenSequence jts, int tagTokenOffset) {
        Token token = this.getTokenAtOffset(jts, tagTokenOffset);
        return token.id() == XMLTokenId.BLOCK_COMMENT || token.id() == XMLTokenId.CDATA_SECTION;
    }

    protected boolean isUnformattableTag(String tag) {
        return false;
    }

    protected boolean isTopLevelLanguage(BaseDocument doc) {
        return true;
    }

    protected LanguagePath supportedLanguagePath() {
        return this.languagePath;
    }

    protected String extractTagName(JoinedTokenSequence jts, int tagTokenOffset) {
        Token token = this.getTokenAtOffset(jts, tagTokenOffset);
        String tagImage = ((Object)token.text()).toString();
        int startIndex = -1;
        if (this.isOpeningTag(jts, tagTokenOffset)) {
            startIndex = TAG_OPENING_PREFIX.length();
        } else if (this.isClosingTag(jts, tagTokenOffset)) {
            startIndex = TAG_CLOSING_PREFIX.length();
        }
        if (startIndex >= 0) {
            String tagName = tagImage.substring(startIndex);
            return tagName;
        }
        return null;
    }

    protected int getTagEndingAtPosition(JoinedTokenSequence jts, int position) throws BadLocationException {
        if (position >= 0) {
            int originalOffset = jts.offset();
            jts.move(position);
            jts.moveNext();
            Token token = jts.token();
            if (token.id() == XMLTokenId.TAG && !((Object)token.text()).toString().endsWith("/>")) {
                while (jts.movePrevious()) {
                    int tokenOffset = jts.offset();
                    if (!this.isOpeningTag(jts, tokenOffset) && !this.isClosingTag(jts, tokenOffset)) continue;
                    int r = jts.offset();
                    jts.move(originalOffset);
                    jts.moveNext();
                    return r;
                }
            }
            jts.move(originalOffset);
            jts.moveNext();
        }
        return -1;
    }

    protected int getTagEndOffset(JoinedTokenSequence jts, int tagStartOffset) {
        boolean thereAreMoreTokens;
        int originalOffset = jts.offset();
        jts.move(tagStartOffset);
        jts.moveNext();
        jts.moveNext();
        for (thereAreMoreTokens = true; thereAreMoreTokens && jts.token().id() != XMLTokenId.TAG; thereAreMoreTokens &= jts.moveNext()) {
        }
        int r = jts.offset() + jts.token().length();
        jts.move(originalOffset);
        jts.moveNext();
        return thereAreMoreTokens ? r : -1;
    }

    protected int getOpeningSymbolOffset(JoinedTokenSequence jts, int tagTokenOffset) {
        int originalOffset = jts.offset();
        jts.move(tagTokenOffset);
        boolean thereAreMoreTokens = true;
        while ((thereAreMoreTokens = jts.movePrevious()) && jts.token().id() != XMLTokenId.TAG) {
        }
        if (thereAreMoreTokens) {
            int r = jts.offset();
            jts.move(originalOffset);
            jts.moveNext();
            return r;
        }
        jts.move(originalOffset);
        jts.moveNext();
        return -1;
    }

    public void reformat(Context context, final int startOffset, final int endOffset) throws BadLocationException {
        final BaseDocument doc = (BaseDocument)context.document();
        doc.render(new Runnable(){

            @Override
            public void run() {
                XMLLexerFormatter.this.doReformat(doc, startOffset, endOffset);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseDocument doReformat(BaseDocument doc, int startOffset, int endOffset) {
        this.spacesPerTab = IndentUtils.indentLevelSize((Document)doc);
        try {
            List<TokenIndent> tags = this.getTags(doc, startOffset, endOffset);
            for (int i = tags.size() - 1; i >= 0; --i) {
                if (tags.get(i).isPreserveIndent()) continue;
                TokenElement tag = tags.get(i).getToken();
                int so = tag.getStartOffset();
                int lineOffset = Utilities.getLineOffset((BaseDocument)doc, (int)so);
                String tagName = tag.getName();
                if (tagName.startsWith(TAG_CLOSING_PREFIX)) {
                    Element docElem = doc.getDefaultRootElement().getElement(lineOffset);
                    String lineStr = doc.getText(docElem.getStartOffset(), docElem.getEndOffset() - docElem.getStartOffset());
                    int ndx = lineStr.lastIndexOf(tagName);
                    if (ndx == -1) continue;
                    int ndx2 = (lineStr = lineStr.substring(0, ndx)).lastIndexOf(TAG_OPENING_PREFIX + tagName.substring(2));
                    if (ndx2 == -1) {
                        this.changePrettyText(doc, tag, so);
                        continue;
                    }
                    if ((ndx2 = (lineStr = lineStr.substring(ndx2 + 1)).indexOf(TAG_OPENING_PREFIX)) == -1) continue;
                    this.changePrettyText(doc, tag, so);
                    continue;
                }
                this.changePrettyText(doc, tag, so);
            }
        }
        catch (BadLocationException ble) {
        }
        catch (IOException iox) {
        }
        return doc;
    }

    private void changePrettyText(BaseDocument doc, TokenElement tag, int so) throws BadLocationException {
        String newIndentText = IndentUtils.createIndentString((Document)doc, (int)(tag.getIndentLevel() * this.spacesPerTab));
        int previousEndOffset = Utilities.getFirstNonWhiteBwd((BaseDocument)doc, (int)so) + 1;
        String temp = doc.getText(previousEndOffset, so - previousEndOffset);
        if (temp.indexOf("\n") != -1) {
            int i = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)so);
            int rowStart = Utilities.getRowStart((BaseDocument)doc, (int)so);
            doc.insertString(so, newIndentText, null);
            doc.remove(rowStart, i - rowStart);
        } else {
            doc.insertString(so, "\n" + newIndentText, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TokenIndent> getTags(BaseDocument basedoc, int startOffset, int endOffset) throws BadLocationException, IOException {
        ArrayList<TokenIndent> tags = new ArrayList<TokenIndent>();
        LinkedList<Boolean> preserveNesting_outdent = new LinkedList<Boolean>();
        preserveNesting_outdent.add(Boolean.FALSE);
        boolean preserveWhitespace = false;
        boolean settingSpaceValue = false;
        int indentLevel = -1;
        basedoc.readLock();
        try {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)basedoc);
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
            Token token = tokenSequence.token();
            if (token != null && token.id() == XMLTokenId.TEXT && tokenSequence.moveNext()) {
                token = tokenSequence.token();
            }
            int currentTokensSize = 0;
            Stack stack = new Stack();
            while (tokenSequence.moveNext()) {
                token = tokenSequence.token();
                XMLTokenId tokenId = (XMLTokenId)token.id();
                String image = ((Object)token.text()).toString();
                if (tokenSequence.offset() > endOffset) {
                    break;
                }
                boolean tokenInSelectionRange = tokenSequence.offset() >= startOffset;
                TokenElement.TokenType tokenType = TokenElement.TokenType.TOKEN_WHITESPACE;
                switch (tokenId) {
                    case TAG: {
                        TokenElement tag;
                        int len = image.length();
                        if (image.charAt(len - 1) == '>') {
                            if (len != 2) break;
                            if (!preserveWhitespace) {
                                --indentLevel;
                            }
                            if (stack.empty()) break;
                            stack.pop();
                            break;
                        }
                        tokenType = TokenElement.TokenType.TOKEN_ELEMENT_START_TAG;
                        if (image.startsWith(TAG_CLOSING_PREFIX)) {
                            int begin = currentTokensSize;
                            int end = begin + image.length();
                            boolean preservingWhitespaceOnClose = (Boolean)preserveNesting_outdent.removeLast();
                            if (indentLevel < 0) {
                                indentLevel = 0;
                            }
                            if (tokenInSelectionRange) {
                                tag = new TokenElement(tokenType, image, begin, end, indentLevel);
                                tags.add(new TokenIndent(tag, preservingWhitespaceOnClose));
                            }
                            if (!preserveNesting_outdent.isEmpty() && !((Boolean)preserveNesting_outdent.getLast()).booleanValue()) {
                                --indentLevel;
                            }
                        } else {
                            String tagName = image.substring(1);
                            int begin = currentTokensSize;
                            int end = begin + image.length();
                            boolean bl = preserveWhitespace = !preserveNesting_outdent.isEmpty() && (Boolean)preserveNesting_outdent.getLast() != false;
                            if (!preserveWhitespace) {
                                ++indentLevel;
                            }
                            preserveNesting_outdent.add(preserveWhitespace);
                            if (tokenInSelectionRange) {
                                tag = new TokenElement(tokenType, tagName, begin, end, indentLevel);
                                tags.add(new TokenIndent(tag, preserveWhitespace));
                            }
                        }
                        settingSpaceValue = false;
                        break;
                    }
                    case BLOCK_COMMENT: 
                    case CDATA_SECTION: 
                    case PI_START: 
                    case PI_TARGET: 
                    case PI_CONTENT: 
                    case PI_END: 
                    case TEXT: 
                    case CHARACTER: 
                    case WS: 
                    case OPERATOR: 
                    case DECLARATION: {
                        break;
                    }
                    case ARGUMENT: {
                        settingSpaceValue = token.text().equals("xml:space");
                        break;
                    }
                    case VALUE: {
                        if (!settingSpaceValue) break;
                        if (token.text().equals("\"preserve\"")) {
                            preserveWhitespace = true;
                        } else if (token.text().equals("\"default\"")) {
                            preserveWhitespace = false;
                        }
                        preserveNesting_outdent.set(preserveNesting_outdent.size() - 1, preserveWhitespace);
                        settingSpaceValue = false;
                        break;
                    }
                    default: {
                        throw new IOException("Invalid token found in document: Please use the text editor to resolve the issues...");
                    }
                }
                currentTokensSize += image.length();
            }
        }
        finally {
            basedoc.readUnlock();
        }
        return tags;
    }

    public boolean isOneLiner(int start, int end, BaseDocument doc) {
        try {
            return Utilities.getLineOffset((BaseDocument)doc, (int)start) == Utilities.getLineOffset((BaseDocument)doc, (int)end);
        }
        catch (BadLocationException ex) {
            return false;
        }
    }

    private class TokenIndent {
        private TokenElement token;
        private boolean preserveIndent;

        public TokenIndent(TokenElement token, boolean preserveIndent) {
            this.token = token;
            this.preserveIndent = preserveIndent;
        }

        public TokenElement getToken() {
            return this.token;
        }

        public boolean isPreserveIndent() {
            return this.preserveIndent;
        }

        public void setPreserveIndent(boolean preserveIndent) {
            this.preserveIndent = preserveIndent;
        }

        public String toString() {
            return "TokenIndent: name=" + this.token.getName() + " preserveIndent=" + this.preserveIndent;
        }
    }
}

