/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.inspector;

import org.netbeans.modules.vmd.api.inspector.InspectorFolderPath;
import org.netbeans.modules.vmd.inspector.InspectorFolderWrapper;
import org.openide.nodes.Node;

final class DebugInspector {
    private static String tabs = "";
    private static final String space = "     ";
    private static Node childTest;

    DebugInspector() {
    }

    static void printPath(InspectorFolderPath path) {
        System.out.println("InspectorPath" + path.toString());
    }

    static void printFoldersTree(InspectorFolderWrapper folderWrapper) {
        tabs = "";
        System.out.println((Object)folderWrapper.getNode());
        System.out.println(tabs + "  -Node children =:" + folderWrapper.getNode().getChildren().getNodesCount());
        DebugInspector.deepDive(folderWrapper);
    }

    private static void deepDive(InspectorFolderWrapper parentFolderWrapper) {
        if (parentFolderWrapper.getChildren() == null) {
            return;
        }
        tabs = tabs + space;
        for (InspectorFolderWrapper folderWrapper : parentFolderWrapper.getChildren()) {
            System.out.println(tabs + "|-" + folderWrapper);
            System.out.println(tabs + "  -Node children =:" + folderWrapper.getNode().getChildren().getNodesCount());
            if (folderWrapper.getChildren() == null) continue;
            DebugInspector.deepDive(folderWrapper);
        }
        tabs = tabs.replaceFirst(space, "");
    }

    static void printNodesTree(Node parentNode) {
        tabs = "";
        System.out.println(parentNode);
        System.out.println(tabs + "  -Node children =:" + parentNode.getChildren().getNodesCount());
        DebugInspector.deepDive(parentNode);
    }

    private static void deepDive(Node parentNode) {
        tabs = tabs + space;
        for (Node node : parentNode.getChildren().getNodes()) {
            System.out.println(tabs + "|-" + node.getDisplayName() + " " + node);
            System.out.println(tabs + "  -Node children =:" + node.getChildren().getNodesCount());
            if (node.getChildren().getNodes().length <= 0) continue;
            DebugInspector.deepDive(node);
        }
        tabs = tabs.replaceFirst(space, "");
    }

    static void checkRootNode(Node rootNode, Node child) {
        childTest = child;
        System.out.println("Test start: root node: " + rootNode + " child: " + child);
        DebugInspector.checkParent(rootNode, child);
    }

    private static void checkParent(Node rootNode, Node child) {
        if (child.getParentNode() != null) {
            DebugInspector.checkParent(rootNode, child.getParentNode());
        } else if (child == rootNode) {
            System.out.println("Node: " + rootNode + " is root node of node : " + childTest);
        } else {
            System.out.println("Node: " + rootNode + " is NOT root node of node : " + childTest + " real root node: " + child);
        }
    }
}

