/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jackpot.spi;

import java.util.Arrays;
import java.util.Collection;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.java.hints.jackpot.spi.CustomizerProvider;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.openide.util.NbBundle;

public class HintMetadata {
    public final String id;
    public final String displayName;
    public final String description;
    public final String category;
    public final boolean enabled;
    public final Kind kind;
    public final AbstractHint.HintSeverity severity;
    public final Collection<? extends String> suppressWarnings;
    public final CustomizerProvider customizer;
    public final boolean showInTaskList = false;

    HintMetadata(String id, String displayName, String description, String category, boolean enabled, Kind kind, AbstractHint.HintSeverity severity, CustomizerProvider customizer, Collection<? extends String> suppressWarnings) {
        this.id = id;
        this.displayName = displayName;
        this.description = description;
        this.category = category;
        this.enabled = enabled;
        this.kind = kind;
        this.severity = severity;
        this.customizer = customizer;
        this.suppressWarnings = suppressWarnings;
    }

    public static HintMetadata create(String id, String displayName, String description, String category, boolean enabled, Kind kind, AbstractHint.HintSeverity severity, Collection<? extends String> suppressWarnings) {
        return HintMetadata.create(id, displayName, description, category, enabled, kind, severity, null, suppressWarnings);
    }

    public static HintMetadata create(String id, String displayName, String description, String category, boolean enabled, Kind kind, AbstractHint.HintSeverity severity, CustomizerProvider customizer, Collection<? extends String> suppressWarnings) {
        return new HintMetadata(id, displayName, description, category, enabled, kind, severity, customizer, suppressWarnings);
    }

    public static HintMetadata create(String id, String bundleForFQN, String category, boolean enabled, AbstractHint.HintSeverity severity, Kind kind, String ... suppressWarnings) {
        return HintMetadata.create(id, bundleForFQN, category, enabled, severity, kind, suppressWarnings);
    }

    public static HintMetadata create(String id, String bundleForFQN, String category, boolean enabled, AbstractHint.HintSeverity severity, Kind kind, CustomizerProvider customizer, String ... suppressWarnings) {
        ResourceBundle bundle;
        try {
            int lastDot = bundleForFQN.lastIndexOf(46);
            assert (lastDot >= 0);
            bundle = NbBundle.getBundle((String)(bundleForFQN.substring(0, lastDot + 1) + "Bundle"));
        }
        catch (MissingResourceException mre) {
            Logger.getLogger(HintMetadata.class.getName()).log(Level.FINE, null, mre);
            bundle = null;
        }
        return HintMetadata.create(id, bundle, category, enabled, severity, kind, customizer, suppressWarnings);
    }

    public static HintMetadata create(String id, ResourceBundle bundle, String category, boolean enabled, AbstractHint.HintSeverity severity, Kind kind, CustomizerProvider customizer, String ... suppressWarnings) {
        String displayName = HintMetadata.lookup(bundle, "DN_" + id, "No Display Name");
        String description = HintMetadata.lookup(bundle, "DESC_" + id, "No Description");
        return new HintMetadata(id, displayName, description, category, enabled, kind, severity, customizer, Arrays.asList(suppressWarnings));
    }

    private static String lookup(ResourceBundle bundle, String key, String def) {
        try {
            return bundle != null ? bundle.getString(key) : def;
        }
        catch (MissingResourceException mre) {
            Logger.getLogger(HintMetadata.class.getName()).log(Level.FINE, null, mre);
            return def;
        }
    }

    public static enum Kind {
        HINT,
        HINT_NON_GUI,
        SUGGESTION,
        SUGGESTION_NON_GUI;

    }
}

