/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.management.api.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.datafilter.DataFilterListener;

public class SessionDataFiltersSupport {
    private final Lock lock = new Lock();
    private final List<DataFilter> filters = new ArrayList<DataFilter>();
    private final Collection<DataFilterListener> listeners = new ArrayList<DataFilterListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilter(DataFilter filter, boolean isAdjusting) {
        Lock lock = this.lock;
        synchronized (lock) {
            if (this.filters.add(filter)) {
                this.notifyListeners(isAdjusting);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFilter(DataFilter filter) {
        Lock lock = this.lock;
        synchronized (lock) {
            boolean result = this.filters.remove(filter);
            if (result) {
                this.notifyListeners(false);
            }
            return result;
        }
    }

    public List<DataFilter> getFilters() {
        return this.filters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends DataFilter> Collection<T> getDataFilter(Class<T> clazz) {
        DataFilter[] filters_array;
        Lock lock = this.lock;
        synchronized (lock) {
            filters_array = this.filters.toArray(new DataFilter[0]);
        }
        ArrayList<T> result = new ArrayList<T>();
        for (DataFilter f : filters_array) {
            if (f.getClass() == clazz) {
                result.add(clazz.cast(f));
                continue;
            }
            try {
                Class<T> r = f.getClass().asSubclass(clazz);
                result.add(clazz.cast(f));
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanAll() {
        Lock lock = this.lock;
        synchronized (lock) {
            this.filters.clear();
            this.notifyListeners(false);
        }
    }

    public void cleanAll(Class clazz) {
        this.cleanAll(clazz, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanAll(Class clazz, boolean notify) {
        Lock lock = this.lock;
        synchronized (lock) {
            ArrayList<DataFilter> toRemove = new ArrayList<DataFilter>();
            for (DataFilter f : this.filters) {
                if (f.getClass() != clazz) continue;
                toRemove.add(f);
            }
            this.filters.removeAll(toRemove);
            if (notify) {
                this.notifyListeners(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataFilterListener(DataFilterListener listener) {
        Lock lock = this.lock;
        synchronized (lock) {
            if (this.listeners.contains(listener)) {
                return;
            }
            this.listeners.add(listener);
            listener.dataFiltersChanged(this.filters, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataFilterListener(DataFilterListener listener) {
        Lock lock = this.lock;
        synchronized (lock) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllListeners() {
        Lock lock = this.lock;
        synchronized (lock) {
            this.listeners.clear();
        }
    }

    private void notifyListeners(boolean isAdjusting) {
        for (DataFilterListener listener : this.listeners) {
            listener.dataFiltersChanged(this.filters, isAdjusting);
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

