/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.transform;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.ArtifactScopeEnum;
import org.apache.maven.artifact.resolver.metadata.ArtifactMetadata;
import org.apache.maven.artifact.resolver.metadata.MetadataResolutionException;
import org.apache.maven.artifact.resolver.metadata.MetadataTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathContainer
implements Iterable<ArtifactMetadata> {
    private List<ArtifactMetadata> classpath;
    private ArtifactScopeEnum scope;

    public ClasspathContainer(ArtifactScopeEnum scope) {
        this.scope = ArtifactScopeEnum.checkScope(scope);
    }

    public ClasspathContainer(List<ArtifactMetadata> classpath, ArtifactScopeEnum scope) {
        this(scope);
        this.classpath = classpath;
    }

    @Override
    public Iterator<ArtifactMetadata> iterator() {
        return this.classpath == null ? null : this.classpath.iterator();
    }

    public ClasspathContainer add(ArtifactMetadata md) {
        if (this.classpath == null) {
            this.classpath = new ArrayList<ArtifactMetadata>(16);
        }
        this.classpath.add(md);
        return this;
    }

    public List<ArtifactMetadata> getClasspath() {
        return this.classpath;
    }

    public MetadataTreeNode getClasspathAsTree() throws MetadataResolutionException {
        if (this.classpath == null || this.classpath.size() < 1) {
            return null;
        }
        MetadataTreeNode tree = null;
        MetadataTreeNode parent = null;
        MetadataTreeNode node = null;
        for (ArtifactMetadata md : this.classpath) {
            node = new MetadataTreeNode(md, parent, md.isResolved(), md.getArtifactScope());
            if (tree == null) {
                tree = node;
            }
            if (parent != null) {
                parent.setNChildren(1);
                parent.addChild(0, node);
            }
            parent = node;
        }
        return tree;
    }

    public void setClasspath(List<ArtifactMetadata> classpath) {
        this.classpath = classpath;
    }

    public ArtifactScopeEnum getScope() {
        return this.scope;
    }

    public void setScope(ArtifactScopeEnum scope) {
        this.scope = scope;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("[scope=" + this.scope.getScope());
        if (this.classpath != null) {
            for (ArtifactMetadata md : this.classpath) {
                sb.append(": " + md.toString() + '{' + md.getArtifactUri() + '}');
            }
        }
        sb.append(']');
        return sb.toString();
    }
}

