/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.ui.wizard;

import java.util.concurrent.Future;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.remote.ui.wizard.CreateHostData;
import org.netbeans.modules.cnd.remote.ui.wizard.CreateHostVisualPanel2;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class CreateHostWizardPanel2
implements WizardDescriptor.AsynchronousValidatingPanel<WizardDescriptor>,
WizardDescriptor.Panel<WizardDescriptor>,
ChangeListener {
    private CreateHostVisualPanel2 component;
    private ExecutionEnvironment lastValidatedHost;
    private final CreateHostData data;
    private Future<Boolean> validationTask;
    private WizardDescriptor settings;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

    public CreateHostWizardPanel2(CreateHostData data) {
        this.data = data;
    }

    public CreateHostVisualPanel2 getComponent() {
        if (this.component == null) {
            this.component = new CreateHostVisualPanel2(this.data, this);
        }
        return this.component;
    }

    public void prepareValidation() {
        this.component.enableControls(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() throws WizardValidationException {
        ExecutionEnvironment host = this.component.getHost();
        if (host == null || !host.equals(this.lastValidatedHost)) {
            this.validationTask = this.component.validateHost();
            try {
                this.validationTask.get();
            }
            catch (Exception ex) {
            }
            finally {
                this.validationTask = null;
            }
        }
        this.component.enableControls(true);
        if (this.component.getHost() == null) {
            String errMsg = NbBundle.getMessage(this.getClass(), (String)"MSG_Failure");
            throw new WizardValidationException((JComponent)this.component, errMsg, errMsg);
        }
        this.lastValidatedHost = host;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("NewRemoteDevelopmentHostWizardP2");
    }

    public boolean isValid() {
        if (!this.component.canValidateHost()) {
            String message = NbBundle.getMessage(this.getClass(), (String)"MSG_HostAlreadyAdded");
            this.settings.putProperty("WizardPanel_errorMessage", (Object)message);
            return false;
        }
        if (this.component.hasConfigProblems()) {
            this.settings.putProperty("WizardPanel_errorMessage", (Object)this.component.getConfigProblem());
            return false;
        }
        this.settings.putProperty("WizardPanel_errorMessage", (Object)"");
        return true;
    }

    public final void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
        if (this.validationTask != null && !this.validationTask.isDone()) {
            try {
                this.validationTask.cancel(true);
            }
            finally {
                this.validationTask = null;
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.changeSupport.fireChange();
    }

    public void readSettings(WizardDescriptor settings) {
        this.settings = settings;
        this.getComponent().init();
    }

    public void storeSettings(WizardDescriptor settings) {
        this.component.storeConfiguration();
        this.data.setExecutionEnvironment(this.getComponent().getHost());
        this.data.setRunOnFinish(this.getComponent().getRunOnFinish());
    }
}

