/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.disk;

import java.io.IOException;
import org.netbeans.modules.cnd.repository.api.RepositoryException;
import org.netbeans.modules.cnd.repository.disk.FilesAccessStrategy;
import org.netbeans.modules.cnd.repository.disk.FilesAccessStrategyImpl;
import org.netbeans.modules.cnd.repository.disk.Storage;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.util.RepositoryListenersManager;

public class MultyFileStorage
implements Storage {
    private FilesAccessStrategy theFilesHelper;
    private String unitName;

    public MultyFileStorage(String unitName) {
        this.theFilesHelper = FilesAccessStrategyImpl.getInstance();
        this.unitName = unitName;
    }

    public MultyFileStorage(FilesAccessStrategy aFilesHelper) {
        this.theFilesHelper = aFilesHelper;
    }

    @Override
    public void write(Key id, Persistent obj) {
        assert (id != null);
        assert (obj != null);
        try {
            this.theFilesHelper.write(id, obj);
        }
        catch (Throwable ex) {
            RepositoryListenersManager.getInstance().fireAnException(((Object)id.getUnit()).toString(), new RepositoryException(ex));
        }
    }

    @Override
    public boolean defragment(long timeout) {
        return false;
    }

    @Override
    public Persistent read(Key id) {
        assert (id != null);
        Persistent obj = null;
        try {
            obj = this.theFilesHelper.read(id);
        }
        catch (Throwable ex) {
            RepositoryListenersManager.getInstance().fireAnException(((Object)id.getUnit()).toString(), new RepositoryException(ex));
        }
        return obj;
    }

    @Override
    public void remove(Key id) {
        assert (id != null);
        try {
            this.theFilesHelper.remove(id);
        }
        catch (Throwable ex) {
            RepositoryListenersManager.getInstance().fireAnException(((Object)id.getUnit()).toString(), new RepositoryException(ex));
        }
    }

    @Override
    public void close() throws IOException {
        this.theFilesHelper.closeUnit(this.unitName);
    }

    @Override
    public int getFragmentationPercentage() {
        return 0;
    }
}

