/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugproxy;

import com.sun.javacard.debugproxy.Log;
import com.sun.javacard.debugproxy.Packet;

public final class Commands {
    public static final int VIRTUALMACHINE_CMDSET = 1;
    public static final int SENDVERSION_CMD = 1;
    public static final int CLASSESBYSIG_CMD = 2;
    public static final int ALL_CLASSES_CMD = 3;
    public static final int ALL_THREADS_CMD = 4;
    public static final int TOPLEVELTHREADGROUP_CMD = 5;
    public static final int DISPOSE_CMD = 6;
    public static final int IDSIZES_CMD = 7;
    public static final int SUSPEND = 8;
    public static final int RESUME = 9;
    public static final int EXIT_CMD = 10;
    public static final int CAPABILITIES_CMD = 12;
    public static final int CLASSPATHS_CMD = 13;
    public static final int DISPOSE_OBJECTS_CMD = 14;
    public static final int REFERENCE_TYPE_CMDSET = 2;
    public static final int SIGNATURE_CMD = 1;
    public static final int CLASSLOADER_CMD = 2;
    public static final int MODIFIERS_CMD = 3;
    public static final int FIELDS_CMD = 4;
    public static final int METHODS_CMD = 5;
    public static final int SOURCEFILE_CMD = 7;
    public static final int INTERFACES_CMD = 10;
    public static final int METHOD_CMDSET = 6;
    public static final int METHOD_LINETABLE_CMD = 1;
    public static final int METHOD_VARIABLETABLE_CMD = 2;
    public static final int METHOD_BYTECODES_CMD = 3;
    public static final int THREADREFERENCE_CMDSET = 11;
    public static final int THREADGROUP_CMD = 5;
    public static final int THREADGROUPREFERENCE_CMDSET = 12;
    public static final int THREADGROUP_NAME_CMD = 1;
    public static final int THREADGROUP_PARENT_CMD = 2;
    public static final int THREADGROUP_CHILDREN_CMD = 3;
    public static final int STACKFRAME_CMDSET = 16;
    public static final int STACKFRAME_GETVALUES_CMD = 1;
    public static final int STACKFRAME_THISOBJECT_CMD = 3;
    public static final int CLASSOBJECTREFERENCE_CMDSET = 17;
    public static final int REFLECTEDTYPE_CMD = 1;
    public static final int EVENT_CMDSET = 64;
    public static final int COMPOSITE_CMD = 100;
    public static final int KVM_CMDSET = 128;
    public static final int KVM_HANDSHAKE_CMD = 1;
    public static final int KVM_GET_STEPPINGINFO_CMD = 2;
    public static final int KVM_STEPPING_EVENT_CMD = 3;
    public static final short NOTFOUND_ERROR = 41;
    public static final short INVALID_METHODID = 23;
    public static final short INVALID_OBJECT = 20;
    public static final byte JDWP_TYPE_TAG_ARRAY = 3;
    public static final byte JDWP_EVENT_KIND_CLASS_PREPARE = 8;
    public static final int CLASS_PREPARED = 2;
    public static final int CLASS_INITIALIZED = 4;
    public static final byte TYPE_TAG_CLASS = 1;
    public static final byte TYPE_TAG_ARRAY = 3;
    public static final int ONLY_THREADGROUP_ID = -32;
    public static final String KVM_THREADGROUP_NAME = "KVM_System";
    public static final String[][] VM_COMMANDS = new String[][]{{""}, {"Virtual Machine", "Version", "ClassBySignature", "AllClasses", "AllThreads", "TopLevelThreadGroups", "Dispose", "IDSizes", "Suspend", "Resume", "Exit", "CreateString", "Capabilities", "ClassPaths", "DisposeObjects", "HoldEvents", "ReleaseEvents", "CapabilitiesNew", "RedefineClasses", "SetDefaultStratum", "AllClassesWithGeneric"}, {"ReferenceType", "Signature", "ClassLoader", "Modifiers", "Fields", "Methods", "GetValues", "SourceFile", "NestedTypes", "Status", "Interfaces", "ClassObject", "SourceDebugExtension", "SignatureWithGeneric", "FieldsWithGeneric", "MethodsWithGeneric"}, {"ClassType", "Superclass", "SetValues", "InvokeMethod", "NewInstance"}, {"ArrayType", "NewInstance"}, {"InterfaceType"}, {"Method", "LineTable", "VariableTable", "Bytecodes", "IsObsolete", "VariableTableWithGeneric"}, {"UNUSED"}, {"Field"}, {"ObjectReference", "ReferenceType", "GetValues", "SetValues", "UNUSED", "MonitorInfo", "InvokeMethod", "DisableCollection", "EnableCollection", "IsCollected"}, {"StringReference", "Value"}, {"ThreadReference", "Name", "Suspend", "Resume", "Status", "ThreadGroup", "Frames", "FrameCount", "OwnedMonitors", "CurrentCountendedMonitor", "Stop", "Interrupt", "SuspendCount"}, {"ThreadGroupReference", "Name", "Parent", "Children"}, {"ArrayReference", "Length", "GetValues", "SetValues"}, {"ClassLoaderReference", "VisibleClasses"}, {"EventRequest", "Set", "Clear", "ClearAllBreakpoints"}, {"StackFrame", "GetValues", "SetValues", "ThisObject", "PopFrames"}, {"ClassObjectReference", "ReflectedType"}};
    public static final String[][] DEBUG_COMMANDS = new String[][]{{"Event", "Composite"}};
    public static final String[][] VENDOR_SPECIFIC_COMMANDS = new String[][]{{"CJCRE", "Handshake", "GetSteppingInfo", "SteppingEvent"}};

    public static void print(Packet packet) {
        String[][] stringArray = null;
        int n = packet.commandSet;
        int n2 = packet.command;
        int n3 = n;
        int n4 = n2;
        if (n < 64) {
            stringArray = VM_COMMANDS;
        } else if (n < 128) {
            stringArray = DEBUG_COMMANDS;
            n3 -= 64;
            n4 -= 99;
        } else {
            stringArray = VENDOR_SPECIFIC_COMMANDS;
            n4 = 0;
            n3 = 0;
        }
        try {
            Log.LOGN(3, "Sending through: " + stringArray[n3][0] + "(" + n + ")/" + stringArray[n3][n4] + "(" + n2 + ")");
            Log.LOGN(8, "Packet: " + packet);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("UNKNOWN COMMAND: " + n + "/" + n2);
        }
    }
}

