/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.MercurialAnnotator;
import org.netbeans.modules.mercurial.MercurialInterceptor;
import org.netbeans.modules.mercurial.MercurialVCS;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.VersionsCache;
import org.netbeans.modules.mercurial.kenai.HgKenaiAccessor;
import org.netbeans.modules.mercurial.ui.repository.HgURL;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VCSHyperlinkProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class Mercurial {
    public static final int HG_FETCH_20_REVISIONS = 20;
    public static final int HG_FETCH_50_REVISIONS = 50;
    public static final int HG_FETCH_ALL_REVISIONS = -1;
    public static final int HG_NUMBER_FETCH_OPTIONS = 3;
    public static final int HG_NUMBER_TO_FETCH_DEFAULT = 7;
    public static final int HG_MAX_REVISION_COMBO_SIZE = 10;
    public static final String MERCURIAL_OUTPUT_TAB_TITLE = NbBundle.getMessage(Mercurial.class, (String)"CTL_Mercurial_DisplayName");
    public static final String CHANGESET_STR = "changeset:";
    public static final String PROP_ANNOTATIONS_CHANGED = "annotationsChanged";
    static final String PROP_VERSIONED_FILES_CHANGED = "versionedFilesChanged";
    public static final String PROP_CHANGESET_CHANGED = "changesetChanged";
    public static final Logger LOG = Logger.getLogger("org.netbeans.modules.mercurial");
    public static final Logger STATUS_LOG = Logger.getLogger("org.netbeans.modules.mercurial.status");
    private static final int STATUS_DIFFABLE = 1272;
    private static final String MERCURIAL_SUPPORTED_VERSION_093 = "0.9.3";
    private static final String MERCURIAL_SUPPORTED_VERSION_094 = "0.9.4";
    private static final String MERCURIAL_SUPPORTED_VERSION_095 = "0.9.5";
    private static final String MERCURIAL_SUPPORTED_VERSION_100 = "1.0";
    private static Mercurial instance;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private final MercurialVCS mvcs;
    private MercurialAnnotator mercurialAnnotator;
    private MercurialInterceptor mercurialInterceptor;
    private FileStatusCache fileStatusCache;
    private HashMap<HgURL, RequestProcessor> processorsToUrl;
    private boolean goodVersion;
    private String version;
    private boolean gotVersion;
    private Lookup.Result<? extends VCSHyperlinkProvider> hpResult;
    private RequestProcessor parallelRP;
    private final RootsToFile rootsToFile = new RootsToFile();

    public static synchronized Mercurial getInstance() {
        if (instance == null) {
            instance = new Mercurial();
            instance.init();
        }
        return instance;
    }

    private Mercurial() {
        this.mvcs = (MercurialVCS)Lookup.getDefault().lookup(MercurialVCS.class);
    }

    private void init() {
        this.setDefaultPath();
        this.fileStatusCache = new FileStatusCache();
        this.mercurialAnnotator = new MercurialAnnotator();
        this.mercurialInterceptor = new MercurialInterceptor();
        this.fileStatusCache.addPropertyChangeListener(this.mvcs);
        this.mercurialAnnotator.addPropertyChangeListener(this.mvcs);
        this.addPropertyChangeListener(this.mvcs);
        this.asyncInit();
    }

    private void setDefaultPath() {
        String path;
        String defaultPath;
        if (System.getProperty("os.name").equals("Mac OS X")) {
            String defaultPath2 = HgModuleConfig.getDefault().getExecutableBinaryPath();
            if (defaultPath2 == null || defaultPath2.length() == 0) {
                String[] pathNames = new String[]{"/Library/Frameworks/Python.framework/Versions/Current/bin", "/usr/bin", "/usr/local/bin", "/opt/local/bin/", "/sw/bin"};
                for (int i = 0; i < pathNames.length; ++i) {
                    if (!HgModuleConfig.getDefault().isExecPathValid(pathNames[i]).booleanValue()) continue;
                    HgModuleConfig.getDefault().setExecutableBinaryPath(pathNames[i]);
                    break;
                }
            }
        } else if (Utilities.isWindows() && ((defaultPath = HgModuleConfig.getDefault().getExecutableBinaryPath()) == null || defaultPath.length() == 0) && (path = HgUtils.findInUserPath(HgCommand.HG_WINDOWS_EXECUTABLES)) != null && !path.equals("")) {
            HgModuleConfig.getDefault().setExecutableBinaryPath(path);
        }
    }

    public void asyncInit() {
        this.gotVersion = false;
        RequestProcessor rp = this.getRequestProcessor();
        Runnable init = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HgKenaiAccessor.getInstance().registerVCSNoficationListener();
                1 var1_1 = this;
                synchronized (var1_1) {
                    Mercurial.this.checkVersionIntern();
                }
            }
        };
        rp.post(init);
    }

    private void checkVersionIntern() {
        this.version = HgCommand.getHgVersion();
        LOG.log(Level.FINE, "version: {0}", this.version);
        this.goodVersion = this.version != null ? this.isSupportedVersion(this.version) : false;
        this.gotVersion = true;
    }

    private boolean isSupportedVersion(String version) {
        if (version.startsWith(MERCURIAL_SUPPORTED_VERSION_093) || version.startsWith(MERCURIAL_SUPPORTED_VERSION_094) || version.startsWith(MERCURIAL_SUPPORTED_VERSION_095) || version.startsWith(MERCURIAL_SUPPORTED_VERSION_100)) {
            return true;
        }
        return !version.startsWith("0.");
    }

    public boolean isAvailable() {
        return this.isAvailable(false, false);
    }

    public boolean isAvailable(boolean notifyUI) {
        return this.isAvailable(false, notifyUI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailable(boolean forceCheck, boolean notifyUI) {
        OutputLogger logger;
        Mercurial mercurial = this;
        synchronized (mercurial) {
            if (!this.gotVersion) {
                LOG.log(Level.FINE, "Call to hg version not finished");
                if (forceCheck) {
                    this.checkVersionIntern();
                } else {
                    return true;
                }
            }
        }
        if (this.version != null && !this.goodVersion) {
            logger = this.getLogger(MERCURIAL_OUTPUT_TAB_TITLE);
            logger.outputInRed(NbBundle.getMessage(Mercurial.class, (String)"MSG_USING_UNRECOGNIZED_VERSION_MSG", (Object)this.version));
            logger.closeLog();
            LOG.log(Level.WARNING, "Using an unsupported hg version: {0}", this.version);
            this.goodVersion = true;
        } else if (this.version == null && notifyUI) {
            logger = this.getLogger(MERCURIAL_OUTPUT_TAB_TITLE);
            logger.outputInRed(NbBundle.getMessage(Mercurial.class, (String)"MSG_VERSION_NONE_OUTPUT_MSG"));
            HgUtils.warningDialog(Mercurial.class, "MSG_VERSION_NONE_TITLE", "MSG_VERSION_NONE_MSG");
            logger.closeLog();
            LOG.warning("Hg is not available");
        }
        return this.goodVersion;
    }

    public MercurialAnnotator getMercurialAnnotator() {
        return this.mercurialAnnotator;
    }

    MercurialInterceptor getMercurialInterceptor() {
        return this.mercurialInterceptor;
    }

    public FileStatusCache getFileStatusCache() {
        return this.fileStatusCache;
    }

    public void refreshWorkingCopyTimestamp(File repository) {
        this.getMercurialInterceptor().refreshHgFolderTimestamp(repository);
    }

    public Set<File> getSeenRoots(File repositoryRoot) {
        return this.getMercurialInterceptor().getSeenRoots(repositoryRoot);
    }

    public boolean isManaged(File file) {
        return VersioningSupport.getOwner((File)file) instanceof MercurialVCS && !HgUtils.isPartOfMercurialMetadata(file);
    }

    public File getRepositoryRoot(File file) {
        File oFile = file;
        this.rootsToFile.logStatistics();
        File root = this.rootsToFile.get(file, true);
        if (root != null) {
            return root;
        }
        root = this.mvcs.getTopmostManagedAncestor(file);
        if (root != null) {
            if (file.isFile()) {
                file = file.getParentFile();
            }
            ArrayList<File> folders = new ArrayList<File>();
            while (file != null && !file.getAbsolutePath().equals(root.getAbsolutePath())) {
                File knownRoot = this.rootsToFile.get(file);
                if (knownRoot != null) {
                    this.rootsToFile.put(folders, knownRoot);
                    this.rootsToFile.put(oFile, knownRoot);
                    return knownRoot;
                }
                folders.add(file);
                if (HgUtils.hgExistsFor(file)) {
                    this.rootsToFile.put(folders, file);
                    this.rootsToFile.put(oFile, file);
                    return file;
                }
                file = file.getParentFile();
            }
            folders.add(root);
            this.rootsToFile.put(folders, root);
            this.rootsToFile.put(oFile, root);
            return root;
        }
        return null;
    }

    public String getMimeType(File file) {
        String foMime;
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo == null) {
            foMime = "content/unknown";
        } else {
            foMime = fo.getMIMEType();
            if ("content/unknown".equals(foMime)) {
                foMime = "text/plain";
            }
        }
        if ((this.fileStatusCache.getStatus(file).getStatus() & 0x1DF8) == 0) {
            return HgUtils.isFileContentBinary(file) ? "application/octet-stream" : foMime;
        }
        return foMime;
    }

    public void versionedFilesChanged() {
        this.rootsToFile.clear();
        this.support.firePropertyChange(PROP_VERSIONED_FILES_CHANGED, null, null);
    }

    public void refreshAllAnnotations() {
        this.support.firePropertyChange(PROP_ANNOTATIONS_CHANGED, null, null);
    }

    public void changesetChanged(File repository) {
        this.support.firePropertyChange(PROP_CHANGESET_CHANGED, repository, null);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void getOriginalFile(File workingCopy, File originalFile) {
        FileInformation info = this.fileStatusCache.getStatus(workingCopy);
        LOG.log(Level.FINE, "getOriginalFile: {0} {1}", new Object[]{workingCopy, info});
        if ((info.getStatus() & 0x4F8) == 0) {
            return;
        }
        try {
            File original = VersionsCache.getInstance().getFileRevision(workingCopy, "BASE");
            if (original == null) {
                return;
            }
            Utils.copyStreamsCloseAll((OutputStream)new FileOutputStream(originalFile), (InputStream)new FileInputStream(original));
            original.delete();
        }
        catch (IOException e) {
            Logger.getLogger(Mercurial.class.getName()).log(Level.INFO, "Unable to get original file", e);
        }
    }

    public RequestProcessor getRequestProcessor() {
        return this.getRequestProcessor((HgURL)null);
    }

    public RequestProcessor getParallelRequestProcessor() {
        if (this.parallelRP == null) {
            this.parallelRP = new RequestProcessor("Mercurial.ParallelRP", 5, true);
        }
        return this.parallelRP;
    }

    public RequestProcessor getRequestProcessor(File file) {
        return this.getRequestProcessor(new HgURL(file));
    }

    public RequestProcessor getRequestProcessor(HgURL url) {
        RequestProcessor rp;
        if (this.processorsToUrl == null) {
            this.processorsToUrl = new HashMap();
        }
        if ((rp = this.processorsToUrl.get(url)) == null) {
            String rpName = "Mercurial - " + (url != null ? url.toString() : "ANY_KEY");
            rp = new RequestProcessor(rpName, 1, true);
            this.processorsToUrl.put(url, rp);
        }
        return rp;
    }

    public void clearRequestProcessor(HgURL url) {
        if (this.processorsToUrl != null & url != null) {
            this.processorsToUrl.remove(url);
        }
    }

    public void notifyFileChanged(File file) {
        this.fileStatusCache.notifyFileChanged(file);
    }

    public OutputLogger getLogger(String repositoryRoot) {
        return OutputLogger.getLogger(repositoryRoot);
    }

    public Boolean isRefreshScheduled(File file) {
        return this.mercurialInterceptor.isRefreshScheduled(file);
    }

    public List<VCSHyperlinkProvider> getHyperlinkProviders() {
        if (this.hpResult == null) {
            this.hpResult = Lookup.getDefault().lookupResult(VCSHyperlinkProvider.class);
        }
        if (this.hpResult == null) {
            return Collections.EMPTY_LIST;
        }
        Collection providersCol = this.hpResult.allInstances();
        ArrayList providersList = new ArrayList(providersCol.size());
        providersList.addAll(providersCol);
        return Collections.unmodifiableList(providersList);
    }

    public String getVersion() {
        return this.version;
    }

    private static class RootsToFile {
        private static Logger LOG = Logger.getLogger("org.netbeans.modules.mercurial.RootsToFile");
        private LinkedList<File> order = new LinkedList();
        private Map<File, File> files = new HashMap<File, File>();
        private long cachedAccesCount = 0L;
        private long accesCount = 0L;
        private int statisticsFrequency = 0;

        public RootsToFile() {
            String s = System.getProperty("mercurial.root.stat.frequency", "0");
            this.statisticsFrequency = Integer.parseInt(s);
        }

        synchronized void put(Collection<File> files, File root) {
            for (File file : files) {
                this.put(file, root);
            }
        }

        synchronized void put(File file, File root) {
            if (this.order.size() > 1500) {
                for (int i = 0; i < 150; ++i) {
                    this.files.remove(this.order.getFirst());
                    this.order.removeFirst();
                }
            }
            this.order.addLast(file);
            this.files.put(file, root);
        }

        synchronized File get(File file) {
            return this.get(file, false);
        }

        synchronized File get(File file, boolean statistics) {
            File root = this.files.get(file);
            if (statistics && LOG.isLoggable(Level.FINEST)) {
                this.cachedAccesCount += root != null ? 1L : 0L;
                ++this.accesCount;
            }
            return root;
        }

        synchronized int size() {
            return this.order.size();
        }

        synchronized void logStatistics() {
            if (!LOG.isLoggable(Level.FINEST) || this.statisticsFrequency > 0 && this.accesCount % (long)this.statisticsFrequency != 0L) {
                return;
            }
            LOG.finest("HG Repository roots cache statistics:\n  cached roots size       = " + this.order.size() + "\n" + "  access count            = " + this.accesCount + "\n" + "  cached access count     = " + this.cachedAccesCount + "\n" + "  not cached access count = " + (this.accesCount - this.cachedAccesCount) + "\n");
        }

        synchronized void clear() {
            this.order.clear();
            this.files.clear();
            this.cachedAccesCount = 0L;
            this.accesCount = 0L;
        }
    }
}

