/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.runtime.util;

import com.sun.xml.ws.runtime.util.SessionManager;
import com.sun.xml.ws.security.SecurityContextTokenInfo;
import com.sun.xml.ws.security.secconv.impl.SecurityContextTokenInfoImpl;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedData;

@ManagedData
@Description(value="RM and SC session information")
public class Session {
    public static final String SESSION_ID_KEY = "com.sun.xml.ws.sessionid";
    public static final String SESSION_KEY = "com.sun.xml.ws.session";
    private SessionManager manager;
    private String key;
    private Object userData;
    private SecurityContextTokenInfo securityInfo;
    private long creationTime;
    private long lastAccessedTime;

    protected Session() {
        this.creationTime = this.lastAccessedTime = System.currentTimeMillis();
    }

    public void init(SessionManager manager, String key, Object userData) {
        this.manager = manager;
        this.userData = userData;
        this.key = key;
        this.creationTime = this.lastAccessedTime = System.currentTimeMillis();
    }

    public Session(SessionManager manager, String key, Object userData) {
        this.manager = manager;
        this.userData = userData;
        this.key = key;
        this.creationTime = this.lastAccessedTime = System.currentTimeMillis();
    }

    @ManagedAttribute
    @Description(value="Session key")
    public String getSessionKey() {
        return this.key;
    }

    public Object getUserData() {
        return this.userData;
    }

    @ManagedAttribute
    @Description(value="Security context token info")
    public SecurityContextTokenInfo getSecurityInfo() {
        return this.securityInfo;
    }

    public SecurityContextTokenInfo createSecurityContextInfo() {
        return new SecurityContextTokenInfoImpl();
    }

    public void setSecurityInfo(SecurityContextTokenInfo securityInfo) {
        this.securityInfo = securityInfo;
    }

    @ManagedAttribute
    @Description(value="Creation time")
    public long getCreationTime() {
        return this.creationTime;
    }

    @ManagedAttribute
    @Description(value="Last accessed time")
    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public void resetLastAccessedTime() {
        this.lastAccessedTime = System.currentTimeMillis();
    }

    public void save() {
        this.manager.saveSession(this.getSessionKey());
    }
}

