// -*- c++ -*-
//
// $Id: exception.h,v 1.1.1.1.2.1 2001/10/29 04:33:20 bbarrett Exp $
//
// Copyright 1997-2001, University of Notre Dame.
// Authors: Jeffrey M. Squyres, Jeremy G. Siek, Michael P. McNally, and
//          Andrew Lumsdaine
// 
// This file is part of the Notre Dame C++ bindings for MPI.
// 
// You should have received a copy of the License Agreement for the Notre
// Dame C++ bindings for MPI along with the software; see the file
// LICENSE.  If not, contact Office of Research, University of Notre
// Dame, Notre Dame, IN 46556.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted subject to the conditions specified in the
// LICENSE file.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
// IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
// 
// Additional copyrights may follow.
//

class Exception {
public:

#if _MPIPP_PROFILING_

  inline Exception(int ec) : pmpi_exception(ec) { }

  int Get_error_code() const;
  
  int Get_error_class() const;
  
  const char* Get_error_string() const;
 
#else

  inline Exception(int ec) : error_code(ec), error_string(0), error_class(-1) {
    (void)MPI_Error_class(error_code, &error_class);
    int resultlen;
    error_string = new char[MAX_ERROR_STRING];
    (void)MPI_Error_string(error_code, error_string, &resultlen);
  }
  inline ~Exception() {
    delete[] error_string;
  }
  // Better put in a copy constructor here since we have a string;
  // copy by value (from the default copy constructor) would be
  // disasterous.
  inline Exception(const Exception& a)
    : error_code(a.error_code), error_class(a.error_class)
  {
    error_string = new char[MAX_ERROR_STRING];
    // Rather that force an include of <string.h>, especially this
    // late in the game (recall that this file is included deep in
    // other .h files), we'll just do the copy ourselves.
    for (int i = 0; i < MAX_ERROR_STRING; i++)
      error_string[i] = a.error_string[i];
  }

  inline int Get_error_code() const { return error_code; }

  inline int Get_error_class() const { return error_class; }
  
  inline const char* Get_error_string() const { return error_string; }

#endif
 
protected:
#if _MPIPP_PROFILING_
  PMPI::Exception pmpi_exception;
#else
  int error_code;
  char* error_string;
  int error_class;
#endif
};
