/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import java.io.File;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.server.Maven2ServerGlobals;
import org.jetbrains.idea.maven.server.MavenEmbedderSettings;
import org.jetbrains.idea.maven.server.MavenRemoteObject;
import org.jetbrains.idea.maven.server.MavenServer;
import org.jetbrains.idea.maven.server.MavenServerDownloadListener;
import org.jetbrains.idea.maven.server.MavenServerEmbedder;
import org.jetbrains.idea.maven.server.MavenServerIndexer;
import org.jetbrains.idea.maven.server.MavenServerLogger;
import org.jetbrains.idea.maven.server.ProfileApplicationResult;
import org.jetbrains.idea.maven.server.embedder.Maven2ServerEmbedderImpl;
import org.jetbrains.idea.maven.server.embedder.Maven2ServerIndexerImpl;

public class Maven2ServerImpl
extends MavenRemoteObject
implements MavenServer {
    public void set(MavenServerLogger logger, MavenServerDownloadListener downloadListener) throws RemoteException {
        try {
            Maven2ServerGlobals.set(logger, downloadListener);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    public MavenServerEmbedder createEmbedder(MavenEmbedderSettings settings) throws RemoteException {
        try {
            Maven2ServerEmbedderImpl result = Maven2ServerEmbedderImpl.create(settings.getSettings());
            UnicastRemoteObject.exportObject((Remote)((Object)result), 0);
            return result;
        }
        catch (RemoteException e) {
            throw this.rethrowException(e);
        }
    }

    public MavenServerIndexer createIndexer() throws RemoteException {
        try {
            Maven2ServerIndexerImpl result = new Maven2ServerIndexerImpl();
            UnicastRemoteObject.exportObject((Remote)((Object)result), 0);
            return result;
        }
        catch (RemoteException e) {
            throw this.rethrowException(e);
        }
    }

    @NotNull
    public MavenModel interpolateAndAlignModel(MavenModel model, File basedir) {
        MavenModel mavenModel;
        try {
            mavenModel = Maven2ServerEmbedderImpl.interpolateAndAlignModel(model, basedir);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
        if (mavenModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/Maven2ServerImpl", "interpolateAndAlignModel"));
        }
        return mavenModel;
    }

    public MavenModel assembleInheritance(MavenModel model, MavenModel parentModel) {
        try {
            return Maven2ServerEmbedderImpl.assembleInheritance(model, parentModel);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    public ProfileApplicationResult applyProfiles(MavenModel model, File basedir, MavenExplicitProfiles explicitProfiles, Collection<String> alwaysOnProfiles) {
        try {
            return Maven2ServerEmbedderImpl.applyProfiles(model, basedir, explicitProfiles, alwaysOnProfiles);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    public synchronized void unreferenced() {
        System.exit(0);
    }
}

