/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class JetBrainsProtocolHandler {
    public static final String PROTOCOL = "jetbrains://";
    private static String ourMainParameter = null;
    private static String ourCommand = null;
    public static final String REQUIRED_PLUGINS_KEY = "idea.required.plugins.id";
    private static final Map<String, String> ourParameters = new HashMap<String, String>(0);
    private static boolean initialized = false;

    public static void processJetBrainsLauncherParameters(String url) {
        System.setProperty(JetBrainsProtocolHandler.class.getName(), url);
        url = url.substring(PROTOCOL.length());
        List<String> urlParts = StringUtil.split(url, "/");
        if (urlParts.size() < 2) {
            System.err.print("Wrong URL: jetbrains://" + url);
            return;
        }
        String platformPrefix = urlParts.get(0);
        ourMainParameter = null;
        ourParameters.clear();
        ourCommand = urlParts.get(1);
        if (urlParts.size() > 2) {
            url = url.substring(platformPrefix.length() + 1 + ourCommand.length() + 1);
            List<String> strings = StringUtil.split(url, "?");
            ourMainParameter = strings.get(0);
            if (strings.size() > 1) {
                List<String> keyValues = StringUtil.split(StringUtil.join(ContainerUtil.subList(strings, 1), "?"), "&");
                for (String keyValue : keyValues) {
                    if (keyValue.contains("=")) {
                        int ind = keyValue.indexOf(61);
                        String key = keyValue.substring(0, ind);
                        String value = keyValue.substring(ind + 1);
                        if (REQUIRED_PLUGINS_KEY.equals(key)) {
                            System.setProperty(key, value);
                            continue;
                        }
                        ourParameters.put(key, value);
                        continue;
                    }
                    ourParameters.put(keyValue, "");
                }
            }
        }
        initialized = true;
    }

    @Nullable
    public static String getCommand() {
        JetBrainsProtocolHandler.init();
        return ourCommand;
    }

    private static void init() {
        if (initialized) {
            return;
        }
        String property = System.getProperty(JetBrainsProtocolHandler.class.getName());
        if (property != null && property.startsWith(PROTOCOL)) {
            JetBrainsProtocolHandler.processJetBrainsLauncherParameters(property);
        }
    }

    public static String getMainParameter() {
        JetBrainsProtocolHandler.init();
        return ourMainParameter;
    }

    public static void clear() {
        ourCommand = null;
    }

    public static Map<String, String> getParameters() {
        JetBrainsProtocolHandler.init();
        return Collections.unmodifiableMap(ourParameters);
    }
}

