/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.coverage.report.impl.html;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import jetbrains.coverage.report.ClassInfo;
import jetbrains.coverage.report.CoverageData;
import jetbrains.coverage.report.CoverageSourceData;
import jetbrains.coverage.report.ReportBuilderFactory;
import jetbrains.coverage.report.ReportGenerationFailedException;
import jetbrains.coverage.report.StatisticsCalculator;
import jetbrains.coverage.report.html.HTMLReportBuilder;
import jetbrains.coverage.report.impl.FooterInfos;
import jetbrains.coverage.report.impl.IOUtil;
import jetbrains.coverage.report.impl.html.ClassSourceReportGenerator;
import jetbrains.coverage.report.impl.html.ClassesIndexGenerator;
import jetbrains.coverage.report.impl.html.LocalGeneratorPaths;
import jetbrains.coverage.report.impl.html.MapToSet;
import jetbrains.coverage.report.impl.html.ModuleInfo;
import jetbrains.coverage.report.impl.html.ModulesIndexGenerator;
import jetbrains.coverage.report.impl.html.ModulesLocalPaths;
import jetbrains.coverage.report.impl.html.NamespacesIndexGenerator;
import jetbrains.coverage.report.impl.html.NamespacesLocalPaths;
import jetbrains.coverage.report.impl.html.TemplateFactory;
import jetbrains.coverage.report.impl.html.TemplateProcessorFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLReportBuilderImpl
implements HTMLReportBuilder {
    private File myReportDir;
    private TemplateFactory myTemplateFactory = new TemplateFactory();
    private String myResourceBundleName = "javaCoverage";
    private static final String CSS_DIR = ".css";
    private static final String IMG_DIR = ".img";
    private String myFooterText;
    private String myFooterSourceText;

    @Override
    public void setReportDir(@NotNull File reportDir) {
        if (reportDir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/html/HTMLReportBuilderImpl.setReportDir must not be null");
        }
        this.myReportDir = reportDir;
    }

    public void setResourceBundleName(@NotNull String resourceBundleName) {
        if (resourceBundleName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/html/HTMLReportBuilderImpl.setResourceBundleName must not be null");
        }
        this.myResourceBundleName = resourceBundleName;
    }

    @Override
    public void setFooterHTML(@NotNull String html) {
        if (html == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/html/HTMLReportBuilderImpl.setFooterHTML must not be null");
        }
        this.myFooterText = html;
    }

    @Override
    public void setSourceCodeFooterHTML(@NotNull String html) {
        if (html == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/html/HTMLReportBuilderImpl.setSourceCodeFooterHTML must not be null");
        }
        this.myFooterSourceText = html;
    }

    @Override
    public void generateReport(@NotNull CoverageData coverageData) throws ReportGenerationFailedException {
        if (coverageData == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/html/HTMLReportBuilderImpl.generateReport must not be null");
        }
        StatisticsCalculator covStatsCalculator = ReportBuilderFactory.createStatisticsCalculator();
        this.generateReport(coverageData, covStatsCalculator);
    }

    @Override
    public void generateReport(@NotNull CoverageData data, @NotNull StatisticsCalculator calculator) throws ReportGenerationFailedException {
        if (data == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/html/HTMLReportBuilderImpl.generateReport must not be null");
        }
        if (calculator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/coverage/report/impl/html/HTMLReportBuilderImpl.generateReport must not be null");
        }
        calculator.compute(data);
        this.doGenerateReport(data, calculator);
    }

    private void doGenerateReport(CoverageData data, StatisticsCalculator covStatsCalculator) {
        try {
            TemplateProcessorFactory fac;
            ModulesLocalPaths paths;
            this.createReportDir();
            MapToSet<ModuleInfo, ClassInfo> moduleToClassesMap = this.groupByModules(data.getClasses());
            if (moduleToClassesMap.keySet().size() > 1) {
                paths = new ModulesLocalPaths(this.myReportDir);
                fac = new TemplateProcessorFactory(this.myTemplateFactory, this.myResourceBundleName, true, this.getFooterInfos());
                new ModulesIndexGenerator(fac.createModulesIndexProcessor(), paths).generateModulesIndex(moduleToClassesMap.keySet(), covStatsCalculator);
            } else {
                fac = new TemplateProcessorFactory(this.myTemplateFactory, this.myResourceBundleName, false, this.getFooterInfos());
                paths = new NamespacesLocalPaths(this.myReportDir);
            }
            for (ModuleInfo info : moduleToClassesMap.keySet()) {
                this.generateReportForModule(data.getSourceData(), covStatsCalculator, fac, paths, moduleToClassesMap, info);
            }
        }
        catch (IOException e) {
            throw new ReportGenerationFailedException("Failed to generate report", e);
        }
    }

    @NotNull
    private FooterInfos getFooterInfos() {
        FooterInfos footerInfos = new FooterInfos(){

            public String getModulesIndexFooterHTML() {
                return HTMLReportBuilderImpl.this.myFooterText;
            }

            public String getNamespacesIndexFooterHTML() {
                return HTMLReportBuilderImpl.this.myFooterText;
            }

            public String getClassesIndexFooterHTML() {
                return HTMLReportBuilderImpl.this.myFooterText;
            }

            public String getSourceFooterHTML() {
                return HTMLReportBuilderImpl.this.myFooterSourceText == null ? HTMLReportBuilderImpl.this.myFooterText : HTMLReportBuilderImpl.this.myFooterSourceText;
            }
        };
        if (footerInfos == null) {
            throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/html/HTMLReportBuilderImpl.getFooterInfos must not return null");
        }
        return footerInfos;
    }

    private void generateReportForModule(@Nullable CoverageSourceData sourceInfo, @NotNull StatisticsCalculator covStatsCalculator, @NotNull TemplateProcessorFactory fac, @NotNull LocalGeneratorPaths paths, @NotNull MapToSet<ModuleInfo, ClassInfo> moduleToClassesMap, @NotNull ModuleInfo info) throws IOException {
        if (covStatsCalculator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/coverage/report/impl/html/HTMLReportBuilderImpl.generateReportForModule must not be null");
        }
        if (fac == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/coverage/report/impl/html/HTMLReportBuilderImpl.generateReportForModule must not be null");
        }
        if (paths == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of jetbrains/coverage/report/impl/html/HTMLReportBuilderImpl.generateReportForModule must not be null");
        }
        if (moduleToClassesMap == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of jetbrains/coverage/report/impl/html/HTMLReportBuilderImpl.generateReportForModule must not be null");
        }
        if (info == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of jetbrains/coverage/report/impl/html/HTMLReportBuilderImpl.generateReportForModule must not be null");
        }
        MapToSet<String, ClassInfo> namespaceToClassMap = this.groupByNamespace(moduleToClassesMap.getValues(info));
        new NamespacesIndexGenerator(fac.createNamespacesIndexProcessor(), paths).generateNamespacesIndex(info, namespaceToClassMap.keySet(), covStatsCalculator);
        for (String namespace : namespaceToClassMap.keySet()) {
            Collection<ClassInfo> nClasses = namespaceToClassMap.getValues(namespace);
            new ClassesIndexGenerator(fac.createClassesIndexProcessor(), paths).generateNamespaceIndex(info, namespace, nClasses, covStatsCalculator);
            for (ClassInfo clazz : nClasses) {
                new ClassSourceReportGenerator(fac.createClassSourceProcessor(), paths, sourceInfo).generateClassCoverage(info, namespace, clazz, covStatsCalculator);
            }
        }
    }

    private void createReportDir() {
        if (this.myReportDir == null) {
            throw new IllegalStateException("Report directory must be specified");
        }
        try {
            this.prepareReportDir();
        }
        catch (IOException e) {
            throw new ReportGenerationFailedException("Failed to create report directory", e);
        }
    }

    @Override
    public void generateReport(@NotNull CoverageData before, @NotNull CoverageData after) throws ReportGenerationFailedException {
        if (before == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/html/HTMLReportBuilderImpl.generateReport must not be null");
        }
        if (after == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/coverage/report/impl/html/HTMLReportBuilderImpl.generateReport must not be null");
        }
        this.createReportDir();
        StatisticsCalculator covStatsCalculator = ReportBuilderFactory.createStatisticsCalculator();
        covStatsCalculator.compute(before, after);
        this.doGenerateReport(after, covStatsCalculator);
    }

    private void prepareReportDir() throws IOException {
        IOUtil.createDir(this.myReportDir);
        File cssDir = new File(this.myReportDir, CSS_DIR);
        IOUtil.createDir(cssDir);
        IOUtil.copyResource(this.getClass(), "/htmlTemplates/css/coverage.css", new File(cssDir, "coverage.css"));
        File imgDir = new File(this.myReportDir, IMG_DIR);
        IOUtil.createDir(imgDir);
        IOUtil.copyResource(this.getClass(), "/htmlTemplates/img/arrowUp.gif", new File(imgDir, "arrowUp.gif"));
        IOUtil.copyResource(this.getClass(), "/htmlTemplates/img/arrowDown.gif", new File(imgDir, "arrowDown.gif"));
    }

    private MapToSet<ModuleInfo, ClassInfo> groupByModules(Collection<ClassInfo> coverageData) {
        MapToSet<ModuleInfo, ClassInfo> set = new MapToSet<ModuleInfo, ClassInfo>();
        for (ClassInfo info : coverageData) {
            set.addValue(ModuleInfo.fromClassInfo(info), info);
        }
        return set;
    }

    private MapToSet<String, ClassInfo> groupByNamespace(Collection<ClassInfo> coverageData) {
        MapToSet<String, ClassInfo> set = new MapToSet<String, ClassInfo>();
        for (ClassInfo cd : coverageData) {
            String ns = cd.getNamespace();
            set.addValue(ns, cd);
        }
        return set;
    }
}

