/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.metadata.property.value;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.BooleanPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.ComplexPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.DoublePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.EnumerationPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.InspectorPath;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.util.MathUtils;
import java.util.Objects;
import javafx.geometry.VPos;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;

public class RowConstraintsPropertyMetadata
extends ComplexPropertyMetadata<RowConstraints> {
    private static final RowConstraints DEFAULT = new RowConstraints();
    private final BooleanPropertyMetadata fillHeightMetadata = new BooleanPropertyMetadata(new PropertyName("fillHeight"), true, DEFAULT.isFillHeight(), InspectorPath.UNUSED);
    private final DoublePropertyMetadata maxHeightMetadata = new DoublePropertyMetadata(new PropertyName("maxHeight"), DoublePropertyMetadata.DoubleKind.USE_COMPUTED_SIZE, true, DEFAULT.getMaxHeight(), InspectorPath.UNUSED);
    private final DoublePropertyMetadata minHeightMetadata = new DoublePropertyMetadata(new PropertyName("minHeight"), DoublePropertyMetadata.DoubleKind.USE_COMPUTED_SIZE, true, DEFAULT.getMinHeight(), InspectorPath.UNUSED);
    private final DoublePropertyMetadata percentHeightMetadata = new DoublePropertyMetadata(new PropertyName("percentHeight"), DoublePropertyMetadata.DoubleKind.PERCENTAGE, true, DEFAULT.getPercentHeight(), InspectorPath.UNUSED);
    private final DoublePropertyMetadata prefHeightMetadata = new DoublePropertyMetadata(new PropertyName("prefHeight"), DoublePropertyMetadata.DoubleKind.USE_PREF_SIZE, true, DEFAULT.getPrefHeight(), InspectorPath.UNUSED);
    private final EnumerationPropertyMetadata valignmentMetadata = new EnumerationPropertyMetadata(new PropertyName("valignment"), VPos.class, "INHERIT", true, InspectorPath.UNUSED);
    private final EnumerationPropertyMetadata vgrowMetadata = new EnumerationPropertyMetadata(new PropertyName("vgrow"), Priority.class, "INHERIT", true, InspectorPath.UNUSED);

    public RowConstraintsPropertyMetadata(PropertyName name, boolean readWrite, RowConstraints defaultValue, InspectorPath inspectorPath) {
        super(name, RowConstraints.class, readWrite, defaultValue, inspectorPath);
    }

    public static boolean equals(RowConstraints r1, RowConstraints r2) {
        assert (r1 != null);
        assert (r2 != null);
        boolean result = r1 == r2 ? true : Objects.equals(r1.getValignment(), r2.getValignment()) && Objects.equals(r1.getVgrow(), r2.getVgrow()) && MathUtils.equals(r1.getMaxHeight(), r2.getMaxHeight()) && MathUtils.equals(r1.getMinHeight(), r2.getMinHeight()) && MathUtils.equals(r1.getPercentHeight(), r2.getPercentHeight()) && MathUtils.equals(r1.getPrefHeight(), r2.getPrefHeight());
        return result;
    }

    @Override
    public FXOMInstance makeFxomInstanceFromValue(RowConstraints value, FXOMDocument fxomDocument) {
        FXOMInstance result = new FXOMInstance(fxomDocument, this.getValueClass());
        this.fillHeightMetadata.setValue(result, value.isFillHeight());
        this.maxHeightMetadata.setValue(result, value.getMaxHeight());
        this.minHeightMetadata.setValue(result, value.getMinHeight());
        this.percentHeightMetadata.setValue(result, value.getPercentHeight());
        this.prefHeightMetadata.setValue(result, value.getPrefHeight());
        VPos valignment = value.getValignment();
        if (valignment == null) {
            this.valignmentMetadata.setValue(result, this.valignmentMetadata.getDefaultValue());
        } else {
            this.valignmentMetadata.setValue(result, valignment.toString());
        }
        Priority vgrow = value.getVgrow();
        if (vgrow == null) {
            this.vgrowMetadata.setValue(result, this.vgrowMetadata.getDefaultValue());
        } else {
            this.vgrowMetadata.setValue(result, vgrow.toString());
        }
        return result;
    }
}

