/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.library.user;

import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.images.ImageUtils;
import com.oracle.javafx.scenebuilder.kit.library.BuiltinLibrary;
import com.oracle.javafx.scenebuilder.kit.library.LibraryItem;
import com.oracle.javafx.scenebuilder.kit.library.user.UserLibrary;
import com.oracle.javafx.scenebuilder.kit.library.util.JarExplorer;
import com.oracle.javafx.scenebuilder.kit.library.util.JarReport;
import com.oracle.javafx.scenebuilder.kit.library.util.JarReportEntry;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Logger;

class LibraryFolderWatcher
implements Runnable {
    private final UserLibrary library;

    public LibraryFolderWatcher(UserLibrary library) {
        this.library = library;
    }

    @Override
    public void run() {
        try {
            this.library.updateExplorationCount(0);
            this.library.updateExplorationDate(new Date());
            this.runDiscovery();
            this.runWatching();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDiscovery() throws InterruptedException {
        boolean retry;
        Path folder = Paths.get(this.library.getPath(), new String[0]);
        this.library.setItems((Collection<LibraryItem>)BuiltinLibrary.getLibrary().getItems());
        do {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(folder);){
                HashSet<Path> currentJars = new HashSet<Path>();
                HashSet<Path> currentFxmls = new HashSet<Path>();
                for (Path entry : stream) {
                    if (LibraryFolderWatcher.isJarPath(entry)) {
                        currentJars.add(entry);
                        continue;
                    }
                    if (!LibraryFolderWatcher.isFxmlPath(entry)) continue;
                    currentFxmls.add(entry);
                }
                this.updateLibrary(currentFxmls);
                this.exploreAndUpdateLibrary(currentJars);
                retry = false;
            }
            catch (IOException x) {
                Thread.sleep(2000L);
                retry = true;
            }
            finally {
                this.library.updateExplorationCount(this.library.getExplorationCount() + 1);
            }
        } while (retry);
    }

    private void runWatching() throws InterruptedException {
        block4: while (true) {
            Path folder = Paths.get(this.library.getPath(), new String[0]);
            WatchService watchService = null;
            while (watchService == null) {
                try {
                    watchService = folder.getFileSystem().newWatchService();
                }
                catch (IOException x) {
                    System.out.println("FileSystem.newWatchService() failed");
                    System.out.println("Sleeping...");
                    Thread.sleep(1000L);
                }
            }
            WatchKey watchKey = null;
            while (true) {
                if (watchKey != null && watchKey.isValid()) continue block4;
                try {
                    WatchKey wk;
                    watchKey = folder.register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                    do {
                        wk = watchService.take();
                        assert (wk == watchKey);
                        boolean isDirty = false;
                        for (WatchEvent<?> e : wk.pollEvents()) {
                            WatchEvent.Kind<?> kind = e.kind();
                            Object context = e.context();
                            if (kind == StandardWatchEventKinds.ENTRY_CREATE || kind == StandardWatchEventKinds.ENTRY_DELETE || kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                                assert (context instanceof Path);
                                if (!LibraryFolderWatcher.isJarPath((Path)context) && !LibraryFolderWatcher.isFxmlPath((Path)context)) continue;
                                isDirty = true;
                                continue;
                            }
                            assert (kind == StandardWatchEventKinds.OVERFLOW);
                        }
                        if (!isDirty) continue;
                        this.library.setItems((Collection<LibraryItem>)BuiltinLibrary.getLibrary().getItems());
                        HashSet<Path> fxmls = new HashSet<Path>();
                        fxmls.addAll(this.getAllFiles(FILE_TYPE.FXML));
                        this.updateLibrary(fxmls);
                        HashSet<Path> jars = new HashSet<Path>();
                        jars.addAll(this.getAllFiles(FILE_TYPE.JAR));
                        this.exploreAndUpdateLibrary(jars);
                        this.library.updateExplorationCount(this.library.getExplorationCount() + 1);
                    } while (wk.reset());
                    continue;
                }
                catch (IOException x) {
                    Thread.sleep(1000L);
                    continue;
                }
                break;
            }
            break;
        }
    }

    private Set<Path> getAllFiles(FILE_TYPE fileType) throws IOException {
        HashSet<Path> res = new HashSet<Path>();
        Path folder = Paths.get(this.library.getPath(), new String[0]);
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(folder);){
            for (Path p : ds) {
                switch (fileType) {
                    case FXML: {
                        if (!LibraryFolderWatcher.isFxmlPath(p)) break;
                        res.add(p);
                        break;
                    }
                    case JAR: {
                        if (!LibraryFolderWatcher.isJarPath(p)) break;
                        res.add(p);
                        break;
                    }
                }
            }
        }
        return res;
    }

    private static boolean isJarPath(Path path) {
        String pathString = path.toString().toLowerCase(Locale.ROOT);
        return pathString.endsWith(".jar");
    }

    private static boolean isFxmlPath(Path path) {
        String pathString = path.toString().toLowerCase(Locale.ROOT);
        return pathString.endsWith(".fxml");
    }

    private void updateLibrary(Collection<Path> paths) throws IOException {
        ArrayList<LibraryItem> newItems = new ArrayList<LibraryItem>();
        for (Path path : paths) {
            newItems.add(this.makeLibraryItem(path));
        }
        this.library.addItems(newItems);
        this.library.updateFxmlFileReports(paths);
        this.library.updateExplorationDate(new Date());
    }

    private LibraryItem makeLibraryItem(Path path) throws IOException {
        URL iconURL = ImageUtils.getNodeIconURL(null);
        String fileName = path.getFileName().toString();
        String itemName = fileName.substring(0, fileName.indexOf(".fxml"));
        String fxmlText = "";
        StringBuilder buf = new StringBuilder();
        try (LineNumberReader reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(path.toFile()), "UTF-8"));){
            String line;
            while ((line = reader.readLine()) != null) {
                buf.append(line).append("\n");
            }
            fxmlText = buf.toString();
        }
        LibraryItem res = new LibraryItem(itemName, "Custom", fxmlText, iconURL, this.library);
        return res;
    }

    private void exploreAndUpdateLibrary(Collection<Path> jars) throws IOException {
        URLClassLoader classLoader = jars.isEmpty() ? null : new URLClassLoader(this.makeURLArrayFromPaths(jars));
        ArrayList<JarReport> jarReports = new ArrayList<JarReport>();
        for (Path currentJar : jars) {
            Logger.getLogger(this.getClass().getSimpleName()).info(I18N.getString("log.info.explore.jar", currentJar));
            JarExplorer explorer = new JarExplorer(currentJar);
            jarReports.add(explorer.explore(classLoader));
        }
        ArrayList<LibraryItem> newItems = new ArrayList<LibraryItem>();
        for (JarReport jarReport : jarReports) {
            newItems.addAll(this.makeLibraryItems(jarReport));
        }
        this.library.updateClassLoader(classLoader);
        this.library.addItems(newItems);
        this.library.updateJarReports(new ArrayList<JarReport>(jarReports));
        this.library.updateExplorationDate(new Date());
    }

    private Collection<LibraryItem> makeLibraryItems(JarReport jarReport) throws IOException {
        ArrayList<LibraryItem> result = new ArrayList<LibraryItem>();
        URL iconURL = ImageUtils.getNodeIconURL(null);
        List<String> excludedItems = this.library.getFilter();
        for (JarReportEntry e : jarReport.getEntries()) {
            String canonicalName;
            if (e.getStatus() != JarReportEntry.Status.OK || !e.isNode() || excludedItems.contains(canonicalName = e.getKlass().getCanonicalName())) continue;
            String name = e.getKlass().getSimpleName();
            String fxmlText = JarExplorer.makeFxmlText(e.getKlass());
            result.add(new LibraryItem(name, "Custom", fxmlText, iconURL, this.library));
        }
        return result;
    }

    private URL[] makeURLArrayFromPaths(Collection<Path> paths) {
        URL[] result = new URL[paths.size()];
        int i = 0;
        for (Path p : paths) {
            try {
                result[i++] = new URL("jar", "", p.toUri().toURL() + "!/");
            }
            catch (MalformedURLException x) {
                throw new RuntimeException("Bug in " + this.getClass().getSimpleName(), x);
            }
        }
        return result;
    }

    private static enum FILE_TYPE {
        FXML,
        JAR;

    }
}

