/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMCollection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMIntrinsic;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNodes;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyT;
import com.oracle.javafx.scenebuilder.kit.fxom.FxIdCollector;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PrefixedValue;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FXOMCloner {
    private final FXOMDocument targetDocument;
    private final FxIdCollector fxIdCollector;
    private FXOMObject clonee;
    private final Set<String> addedFxIds = new HashSet<String>();

    public FXOMCloner(FXOMDocument targetDocument) {
        assert (targetDocument != null);
        this.targetDocument = targetDocument;
        this.fxIdCollector = new FxIdCollector(targetDocument);
    }

    public FXOMDocument getTargetDocument() {
        return this.targetDocument;
    }

    public FXOMObject clone(FXOMObject clonee) {
        return this.clone(clonee, false);
    }

    public FXOMObject clone(FXOMObject clonee, boolean preserveCloneeFxId) {
        assert (clonee != null);
        assert (this.addedFxIds.isEmpty());
        this.clonee = clonee;
        FXOMObject result = this.cloneObject(this.clonee);
        this.addedFxIds.clear();
        this.renameFxIds(result, preserveCloneeFxId);
        return result;
    }

    private FXOMObject cloneObject(FXOMObject fxomObject) {
        FXOMObject result;
        if (fxomObject instanceof FXOMCollection) {
            result = this.cloneCollection((FXOMCollection)fxomObject);
        } else if (fxomObject instanceof FXOMInstance) {
            result = this.cloneInstance((FXOMInstance)fxomObject);
        } else if (fxomObject instanceof FXOMIntrinsic) {
            result = this.cloneIntrinsic((FXOMIntrinsic)fxomObject);
        } else {
            throw new RuntimeException(this.getClass().getSimpleName() + " needs some additional implementation");
        }
        return result;
    }

    private FXOMCollection cloneCollection(FXOMCollection source) {
        assert (source != null);
        FXOMCollection result = new FXOMCollection(this.targetDocument, source.getDeclaredClass());
        for (FXOMObject sourceItem : source.getItems()) {
            FXOMObject newItem = this.cloneObject(sourceItem);
            newItem.addToParentCollection(-1, result);
        }
        result.setFxConstant(source.getFxConstant());
        result.setFxController(source.getFxController());
        result.setFxFactory(source.getFxFactory());
        result.setFxId(source.getFxId());
        result.setFxValue(source.getFxValue());
        return result;
    }

    private FXOMInstance cloneInstance(FXOMInstance source) {
        FXOMInstance result;
        assert (source != null);
        if (source.getDeclaredClass() == null) {
            assert (source.getSceneGraphObject() == null);
            result = new FXOMInstance(this.targetDocument, source.getGlueElement().getTagName());
        } else {
            result = new FXOMInstance(this.targetDocument, source.getDeclaredClass());
        }
        for (Map.Entry<PropertyName, FXOMProperty> e : source.getProperties().entrySet()) {
            FXOMProperty newProperty = this.cloneProperty(e.getValue());
            if (newProperty == null) continue;
            newProperty.addToParentInstance(-1, result);
        }
        result.setFxConstant(source.getFxConstant());
        result.setFxController(source.getFxController());
        result.setFxFactory(source.getFxFactory());
        result.setFxId(source.getFxId());
        result.setFxValue(source.getFxValue());
        return result;
    }

    private FXOMObject cloneIntrinsic(FXOMIntrinsic source) {
        FXOMObject result;
        boolean shallowClone;
        FXOMObject sourceObject;
        assert (source != null);
        switch (source.getType()) {
            case FX_REFERENCE: 
            case FX_COPY: {
                String sourceFxId = source.getSource();
                assert (sourceFxId != null);
                sourceObject = this.clonee.getFxomDocument().searchWithFxId(sourceFxId);
                if (this.isInsideClonee(sourceObject) || this.addedFxIds.contains(sourceFxId)) {
                    shallowClone = true;
                    break;
                }
                shallowClone = false;
                this.addedFxIds.add(sourceFxId);
                break;
            }
            default: {
                sourceObject = null;
                shallowClone = true;
            }
        }
        if (shallowClone) {
            result = new FXOMIntrinsic(this.targetDocument, source.getType(), source.getSource());
            result.setFxConstant(source.getFxConstant());
            result.setFxController(source.getFxController());
            result.setFxFactory(source.getFxFactory());
            result.setFxId(source.getFxId());
            result.setFxValue(source.getFxValue());
        } else {
            assert (sourceObject != null);
            result = this.cloneObject(sourceObject);
        }
        return result;
    }

    private FXOMProperty cloneProperty(FXOMProperty source) {
        FXOMProperty result;
        if (source instanceof FXOMPropertyC) {
            result = this.clonePropertyC((FXOMPropertyC)source);
        } else if (source instanceof FXOMPropertyT) {
            result = this.clonePropertyT((FXOMPropertyT)source);
        } else {
            throw new RuntimeException(this.getClass().getSimpleName() + " needs some additional implementation");
        }
        return result;
    }

    public FXOMPropertyC clonePropertyC(FXOMPropertyC source) {
        assert (source != null);
        FXOMPropertyC result = new FXOMPropertyC(this.targetDocument, source.getName());
        for (FXOMObject sourceValue : source.getValues()) {
            FXOMObject newValue = this.cloneObject(sourceValue);
            newValue.addToParentProperty(-1, result);
        }
        return result;
    }

    public FXOMProperty clonePropertyT(FXOMPropertyT source) {
        FXOMProperty result;
        boolean shallowClone;
        FXOMObject sourceObject;
        assert (source != null);
        PrefixedValue pv = new PrefixedValue(source.getValue());
        if (pv.isExpression()) {
            String sourceFxId = pv.getSuffix();
            assert (sourceFxId != null);
            sourceObject = this.clonee.getFxomDocument().searchWithFxId(sourceFxId);
            assert (sourceObject != null) : "sourceFxId=" + sourceFxId;
            if (this.isInsideClonee(sourceObject) || this.addedFxIds.contains(sourceFxId)) {
                shallowClone = true;
            } else {
                shallowClone = false;
                this.addedFxIds.add(sourceFxId);
            }
        } else {
            shallowClone = true;
            sourceObject = null;
        }
        if (shallowClone) {
            result = new FXOMPropertyT(this.targetDocument, source.getName(), source.getValue());
        } else {
            assert (sourceObject != null);
            result = FXOMNodes.isWeakReference(source) ? null : new FXOMPropertyC(this.targetDocument, source.getName(), this.cloneObject(sourceObject));
        }
        return result;
    }

    private boolean isInsideClonee(FXOMObject object) {
        assert (object != null);
        return object == this.clonee || object.isDescendantOf(this.clonee);
    }

    private void renameFxIds(FXOMObject clone, boolean preserveCloneeFxId) {
        Map<String, FXOMObject> fxIds = clone.collectFxIds();
        if (preserveCloneeFxId && this.clonee.getFxId() != null) {
            assert (this.clonee.getFxId().equals(clone.getFxId()));
            assert (fxIds.get(this.clonee.getFxId()) == clone);
            fxIds.remove(this.clonee.getFxId());
        }
        for (Map.Entry<String, FXOMObject> e : fxIds.entrySet()) {
            String candidateFxId = e.getKey();
            FXOMObject declarer = e.getValue();
            String renamedFxId = this.fxIdCollector.importFxId(candidateFxId);
            if (renamedFxId.equals(candidateFxId)) continue;
            declarer.setFxId(renamedFxId);
            for (FXOMIntrinsic reference : clone.collectReferences(candidateFxId)) {
                assert (reference.getSource().equals(candidateFxId));
                reference.setSource(renamedFxId);
            }
            PrefixedValue pv = new PrefixedValue(PrefixedValue.Type.EXPRESSION, renamedFxId);
            String newValue = pv.toString();
            for (FXOMPropertyT reference : FXOMNodes.collectReferenceExpression(clone, candidateFxId)) {
                reference.setValue(newValue);
            }
        }
    }
}

