/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.library;

import com.oracle.javafx.scenebuilder.kit.editor.panel.library.ImportWindowController;
import com.oracle.javafx.scenebuilder.kit.library.util.JarReportEntry;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;

class ImportRow {
    private final BooleanProperty importRequired;
    private final JarReportEntry jre;
    private ImportWindowController.PrefSize prefSize;
    private final String canonicalClassName;

    public ImportRow(boolean importRequired, JarReportEntry jre, ImportWindowController.PrefSize prefSize) {
        this.importRequired = new SimpleBooleanProperty(importRequired);
        this.jre = jre;
        this.canonicalClassName = jre.getKlass().getCanonicalName();
        this.prefSize = prefSize == null ? ImportWindowController.PrefSize.DEFAULT : prefSize;
    }

    public final BooleanProperty importRequired() {
        return this.importRequired;
    }

    public boolean isImportRequired() {
        return this.importRequired.get();
    }

    public void setImportRequired(boolean v) {
        this.importRequired().set(v);
    }

    public JarReportEntry getJarReportEntry() {
        return this.jre;
    }

    public ImportWindowController.PrefSize getPrefSize() {
        return this.prefSize;
    }

    public void setPrefSize(ImportWindowController.PrefSize value) {
        this.prefSize = value;
    }

    public String getCanonicalClassName() {
        return this.canonicalClassName;
    }

    public String toString() {
        return this.jre.getKlass().getSimpleName();
    }
}

