/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.util;

import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;

public class ScrollPaneBooster {
    public final ScrollPane scrollPane;

    public ScrollPaneBooster(ScrollPane scrollPane) {
        assert (scrollPane != null);
        this.scrollPane = scrollPane;
    }

    public void scrollTo(Node node) {
        assert (node != null);
    }

    public void scrollTo(Bounds targetRect) {
        Bounds visibleRect = this.getContentVisibleRect();
        if (!visibleRect.intersects(targetRect)) {
            double targetCenterX = (targetRect.getMinX() + targetRect.getMaxX()) / 2.0;
            double targetCenterY = (targetRect.getMinY() + targetRect.getMaxY()) / 2.0;
            boolean clamp = true;
            double hValue = this.xContentToHValue(targetCenterX, true);
            double vValue = this.yContentToVValue(targetCenterY, true);
            this.scrollPane.setHvalue(hValue);
            this.scrollPane.setVvalue(vValue);
        }
    }

    public double xContentToHValue(double x, boolean clamp) {
        double xNormalized = this.xContentToNormalized(x, clamp);
        double hmin = this.scrollPane.getHmin();
        double hmax = this.scrollPane.getHmax();
        return hmin + xNormalized * (hmax - hmin);
    }

    public double xContentToNormalized(double x, boolean clamp) {
        Bounds contentBounds = this.scrollPane.getContent().getLayoutBounds();
        Bounds visibleBounds = this.getContentVisibleRect();
        double minX = visibleBounds.getWidth() / 2.0 - contentBounds.getMinX();
        double maxX = contentBounds.getWidth() - visibleBounds.getWidth() / 2.0 - contentBounds.getMinX();
        double result = (x - minX) / (maxX - minX);
        if (clamp) {
            result = Math.max(Math.min(result, 1.0), 0.0);
        }
        return result;
    }

    public double yContentToVValue(double y, boolean clamp) {
        double yNormalized = this.yContentToNormalized(y, clamp);
        double vmin = this.scrollPane.getVmin();
        double vmax = this.scrollPane.getVmax();
        return vmin + yNormalized * (vmax - vmin);
    }

    public double yContentToNormalized(double y, boolean clamp) {
        Bounds contentBounds = this.scrollPane.getContent().getLayoutBounds();
        Bounds visibleBounds = this.getContentVisibleRect();
        double minY = visibleBounds.getHeight() / 2.0 - contentBounds.getMinY();
        double maxY = contentBounds.getHeight() - visibleBounds.getHeight() / 2.0 - contentBounds.getMinY();
        double result = (y - minY) / (maxY - minY);
        if (clamp) {
            result = Math.max(Math.min(result, 1.0), 0.0);
        }
        return result;
    }

    public Bounds getContentVisibleRect() {
        Bounds viewportBounds = this.scrollPane.getViewportBounds();
        Bounds contentBounds = this.scrollPane.getContent().getLayoutBounds();
        double minX = -viewportBounds.getMinX() - contentBounds.getMinX();
        double minY = -viewportBounds.getMinY() - contentBounds.getMinY();
        double width = viewportBounds.getWidth();
        double height = viewportBounds.getHeight();
        return new BoundingBox(minX, minY, width, height);
    }
}

