/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver;

import com.oracle.javafx.scenebuilder.kit.editor.drag.target.AbstractDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.drag.target.ContainerZDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.AbstractNodeDriver;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.tring.AbstractTring;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.tring.VBoxTring;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.layout.VBox;

public class VBoxDriver
extends AbstractNodeDriver {
    public VBoxDriver(ContentPanelController contentPanelController) {
        super(contentPanelController);
    }

    @Override
    public AbstractDropTarget makeDropTarget(FXOMObject fxomObject, double sceneX, double sceneY) {
        DesignHierarchyMask m;
        int targetIndex;
        assert (fxomObject instanceof FXOMInstance);
        assert (fxomObject.getSceneGraphObject() instanceof VBox);
        VBox hbox = (VBox)fxomObject.getSceneGraphObject();
        assert (hbox.getScene() != null);
        double localY = hbox.sceneToLocal(sceneX, sceneY, true).getY();
        int childCount = hbox.getChildrenUnmodifiable().size();
        if (childCount == 0) {
            targetIndex = -1;
        } else {
            Node child;
            Bounds childBounds;
            double midY;
            assert (childCount >= 1);
            int childIndex = 0;
            while (localY > (midY = ((childBounds = (child = (Node)hbox.getChildrenUnmodifiable().get(childIndex++)).getBoundsInParent()).getMinY() + childBounds.getMaxY()) / 2.0) && childIndex < childCount) {
            }
            if (localY <= midY) {
                assert (childIndex - 1 < childCount);
                targetIndex = childIndex - 1;
            } else {
                targetIndex = -1;
            }
        }
        FXOMObject beforeChild = targetIndex == -1 ? null : (targetIndex < (m = new DesignHierarchyMask(fxomObject)).getSubComponentCount() ? m.getSubComponentAtIndex(targetIndex) : null);
        return new ContainerZDropTarget((FXOMInstance)fxomObject, beforeChild);
    }

    @Override
    public AbstractTring<?> makeTring(AbstractDropTarget dropTarget) {
        assert (dropTarget instanceof ContainerZDropTarget);
        assert (dropTarget.getTargetObject() instanceof FXOMInstance);
        assert (dropTarget.getTargetObject().getSceneGraphObject() instanceof VBox);
        ContainerZDropTarget zDropTarget = (ContainerZDropTarget)dropTarget;
        int targetIndex = zDropTarget.getBeforeChild() == null ? -1 : zDropTarget.getBeforeChild().getIndexInParentProperty();
        return new VBoxTring(this.contentPanelController, (FXOMInstance)dropTarget.getTargetObject(), targetIndex);
    }
}

