/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.reference;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.InlineDocumentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.AddPropertyJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.RemoveObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.RemovePropertyJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.ReplacePropertyValueJobT;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNodes;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyT;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PrefixedValue;
import java.util.LinkedList;
import java.util.List;

public class FixToggleGroupExpressionReferenceJob
extends InlineDocumentJob {
    private final FXOMPropertyT reference;

    public FixToggleGroupExpressionReferenceJob(FXOMPropertyT reference, EditorController editorController) {
        super(editorController);
        assert (reference != null);
        assert (reference.getFxomDocument() == editorController.getFxomDocument());
        this.reference = reference;
    }

    @Override
    protected List<Job> makeAndExecuteSubJobs() {
        String fxId;
        LinkedList<Job> result = new LinkedList<Job>();
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        FXOMObject referee = fxomDocument.searchWithFxId(fxId = FXOMNodes.extractReferenceSource(this.reference));
        if (referee != null) {
            assert (referee.getParentProperty() != null);
            assert (referee.getParentProperty().getParentInstance() != null);
            FXOMInstance parentInstance = referee.getParentProperty().getParentInstance();
            RemoveObjectJob removeJob = new RemoveObjectJob(referee, this.getEditorController());
            removeJob.execute();
            result.add(removeJob);
            ReplacePropertyValueJobT replaceJob = new ReplacePropertyValueJobT(this.reference, referee, this.getEditorController());
            ((Job)replaceJob).execute();
            result.add(replaceJob);
            AddPropertyJob addJob = new AddPropertyJob(this.reference, parentInstance, -1, this.getEditorController());
            ((Job)addJob).execute();
            result.add(addJob);
        } else {
            FXOMInstance targetInstance = this.reference.getParentInstance();
            RemovePropertyJob removeJob = new RemovePropertyJob(this.reference, this.getEditorController());
            ((Job)removeJob).execute();
            result.add(removeJob);
            FXOMPropertyC newToggleGroup = FXOMNodes.makeToggleGroup(fxomDocument, fxId);
            AddPropertyJob addJob = new AddPropertyJob(newToggleGroup, targetInstance, -1, this.getEditorController());
            ((Job)addJob).execute();
            result.add(addJob);
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        return this.getClass().getSimpleName();
    }

    @Override
    public boolean isExecutable() {
        PrefixedValue pv = new PrefixedValue(this.reference.getValue());
        return pv.isExpression();
    }
}

