/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericValue;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class GenericValueUtil {
    public static NullableFunction<GenericValue, String> STRING_VALUE = genericValue -> genericValue.getStringValue();
    public static NullableFunction<GenericValue, Object> OBJECT_VALUE = genericValue -> genericValue.getValue();

    private GenericValueUtil() {
    }

    public static boolean containsString(Collection<? extends GenericValue<?>> collection, String value) {
        for (GenericValue<?> o : collection) {
            if (!Comparing.equal((String)value, (String)o.getStringValue())) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean containsValue(Collection<? extends GenericValue<? extends T>> collection, T value) {
        for (GenericValue<T> o : collection) {
            if (!Comparing.equal(value, o.getValue())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static <T> Collection<T> getValueCollection(Collection<? extends GenericValue<? extends T>> collection, Collection<T> result) {
        for (GenericValue<T> o : collection) {
            ContainerUtil.addIfNotNull(result, o.getValue());
        }
        Collection<T> collection2 = result;
        if (collection2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/GenericValueUtil", "getValueCollection"));
        }
        return collection2;
    }

    @NotNull
    public static Collection<String> getStringCollection(Collection<? extends GenericValue> collection, Collection<String> result) {
        for (GenericValue genericValue : collection) {
            ContainerUtil.addIfNotNull(result, (Object)genericValue.getStringValue());
        }
        Collection<String> collection2 = result;
        if (collection2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/GenericValueUtil", "getStringCollection"));
        }
        return collection2;
    }

    @NotNull
    public static Collection<String> getClassStringCollection(Collection<? extends GenericValue> collection, Collection<String> result) {
        for (GenericValue genericValue : collection) {
            String value = genericValue.getStringValue();
            if (value == null) continue;
            result.add(value.replace('$', '.'));
        }
        Collection<String> collection2 = result;
        if (collection2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/GenericValueUtil", "getClassStringCollection"));
        }
        return collection2;
    }
}

