/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.pom.Navigatable;
import com.intellij.pom.StatePreservingNavigatable;

public class OpenSourceUtil {
    private OpenSourceUtil() {
    }

    public static void openSourcesFrom(DataContext context, boolean requestFocus) {
        OpenSourceUtil.navigate(requestFocus, CommonDataKeys.NAVIGATABLE_ARRAY.getData(context));
    }

    public static void openSourcesFrom(DataProvider context, boolean requestFocus) {
        OpenSourceUtil.navigate(requestFocus, CommonDataKeys.NAVIGATABLE_ARRAY.getData(context));
    }

    public static void navigate(Navigatable ... navigatables) {
        OpenSourceUtil.navigate(true, navigatables);
    }

    public static void navigate(boolean requestFocus, Navigatable ... navigatables) {
        if (navigatables == null) {
            return;
        }
        for (Navigatable navigatable : navigatables) {
            if (!navigatable.canNavigate()) continue;
            navigatable.navigate(requestFocus);
        }
    }

    public static void navigate(boolean requestFocus, boolean tryNotToScroll, Navigatable ... navigatables) {
        if (navigatables == null) {
            return;
        }
        for (Navigatable navigatable : navigatables) {
            if (!navigatable.canNavigate()) continue;
            if (tryNotToScroll && navigatable instanceof StatePreservingNavigatable) {
                ((StatePreservingNavigatable)navigatable).navigate(requestFocus, true);
                continue;
            }
            navigatable.navigate(requestFocus);
        }
    }
}

