/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.Node;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageTargetNode;
import com.intellij.usages.impl.UsageViewTreeModelBuilder;
import com.intellij.usages.rules.MergeableUsage;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GroupNode
extends Node
implements Navigatable,
Comparable<GroupNode> {
    private static final NodeComparator COMPARATOR = new NodeComparator();
    private final Object lock;
    private final UsageGroup myGroup;
    private final int myRuleIndex;
    private final Map<UsageGroup, GroupNode> mySubgroupNodes;
    private final List<UsageNode> myUsageNodes;
    @NotNull
    private final UsageViewTreeModelBuilder myUsageTreeModel;
    private volatile int myRecursiveUsageCount;

    public GroupNode(@Nullable UsageGroup group, int ruleIndex, @NotNull UsageViewTreeModelBuilder treeModel) {
        if (treeModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeModel", "com/intellij/usages/impl/GroupNode", "<init>"));
        }
        super(treeModel);
        this.lock = new Object();
        this.mySubgroupNodes = new THashMap();
        this.myUsageNodes = new SmartList();
        this.myUsageTreeModel = treeModel;
        this.setUserObject(group);
        this.myGroup = group;
        this.myRuleIndex = ruleIndex;
    }

    @Override
    protected void updateNotify() {
        if (this.myGroup != null) {
            this.myGroup.update();
        }
    }

    @Override
    public String toString() {
        String result = "";
        if (this.myGroup != null) {
            result = this.myGroup.getText(null);
        }
        if (this.children == null) {
            return result;
        }
        return result + this.children.subList(0, Math.min(10, this.children.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupNode addGroup(@NotNull UsageGroup group, int ruleIndex, @NotNull Consumer<Runnable> edtQueue) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/usages/impl/GroupNode", "addGroup"));
        }
        if (edtQueue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edtQueue", "com/intellij/usages/impl/GroupNode", "addGroup"));
        }
        Object object = this.lock;
        synchronized (object) {
            GroupNode node = this.mySubgroupNodes.get(group);
            if (node == null) {
                GroupNode node1 = node = new GroupNode(group, ruleIndex, this.getBuilder());
                this.mySubgroupNodes.put(group, node);
                this.addNode(node1, edtQueue);
            }
            return node;
        }
    }

    void addNode(@NotNull DefaultMutableTreeNode node, @NotNull Consumer<Runnable> edtQueue) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/usages/impl/GroupNode", "addNode"));
        }
        if (edtQueue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edtQueue", "com/intellij/usages/impl/GroupNode", "addNode"));
        }
        if (!this.getBuilder().isDetachedMode()) {
            edtQueue.consume(() -> {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/usages/impl/GroupNode", "lambda$addNode$0"));
                }
                this.myTreeModel.insertNodeInto(node, this, this.getNodeInsertionIndex(node));
            });
        }
    }

    private UsageViewTreeModelBuilder getBuilder() {
        return (UsageViewTreeModelBuilder)this.myTreeModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllChildren() {
        Object object = this.lock;
        synchronized (object) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            super.removeAllChildren();
            this.mySubgroupNodes.clear();
            this.myRecursiveUsageCount = 0;
            this.myUsageNodes.clear();
        }
        this.myTreeModel.reload(this);
    }

    @Nullable
    private UsageNode tryMerge(@NotNull Usage usage) {
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/usages/impl/GroupNode", "tryMerge"));
        }
        if (!(usage instanceof MergeableUsage)) {
            return null;
        }
        MergeableUsage mergeableUsage = (MergeableUsage)((Object)usage);
        for (UsageNode node : this.myUsageNodes) {
            Usage original = node.getUsage();
            if (original == mergeableUsage) {
                return node;
            }
            if (!(original instanceof MergeableUsage) || !((MergeableUsage)((Object)original)).merge(mergeableUsage)) continue;
            return node;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeUsage(@NotNull UsageNode usage) {
        boolean removed;
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/usages/impl/GroupNode", "removeUsage"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Collection<GroupNode> groupNodes = this.mySubgroupNodes.values();
        Iterator<GroupNode> iterator = groupNodes.iterator();
        while (iterator.hasNext()) {
            GroupNode groupNode = iterator.next();
            if (!groupNode.removeUsage(usage)) continue;
            this.doUpdate();
            if (groupNode.getRecursiveUsageCount() == 0) {
                this.myTreeModel.removeNodeFromParent(groupNode);
                iterator.remove();
            }
            return true;
        }
        Object object = this.lock;
        synchronized (object) {
            removed = this.myUsageNodes.remove(usage);
        }
        if (removed) {
            this.doUpdate();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeUsagesBulk(@NotNull Set<UsageNode> usages) {
        boolean removed;
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/usages/impl/GroupNode", "removeUsagesBulk"));
        }
        Object object = this.lock;
        synchronized (object) {
            removed = this.myUsageNodes.removeAll(usages);
        }
        Collection<GroupNode> groupNodes = this.mySubgroupNodes.values();
        Iterator<GroupNode> iterator = groupNodes.iterator();
        while (iterator.hasNext()) {
            GroupNode groupNode = iterator.next();
            if (!groupNode.removeUsagesBulk(usages)) continue;
            if (groupNode.getRecursiveUsageCount() == 0) {
                MutableTreeNode parent = (MutableTreeNode)groupNode.getParent();
                int childIndex = parent.getIndex(groupNode);
                if (childIndex != -1) {
                    parent.remove(childIndex);
                }
                iterator.remove();
            }
            removed = true;
        }
        if (removed) {
            --this.myRecursiveUsageCount;
        }
        return removed;
    }

    private void doUpdate() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        --this.myRecursiveUsageCount;
        this.myTreeModel.nodeChanged(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UsageNode addUsage(@NotNull Usage usage, @NotNull Consumer<Runnable> edtQueue) {
        UsageNode node;
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/usages/impl/GroupNode", "addUsage"));
        }
        if (edtQueue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edtQueue", "com/intellij/usages/impl/GroupNode", "addUsage"));
        }
        Object object = this.lock;
        synchronized (object) {
            UsageNode mergedWith;
            if (this.myUsageTreeModel.isFilterDuplicatedLine() && (mergedWith = this.tryMerge(usage)) != null) {
                return mergedWith;
            }
            node = new UsageNode(usage, this.getBuilder());
            this.myUsageNodes.add(node);
        }
        if (!this.getBuilder().isDetachedMode()) {
            edtQueue.consume(() -> {
                this.myTreeModel.insertNodeInto(node, this, this.getNodeIndex(node));
                this.incrementUsageCount();
            });
        }
        return node;
    }

    private int getNodeIndex(@NotNull UsageNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/usages/impl/GroupNode", "getNodeIndex"));
        }
        int index = this.indexedBinarySearch(node);
        return index >= 0 ? index : -index - 1;
    }

    private int indexedBinarySearch(@NotNull UsageNode key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/usages/impl/GroupNode", "indexedBinarySearch"));
        }
        int low = 0;
        int high = this.getChildCount() - 1;
        while (low <= high) {
            int cmp;
            int mid = (low + high) / 2;
            TreeNode treeNode = this.getChildAt(mid);
            int n = cmp = treeNode instanceof UsageNode ? ((UsageNode)treeNode).compareTo(key) : -1;
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private void incrementUsageCount() {
        GroupNode groupNode = this;
        while (true) {
            ++groupNode.myRecursiveUsageCount;
            GroupNode node = groupNode;
            this.myTreeModel.nodeChanged(node);
            TreeNode parent = groupNode.getParent();
            if (!(parent instanceof GroupNode)) {
                return;
            }
            groupNode = (GroupNode)parent;
        }
    }

    @Override
    public String tree2string(int indent, String lineSeparator) {
        StringBuffer result = new StringBuffer();
        StringUtil.repeatSymbol((Appendable)result, (char)' ', (int)indent);
        if (this.myGroup != null) {
            result.append(this.myGroup);
        }
        result.append("[");
        result.append(lineSeparator);
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            result.append(node.tree2string(indent + 4, lineSeparator));
            result.append(lineSeparator);
        }
        StringUtil.repeatSymbol((Appendable)result, (char)' ', (int)indent);
        result.append("]");
        result.append(lineSeparator);
        return result.toString();
    }

    @Override
    protected boolean isDataValid() {
        return this.myGroup == null || this.myGroup.isValid();
    }

    @Override
    protected boolean isDataReadOnly() {
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            TreeNode element = enumeration.nextElement();
            if (!(element instanceof Node) || !((Node)element).isReadOnly()) continue;
            return true;
        }
        return false;
    }

    private int getNodeInsertionIndex(@NotNull DefaultMutableTreeNode node) {
        DefaultMutableTreeNode child;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/usages/impl/GroupNode", "getNodeInsertionIndex"));
        }
        Enumeration<TreeNode> children = this.children();
        int idx = 0;
        while (children.hasMoreElements() && COMPARATOR.compare(child = (DefaultMutableTreeNode)children.nextElement(), node) < 0) {
            ++idx;
        }
        return idx;
    }

    @Override
    public int compareTo(@NotNull GroupNode groupNode) {
        if (groupNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupNode", "com/intellij/usages/impl/GroupNode", "compareTo"));
        }
        if (this.myRuleIndex == groupNode.myRuleIndex) {
            return this.myGroup.compareTo(groupNode.myGroup);
        }
        return this.myRuleIndex - groupNode.myRuleIndex;
    }

    public UsageGroup getGroup() {
        return this.myGroup;
    }

    int getRecursiveUsageCount() {
        return this.myRecursiveUsageCount;
    }

    @Override
    public void navigate(boolean requestFocus) {
        if (this.myGroup != null) {
            this.myGroup.navigate(requestFocus);
        }
    }

    @Override
    public boolean canNavigate() {
        return this.myGroup != null && this.myGroup.canNavigate();
    }

    @Override
    public boolean canNavigateToSource() {
        return this.myGroup != null && this.myGroup.canNavigateToSource();
    }

    @Override
    protected boolean isDataExcluded() {
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            if (node.isExcluded()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected String getText(@NotNull UsageView view) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/usages/impl/GroupNode", "getText"));
        }
        return this.myGroup.getText(view);
    }

    @NotNull
    public Collection<GroupNode> getSubGroups() {
        Collection<GroupNode> collection = this.mySubgroupNodes.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/GroupNode", "getSubGroups"));
        }
        return collection;
    }

    @NotNull
    public Collection<UsageNode> getUsageNodes() {
        List<UsageNode> list = this.myUsageNodes;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/GroupNode", "getUsageNodes"));
        }
        return list;
    }

    private static class NodeComparator
    implements Comparator<DefaultMutableTreeNode> {
        private NodeComparator() {
        }

        private static int getClassIndex(DefaultMutableTreeNode node) {
            if (node instanceof UsageNode) {
                return 3;
            }
            if (node instanceof GroupNode) {
                return 2;
            }
            if (node instanceof UsageTargetNode) {
                return 1;
            }
            return 0;
        }

        @Override
        public int compare(DefaultMutableTreeNode n1, DefaultMutableTreeNode n2) {
            int classIdx2;
            int classIdx1 = NodeComparator.getClassIndex(n1);
            if (classIdx1 != (classIdx2 = NodeComparator.getClassIndex(n2))) {
                return classIdx1 - classIdx2;
            }
            if (classIdx1 == 2) {
                return ((GroupNode)n1).compareTo((GroupNode)n2);
            }
            return 0;
        }
    }
}

