/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWalkingState;
import com.intellij.psi.XmlElementVisitor;
import java.util.List;

public class XmlRecursiveElementWalkingVisitor
extends XmlElementVisitor {
    private final boolean myVisitAllFileRoots;
    private final PsiWalkingState myWalkingState = new PsiWalkingState(this){};

    public XmlRecursiveElementWalkingVisitor() {
        this(false);
    }

    public XmlRecursiveElementWalkingVisitor(boolean visitAllFileRoots) {
        this.myVisitAllFileRoots = visitAllFileRoots;
    }

    @Override
    public void visitElement(PsiElement element) {
        this.myWalkingState.elementStarted(element);
    }

    @Override
    public void visitFile(PsiFile file) {
        FileViewProvider viewProvider;
        List<PsiFile> allFiles;
        if (this.myVisitAllFileRoots && (allFiles = (viewProvider = file.getViewProvider()).getAllFiles()).size() > 1 && file == viewProvider.getPsi(viewProvider.getBaseLanguage())) {
            for (PsiFile lFile : allFiles) {
                lFile.acceptChildren(this);
            }
            return;
        }
        super.visitFile(file);
    }
}

