/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.CompositeSettingsEditor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditorListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.ui.UserActivityListener;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class SettingsEditor<Settings>
implements Disposable {
    private final List<SettingsEditorListener<Settings>> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private UserActivityWatcher myWatcher;
    private boolean myIsInUpdate = false;
    private final Factory<Settings> mySettingsFactory;
    private CompositeSettingsEditor<Settings> myOwner;
    private JComponent myEditorComponent;

    protected abstract void resetEditorFrom(@NotNull Settings var1);

    protected abstract void applyEditorTo(@NotNull Settings var1) throws ConfigurationException;

    @NotNull
    protected abstract JComponent createEditor();

    protected void disposeEditor() {
    }

    public SettingsEditor() {
        this(null);
    }

    public SettingsEditor(Factory<Settings> settingsFactory) {
        this.mySettingsFactory = settingsFactory;
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                SettingsEditor.this.disposeEditor();
                SettingsEditor.this.uninstallWatcher();
            }
        });
    }

    public Settings getSnapshot() throws ConfigurationException {
        if (this.myOwner != null) {
            return this.myOwner.getSnapshot();
        }
        Object settings = this.mySettingsFactory.create();
        this.applyTo(settings);
        return (Settings)settings;
    }

    final void setOwner(CompositeSettingsEditor<Settings> owner) {
        this.myOwner = owner;
    }

    public final CompositeSettingsEditor<Settings> getOwner() {
        return this.myOwner;
    }

    public Factory<Settings> getFactory() {
        return this.mySettingsFactory;
    }

    public final void resetFrom(Settings s) {
        this.myIsInUpdate = true;
        try {
            this.resetEditorFrom(s);
        }
        finally {
            this.myIsInUpdate = false;
        }
    }

    public final void applyTo(Settings s) throws ConfigurationException {
        this.applyEditorTo(s);
    }

    public final JComponent getComponent() {
        if (this.myEditorComponent == null) {
            this.myEditorComponent = this.createEditor();
            this.installWatcher(this.myEditorComponent);
        }
        return this.myEditorComponent;
    }

    public final void dispose() {
    }

    protected void uninstallWatcher() {
        this.myWatcher = null;
    }

    protected void installWatcher(JComponent c) {
        this.myWatcher = new UserActivityWatcher();
        this.myWatcher.register(c);
        UserActivityListener userActivityListener = new UserActivityListener(){

            @Override
            public void stateChanged() {
                SettingsEditor.this.fireEditorStateChanged();
            }
        };
        this.myWatcher.addUserActivityListener(userActivityListener, this);
    }

    public final void addSettingsEditorListener(SettingsEditorListener<Settings> listener) {
        this.myListeners.add(listener);
    }

    public final void removeSettingsEditorListener(SettingsEditorListener<Settings> listener) {
        this.myListeners.remove(listener);
    }

    protected final void fireEditorStateChanged() {
        if (this.myIsInUpdate || this.myListeners == null) {
            return;
        }
        for (SettingsEditorListener<Settings> listener : this.myListeners) {
            listener.stateChanged(this);
        }
    }
}

