/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.Language;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageExtension<T>
extends KeyedExtensionCollector<T, Language> {
    private final T myDefaultImplementation;
    private final Key<T> IN_LANGUAGE_CACHE;

    public LanguageExtension(@NonNls String epName) {
        this(epName, null);
    }

    public LanguageExtension(@NonNls String epName, @Nullable T defaultImplementation) {
        super(epName);
        this.myDefaultImplementation = defaultImplementation;
        this.IN_LANGUAGE_CACHE = Key.create((String)("EXTENSIONS_IN_LANGUAGE_" + epName));
    }

    @Override
    @NotNull
    protected String keyToString(@NotNull Language key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/lang/LanguageExtension", "keyToString"));
        }
        String string = key.getID();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/LanguageExtension", "keyToString"));
        }
        return string;
    }

    public T forLanguage(@NotNull Language l) {
        Language base;
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/lang/LanguageExtension", "forLanguage"));
        }
        Object cached = l.getUserData(this.IN_LANGUAGE_CACHE);
        if (cached != null) {
            return (T)cached;
        }
        List extensions = this.forKey(l);
        Object result = extensions.isEmpty() ? ((base = l.getBaseLanguage()) == null ? this.myDefaultImplementation : this.forLanguage(base)) : extensions.get(0);
        if (result == null) {
            return null;
        }
        result = l.putUserDataIfAbsent(this.IN_LANGUAGE_CACHE, result);
        return result;
    }

    @NotNull
    public List<T> allForLanguage(@NotNull Language l) {
        Language base;
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/lang/LanguageExtension", "allForLanguage"));
        }
        List list = this.forKey(l);
        if (list.isEmpty() && (base = l.getBaseLanguage()) != null) {
            List<T> list2 = this.allForLanguage(base);
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/LanguageExtension", "allForLanguage"));
            }
            return list2;
        }
        List list3 = list;
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/LanguageExtension", "allForLanguage"));
        }
        return list3;
    }

    @NotNull
    public List<T> allForLanguageOrAny(@NotNull Language l) {
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/lang/LanguageExtension", "allForLanguageOrAny"));
        }
        List<T> providers = this.allForLanguage(l);
        if (l == Language.ANY) {
            List<T> list = providers;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/LanguageExtension", "allForLanguageOrAny"));
            }
            return list;
        }
        List list = ContainerUtil.concat(providers, this.allForLanguage(Language.ANY));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/LanguageExtension", "allForLanguageOrAny"));
        }
        return list;
    }

    protected T getDefaultImplementation() {
        return this.myDefaultImplementation;
    }

    @NotNull
    protected Key<T> getLanguageCache() {
        Key<T> key = this.IN_LANGUAGE_CACHE;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/LanguageExtension", "getLanguageCache"));
        }
        return key;
    }

    @NotNull
    protected Set<String> getAllBaseLanguageIdsWithAny(@NotNull Language key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/lang/LanguageExtension", "getAllBaseLanguageIdsWithAny"));
        }
        THashSet allowed = new THashSet();
        while (key != null) {
            allowed.add(this.keyToString(key));
            key = key.getBaseLanguage();
        }
        allowed.add("any");
        THashSet tHashSet = allowed;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/LanguageExtension", "getAllBaseLanguageIdsWithAny"));
        }
        return tHashSet;
    }
}

