/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.ColoredOutputTypeRegistry;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.LineSeparator;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnsiEscapeDecoder {
    private static final char ESC_CHAR = '\u001b';
    private static final String CSI = "\u001b[";
    private static final Pattern INNER_PATTERN = Pattern.compile(Pattern.quote("m\u001b["));
    private static final char BACKSPACE = '\b';
    private Key myCurrentTextAttributes;

    public void escapeText(@NotNull String text, @NotNull Key outputType, @NotNull ColoredTextAcceptor textAcceptor) {
        int escSeqBeginInd;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/process/AnsiEscapeDecoder", "escapeText"));
        }
        if (outputType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputType", "com/intellij/execution/process/AnsiEscapeDecoder", "escapeText"));
        }
        if (textAcceptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textAcceptor", "com/intellij/execution/process/AnsiEscapeDecoder", "escapeText"));
        }
        List<Pair<String, Key>> chunks = null;
        int pos = 0;
        text = AnsiEscapeDecoder.normalizeAsciiControlCharacters(text);
        while ((escSeqBeginInd = text.indexOf(CSI, pos)) >= 0) {
            int escSeqEndInd;
            if (pos < escSeqBeginInd) {
                chunks = this.processTextChunk(chunks, text.substring(pos, escSeqBeginInd), outputType, textAcceptor);
            }
            if ((escSeqEndInd = AnsiEscapeDecoder.findEscSeqEndIndex(text, escSeqBeginInd)) < 0) break;
            if (text.charAt(escSeqEndInd - 1) == 'm') {
                String escSeq = text.substring(escSeqBeginInd, escSeqEndInd);
                String colorAttribute = INNER_PATTERN.matcher(escSeq).replaceAll(";");
                this.myCurrentTextAttributes = ColoredOutputTypeRegistry.getInstance().getOutputKey(colorAttribute);
            }
            pos = escSeqEndInd;
        }
        if (pos < text.length()) {
            chunks = this.processTextChunk(chunks, text.substring(pos), outputType, textAcceptor);
        }
        if (chunks != null && textAcceptor instanceof ColoredChunksAcceptor) {
            ((ColoredChunksAcceptor)textAcceptor).coloredChunksAvailable(chunks);
        }
    }

    @NotNull
    private static String normalizeAsciiControlCharacters(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/process/AnsiEscapeDecoder", "normalizeAsciiControlCharacters"));
        }
        int ind = text.indexOf(8);
        if (ind == -1) {
            String string = text;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/AnsiEscapeDecoder", "normalizeAsciiControlCharacters"));
            }
            return string;
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        int guardIndex = 0;
        boolean removalFromPrevTextAttempted = false;
        while (i < text.length()) {
            LineSeparator lineSeparator = StringUtil.getLineSeparatorAt((CharSequence)text, (int)i);
            if (lineSeparator != null) {
                i += lineSeparator.getSeparatorString().length();
                result.append(lineSeparator.getSeparatorString());
                guardIndex = result.length();
                continue;
            }
            if (text.charAt(i) == '\b') {
                if (result.length() > guardIndex) {
                    result.setLength(result.length() - 1);
                } else if (guardIndex == 0) {
                    removalFromPrevTextAttempted = true;
                }
            } else {
                result.append(text.charAt(i));
            }
            ++i;
        }
        if (removalFromPrevTextAttempted) {
            result.insert(0, LineSeparator.LF.getSeparatorString());
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/AnsiEscapeDecoder", "normalizeAsciiControlCharacters"));
        }
        return string;
    }

    private static int findEscSeqEndIndex(@NotNull String text, int escSeqBeginInd) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/process/AnsiEscapeDecoder", "findEscSeqEndIndex"));
        }
        int beginInd = escSeqBeginInd;
        int letterInd;
        while ((letterInd = AnsiEscapeDecoder.findEscSeqLetterIndex(text, beginInd)) != -1) {
            if (text.charAt(letterInd) != 'm') {
                return beginInd == escSeqBeginInd ? letterInd + 1 : beginInd;
            }
            beginInd = letterInd + 1;
        }
        return beginInd == escSeqBeginInd ? -1 : beginInd;
    }

    private static int findEscSeqLetterIndex(@NotNull String text, int escSeqBeginInd) {
        char letter;
        char ch;
        int parameterEndInd;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/process/AnsiEscapeDecoder", "findEscSeqLetterIndex"));
        }
        if (!text.regionMatches(escSeqBeginInd, CSI, 0, CSI.length())) {
            return -1;
        }
        for (parameterEndInd = escSeqBeginInd + 2; parameterEndInd < text.length() && (Character.isDigit(ch = text.charAt(parameterEndInd)) || ch == ';'); ++parameterEndInd) {
        }
        if (parameterEndInd < text.length() && StringUtil.containsChar((String)"ABCDEFGHJKSTfmisu", (char)(letter = text.charAt(parameterEndInd)))) {
            return parameterEndInd;
        }
        return -1;
    }

    @Nullable
    private List<Pair<String, Key>> processTextChunk(@Nullable List<Pair<String, Key>> buffer, @NotNull String text, @NotNull Key outputType, @NotNull ColoredTextAcceptor textAcceptor) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/process/AnsiEscapeDecoder", "processTextChunk"));
        }
        if (outputType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputType", "com/intellij/execution/process/AnsiEscapeDecoder", "processTextChunk"));
        }
        if (textAcceptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textAcceptor", "com/intellij/execution/process/AnsiEscapeDecoder", "processTextChunk"));
        }
        Key attributes = this.getCurrentOutputAttributes(outputType);
        if (textAcceptor instanceof ColoredChunksAcceptor) {
            if (buffer == null) {
                buffer = ContainerUtil.newArrayListWithCapacity((int)1);
            }
            buffer.add(Pair.create((Object)text, (Object)attributes));
        } else {
            textAcceptor.coloredTextAvailable(text, attributes);
        }
        return buffer;
    }

    @NotNull
    protected Key getCurrentOutputAttributes(@NotNull Key outputType) {
        if (outputType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputType", "com/intellij/execution/process/AnsiEscapeDecoder", "getCurrentOutputAttributes"));
        }
        if (outputType == ProcessOutputTypes.STDERR || outputType == ProcessOutputTypes.SYSTEM) {
            Key key = outputType;
            if (key == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/AnsiEscapeDecoder", "getCurrentOutputAttributes"));
            }
            return key;
        }
        Key key = this.myCurrentTextAttributes != null ? this.myCurrentTextAttributes : outputType;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/AnsiEscapeDecoder", "getCurrentOutputAttributes"));
        }
        return key;
    }

    public void coloredTextAvailable(@NotNull List<Pair<String, Key>> textChunks, ColoredTextAcceptor textAcceptor) {
        if (textChunks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textChunks", "com/intellij/execution/process/AnsiEscapeDecoder", "coloredTextAvailable"));
        }
        for (Pair<String, Key> textChunk : textChunks) {
            textAcceptor.coloredTextAvailable((String)textChunk.getFirst(), (Key)textChunk.getSecond());
        }
    }

    public static interface ColoredTextAcceptor {
        public void coloredTextAvailable(String var1, Key var2);
    }

    public static interface ColoredChunksAcceptor
    extends ColoredTextAcceptor {
        public void coloredChunksAvailable(List<Pair<String, Key>> var1);
    }
}

