/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import org.jetbrains.annotations.NotNull;

public class LineCol {
    public final int line;
    public final int column;

    public LineCol(int line) {
        this(line, 0);
    }

    public LineCol(int line, int column) {
        this.line = line;
        this.column = column;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LineCol col = (LineCol)o;
        if (this.line != col.line) {
            return false;
        }
        return this.column == col.column;
    }

    public int hashCode() {
        int result = this.line;
        result = 31 * result + this.column;
        return result;
    }

    public String toString() {
        return String.format("{ line: %s, column: %s }", this.line, this.column);
    }

    @NotNull
    public static LineCol fromOffset(@NotNull Document document, int offset) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/LineCol", "fromOffset"));
        }
        if (offset < document.getTextLength()) {
            int line = document.getLineNumber(offset);
            int column = offset - document.getLineStartOffset(line);
            LineCol lineCol = new LineCol(line, column);
            if (lineCol == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/LineCol", "fromOffset"));
            }
            return lineCol;
        }
        int line = Math.max(0, document.getLineCount() - 1);
        int column = document.getLineEndOffset(line) - document.getLineStartOffset(line);
        LineCol lineCol = new LineCol(line, column);
        if (lineCol == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/LineCol", "fromOffset"));
        }
        return lineCol;
    }

    @NotNull
    public static LineCol fromCaret(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/LineCol", "fromCaret"));
        }
        LineCol lineCol = LineCol.fromOffset(editor.getDocument(), editor.getCaretModel().getOffset());
        if (lineCol == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/LineCol", "fromCaret"));
        }
        return lineCol;
    }

    public static int toOffset(@NotNull Document document, @NotNull LineCol linecol) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/LineCol", "toOffset"));
        }
        if (linecol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linecol", "com/intellij/diff/util/LineCol", "toOffset"));
        }
        return linecol.toOffset(document);
    }

    public static int toOffset(@NotNull Document document, int line, int col) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/LineCol", "toOffset"));
        }
        return new LineCol(line, col).toOffset(document);
    }

    public int toOffset(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/LineCol", "toOffset"));
        }
        if (this.line >= document.getLineCount()) {
            return document.getTextLength();
        }
        return Math.min(document.getLineStartOffset(this.line) + this.column, document.getLineEndOffset(this.line));
    }

    public int toOffset(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/LineCol", "toOffset"));
        }
        return this.toOffset(editor.getDocument());
    }
}

