/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightDisplayKey {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.HighlightDisplayKey");
    private static final Map<String, HighlightDisplayKey> ourNameToKeyMap = new THashMap();
    private static final Map<String, HighlightDisplayKey> ourIdToKeyMap = new THashMap();
    private static final Map<HighlightDisplayKey, Computable<String>> ourKeyToDisplayNameMap = new THashMap();
    private static final Map<HighlightDisplayKey, String> ourKeyToAlternativeIDMap = new THashMap();
    private final String myName;
    private final String myID;

    public static HighlightDisplayKey find(@NonNls @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/daemon/HighlightDisplayKey", "find"));
        }
        return ourNameToKeyMap.get(name);
    }

    @Nullable
    public static HighlightDisplayKey findById(@NonNls @NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/codeInsight/daemon/HighlightDisplayKey", "findById"));
        }
        HighlightDisplayKey key = ourIdToKeyMap.get(id);
        if (key != null) {
            return key;
        }
        key = ourNameToKeyMap.get(id);
        if (key != null && key.getID().equals(id)) {
            return key;
        }
        return null;
    }

    @Nullable
    public static HighlightDisplayKey register(@NonNls @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/daemon/HighlightDisplayKey", "register"));
        }
        HighlightDisplayKey key = HighlightDisplayKey.find(name);
        if (key != null) {
            LOG.error("Key with name '" + name + "' already registered with display name: " + HighlightDisplayKey.getDisplayNameByKey(key));
            return null;
        }
        return new HighlightDisplayKey(name);
    }

    @Nullable
    public static HighlightDisplayKey register(@NonNls @NotNull String name, @NotNull String displayName) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/daemon/HighlightDisplayKey", "register"));
        }
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/intellij/codeInsight/daemon/HighlightDisplayKey", "register"));
        }
        return HighlightDisplayKey.register(name, displayName, name);
    }

    @Nullable
    public static HighlightDisplayKey register(@NonNls @NotNull String name, @NotNull Computable<String> displayName) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/daemon/HighlightDisplayKey", "register"));
        }
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/intellij/codeInsight/daemon/HighlightDisplayKey", "register"));
        }
        return HighlightDisplayKey.register(name, displayName, name);
    }

    @Nullable
    public static HighlightDisplayKey register(@NonNls @NotNull String name, @NotNull String displayName, @NotNull @NonNls String id) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/daemon/HighlightDisplayKey", "register"));
        }
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/intellij/codeInsight/daemon/HighlightDisplayKey", "register"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/codeInsight/daemon/HighlightDisplayKey", "register"));
        }
        return HighlightDisplayKey.register(name, (Computable<String>)new Computable.PredefinedValueComputable((Object)displayName), id);
    }

    @Nullable
    public static HighlightDisplayKey register(@NonNls @NotNull String name, @NotNull Computable<String> displayName, @NotNull @NonNls String id) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/daemon/HighlightDisplayKey", "register"));
        }
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/intellij/codeInsight/daemon/HighlightDisplayKey", "register"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/codeInsight/daemon/HighlightDisplayKey", "register"));
        }
        HighlightDisplayKey key = HighlightDisplayKey.find(name);
        if (key != null) {
            LOG.error("Key with name '" + name + "' already registered with display name: " + HighlightDisplayKey.getDisplayNameByKey(key));
            return null;
        }
        HighlightDisplayKey highlightDisplayKey = new HighlightDisplayKey(name, id);
        ourKeyToDisplayNameMap.put(highlightDisplayKey, displayName);
        return highlightDisplayKey;
    }

    @Nullable
    public static HighlightDisplayKey register(@NonNls @NotNull String name, @NotNull Computable<String> displayName, @NonNls @NotNull String id, @NonNls @Nullable String alternativeID) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/daemon/HighlightDisplayKey", "register"));
        }
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/intellij/codeInsight/daemon/HighlightDisplayKey", "register"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/codeInsight/daemon/HighlightDisplayKey", "register"));
        }
        HighlightDisplayKey key = HighlightDisplayKey.register(name, displayName, id);
        if (alternativeID != null) {
            ourKeyToAlternativeIDMap.put(key, alternativeID);
        }
        return key;
    }

    @NotNull
    public static HighlightDisplayKey findOrRegister(@NonNls @NotNull String name, @NotNull String displayName) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/daemon/HighlightDisplayKey", "findOrRegister"));
        }
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/intellij/codeInsight/daemon/HighlightDisplayKey", "findOrRegister"));
        }
        HighlightDisplayKey highlightDisplayKey = HighlightDisplayKey.findOrRegister(name, displayName, null);
        if (highlightDisplayKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/HighlightDisplayKey", "findOrRegister"));
        }
        return highlightDisplayKey;
    }

    @NotNull
    public static HighlightDisplayKey findOrRegister(@NonNls @NotNull String name, @NotNull String displayName, @NonNls @Nullable String id) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/daemon/HighlightDisplayKey", "findOrRegister"));
        }
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/intellij/codeInsight/daemon/HighlightDisplayKey", "findOrRegister"));
        }
        HighlightDisplayKey key = HighlightDisplayKey.find(name);
        if (key == null) {
            key = HighlightDisplayKey.register(name, displayName, id != null ? id : name);
            assert (key != null) : name;
        }
        HighlightDisplayKey highlightDisplayKey = key;
        if (highlightDisplayKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/HighlightDisplayKey", "findOrRegister"));
        }
        return highlightDisplayKey;
    }

    @Nullable
    public static String getDisplayNameByKey(@Nullable HighlightDisplayKey key) {
        if (key == null) {
            return null;
        }
        Computable<String> computable = ourKeyToDisplayNameMap.get(key);
        return computable == null ? null : (String)computable.compute();
    }

    public static String getAlternativeID(@NotNull HighlightDisplayKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/daemon/HighlightDisplayKey", "getAlternativeID"));
        }
        return ourKeyToAlternativeIDMap.get(key);
    }

    private HighlightDisplayKey(@NonNls @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/daemon/HighlightDisplayKey", "<init>"));
        }
        this(name, name);
    }

    public HighlightDisplayKey(@NonNls @NotNull String name, @NonNls @NotNull String ID2) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/daemon/HighlightDisplayKey", "<init>"));
        }
        if (ID2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ID", "com/intellij/codeInsight/daemon/HighlightDisplayKey", "<init>"));
        }
        this.myName = name;
        this.myID = ID2;
        ourNameToKeyMap.put(this.myName, this);
        if (!Comparing.equal((String)ID2, (String)name)) {
            ourIdToKeyMap.put(ID2, this);
        }
    }

    public String toString() {
        return this.myName;
    }

    @NotNull
    public String getID() {
        String string = this.myID;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/HighlightDisplayKey", "getID"));
        }
        return string;
    }
}

