/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.messages;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.incremental.messages.BuildMessage;

public class FileGeneratedEvent
extends BuildMessage {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.incremental.messages.FileGeneratedEvent");
    private final Collection<Pair<String, String>> myPaths;
    private final BuildTarget<?> mySourceTarget;

    public FileGeneratedEvent(@NotNull BuildTarget<?> sourceTarget) {
        if (sourceTarget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceTarget", "org/jetbrains/jps/incremental/messages/FileGeneratedEvent", "<init>"));
        }
        super("", BuildMessage.Kind.INFO);
        this.myPaths = new ArrayList<Pair<String, String>>();
        this.mySourceTarget = sourceTarget;
    }

    @NotNull
    public BuildTarget<?> getSourceTarget() {
        BuildTarget<?> buildTarget = this.mySourceTarget;
        if (buildTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/messages/FileGeneratedEvent", "getSourceTarget"));
        }
        return buildTarget;
    }

    public void add(String root, String relativePath) {
        if (root != null && relativePath != null) {
            this.myPaths.add((Pair<String, String>)Pair.create((Object)FileUtil.toSystemIndependentName((String)root), (Object)FileUtil.toSystemIndependentName((String)relativePath)));
        } else {
            LOG.info("Invalid file generation event: root=" + root + "; relativePath=" + relativePath);
        }
    }

    @NotNull
    public Collection<Pair<String, String>> getPaths() {
        Collection<Pair<String, String>> collection = Collections.unmodifiableCollection(this.myPaths);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/messages/FileGeneratedEvent", "getPaths"));
        }
        return collection;
    }
}

