/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.CantRunException;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.junit.TestPackage;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.listeners.RefactoringElementListener;

class TestCategory
extends TestPackage {
    public TestCategory(JUnitConfiguration configuration, ExecutionEnvironment environment) {
        super(configuration, environment);
    }

    @Override
    protected GlobalSearchScope filterScope(JUnitConfiguration.Data data) throws CantRunException {
        return GlobalSearchScope.allScope((Project)this.getConfiguration().getProject());
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        PsiClass psiClass;
        Module module;
        JavaParametersUtil.checkAlternativeJRE((CommonJavaRunConfigurationParameters)this.getConfiguration());
        ProgramParametersUtil.checkWorkingDirectoryExist((CommonProgramRunConfigurationParameters)this.getConfiguration(), (Project)this.getConfiguration().getProject(), (Module)((JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule()).getModule());
        String category = this.getConfiguration().getPersistentData().getCategory();
        if (category == null || category.isEmpty()) {
            throw new RuntimeConfigurationError("Category is not specified");
        }
        JavaRunConfigurationModule configurationModule = (JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule();
        if (this.getSourceScope() == null) {
            configurationModule.checkForWarning();
        }
        if ((module = configurationModule.getModule()) != null && (psiClass = JavaExecutionUtil.findMainClass((Project)this.getConfiguration().getProject(), (String)category, (GlobalSearchScope)GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module))) == null) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"class.not.found.in.module.error.message", (Object[])new Object[]{category, configurationModule.getModuleName()}));
        }
    }

    @Override
    public String suggestActionName() {
        return "Tests of " + this.getConfiguration().getPersistentData().getCategory();
    }

    @Override
    public boolean isConfiguredByElement(JUnitConfiguration configuration, PsiClass testClass, PsiMethod testMethod, PsiPackage testPackage, PsiDirectory testDir) {
        return false;
    }

    @Override
    public RefactoringElementListener getListener(PsiElement element, JUnitConfiguration configuration) {
        return RefactoringListeners.getClassOrPackageListener((PsiElement)element, configuration.myCategory);
    }
}

