/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchPair;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import git4idea.config.GitConfigUtil;
import git4idea.config.UpdateMethod;
import git4idea.merge.MergeChangeCollector;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.update.GitMergeUpdater;
import git4idea.update.GitRebaseUpdater;
import git4idea.update.GitUpdateResult;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class GitUpdater {
    private static final Logger LOG = Logger.getInstance(GitUpdater.class);
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final Git myGit;
    @NotNull
    protected final VirtualFile myRoot;
    @NotNull
    protected final GitRepository myRepository;
    @NotNull
    protected final Map<VirtualFile, GitBranchPair> myTrackedBranches;
    @NotNull
    protected final ProgressIndicator myProgressIndicator;
    @NotNull
    protected final UpdatedFiles myUpdatedFiles;
    @NotNull
    protected final AbstractVcsHelper myVcsHelper;
    @NotNull
    protected final GitRepositoryManager myRepositoryManager;
    protected final GitVcs myVcs;
    protected GitRevisionNumber myBefore;

    protected GitUpdater(@NotNull Project project, @NotNull Git git, @NotNull VirtualFile root, @NotNull Map<VirtualFile, GitBranchPair> trackedBranches, @NotNull ProgressIndicator progressIndicator, @NotNull UpdatedFiles updatedFiles) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/update/GitUpdater", "<init>"));
        }
        if (git == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "git", "git4idea/update/GitUpdater", "<init>"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/update/GitUpdater", "<init>"));
        }
        if (trackedBranches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trackedBranches", "git4idea/update/GitUpdater", "<init>"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "git4idea/update/GitUpdater", "<init>"));
        }
        if (updatedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updatedFiles", "git4idea/update/GitUpdater", "<init>"));
        }
        this.myProject = project;
        this.myGit = git;
        this.myRoot = root;
        this.myTrackedBranches = trackedBranches;
        this.myProgressIndicator = progressIndicator;
        this.myUpdatedFiles = updatedFiles;
        this.myVcsHelper = AbstractVcsHelper.getInstance((Project)project);
        this.myVcs = GitVcs.getInstance(project);
        this.myRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
        this.myRepository = (GitRepository)ObjectUtils.assertNotNull((Object)this.myRepositoryManager.getRepositoryForRoot(this.myRoot));
    }

    @NotNull
    public static GitUpdater getUpdater(@NotNull Project project, @NotNull Git git, @NotNull Map<VirtualFile, GitBranchPair> trackedBranches, @NotNull VirtualFile root, @NotNull ProgressIndicator progressIndicator, @NotNull UpdatedFiles updatedFiles, @NotNull UpdateMethod updateMethod) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/update/GitUpdater", "getUpdater"));
        }
        if (git == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "git", "git4idea/update/GitUpdater", "getUpdater"));
        }
        if (trackedBranches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trackedBranches", "git4idea/update/GitUpdater", "getUpdater"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/update/GitUpdater", "getUpdater"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "git4idea/update/GitUpdater", "getUpdater"));
        }
        if (updatedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updatedFiles", "git4idea/update/GitUpdater", "getUpdater"));
        }
        if (updateMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateMethod", "git4idea/update/GitUpdater", "getUpdater"));
        }
        if (updateMethod == UpdateMethod.BRANCH_DEFAULT) {
            updateMethod = GitUpdater.resolveUpdateMethod(project, root);
        }
        GitUpdater gitUpdater = updateMethod == UpdateMethod.REBASE ? new GitRebaseUpdater(project, git, root, trackedBranches, progressIndicator, updatedFiles) : new GitMergeUpdater(project, git, root, trackedBranches, progressIndicator, updatedFiles);
        if (gitUpdater == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdater", "getUpdater"));
        }
        return gitUpdater;
    }

    @NotNull
    public static UpdateMethod resolveUpdateMethod(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/update/GitUpdater", "resolveUpdateMethod"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/update/GitUpdater", "resolveUpdateMethod"));
        }
        GitLocalBranch branch = GitBranchUtil.getCurrentBranch(project, root);
        boolean rebase = false;
        if (branch != null) {
            try {
                String rebaseValue = GitConfigUtil.getValue(project, root, "branch." + branch.getName() + ".rebase");
                rebase = rebaseValue != null && rebaseValue.equalsIgnoreCase("true");
            }
            catch (VcsException e) {
                LOG.warn("Couldn't get git config branch." + branch.getName() + ".rebase", (Throwable)e);
            }
        }
        UpdateMethod updateMethod = rebase ? UpdateMethod.REBASE : UpdateMethod.MERGE;
        if (updateMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdater", "resolveUpdateMethod"));
        }
        return updateMethod;
    }

    @NotNull
    public GitUpdateResult update() throws VcsException {
        this.markStart(this.myRoot);
        GitUpdateResult gitUpdateResult = this.doUpdate();
        GitUpdateResult gitUpdateResult2 = gitUpdateResult;
        if (gitUpdateResult2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdater", "update"));
        }
        return gitUpdateResult2;
        finally {
            this.markEnd(this.myRoot);
        }
    }

    public abstract boolean isSaveNeeded();

    public boolean isUpdateNeeded() throws VcsException {
        GitRemoteBranch dest = this.myTrackedBranches.get(this.myRoot).getDest();
        assert (dest != null);
        String remoteBranch = dest.getName();
        if (!this.hasRemoteChanges(remoteBranch)) {
            LOG.info("isUpdateNeeded: No remote changes, update is not needed");
            return false;
        }
        return true;
    }

    @NotNull
    protected abstract GitUpdateResult doUpdate();

    @NotNull
    GitBranchPair getSourceAndTarget() {
        GitBranchPair gitBranchPair = this.myTrackedBranches.get(this.myRoot);
        if (gitBranchPair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdater", "getSourceAndTarget"));
        }
        return gitBranchPair;
    }

    protected void markStart(VirtualFile root) throws VcsException {
        this.myBefore = GitRevisionNumber.resolve(this.myProject, root, "HEAD");
    }

    protected void markEnd(VirtualFile root) throws VcsException {
        MergeChangeCollector collector = new MergeChangeCollector(this.myProject, root, this.myBefore);
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        collector.collect(this.myUpdatedFiles, exceptions);
        if (!exceptions.isEmpty()) {
            throw exceptions.get(0);
        }
    }

    protected boolean hasRemoteChanges(@NotNull String remoteBranch) throws VcsException {
        if (remoteBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteBranch", "git4idea/update/GitUpdater", "hasRemoteChanges"));
        }
        GitSimpleHandler handler = new GitSimpleHandler(this.myProject, this.myRoot, GitCommand.REV_LIST);
        handler.setSilent(true);
        handler.addParameters("-1");
        handler.addParameters("HEAD.." + remoteBranch);
        String output = handler.run();
        return output != null && !output.isEmpty();
    }
}

