/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.EmptyConsumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.UserNameRegex;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogProviderRequirementsEx;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogRefresher;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.VcsLogSorter;
import com.intellij.vcs.log.graph.GraphColorManager;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.impl.facade.PermanentGraphImpl;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.LogDataImpl;
import com.intellij.vcs.log.util.StopWatch;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitTag;
import git4idea.GitUserRegistry;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBranchesCollection;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.GitHistoryUtils;
import git4idea.log.GitBekParentFixer;
import git4idea.log.GitRefManager;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitLogProvider
implements VcsLogProvider {
    private static final Logger LOG = Logger.getInstance(GitLogProvider.class);
    public static final Function<VcsRef, String> GET_TAG_NAME = ref -> ref.getType() == GitRefManager.TAG ? ref.getName() : null;
    public static final TObjectHashingStrategy<VcsRef> DONT_CONSIDER_SHA = new TObjectHashingStrategy<VcsRef>(){

        public int computeHashCode(@NotNull VcsRef ref) {
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "git4idea/log/GitLogProvider$1", "computeHashCode"));
            }
            return 31 * ref.getName().hashCode() + ref.getType().hashCode();
        }

        public boolean equals(@NotNull VcsRef ref1, @NotNull VcsRef ref2) {
            if (ref1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref1", "git4idea/log/GitLogProvider$1", "equals"));
            }
            if (ref2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref2", "git4idea/log/GitLogProvider$1", "equals"));
            }
            return ref1.getName().equals(ref2.getName()) && ref1.getType().equals(ref2.getType());
        }
    };
    @NotNull
    private final Project myProject;
    @NotNull
    private final GitVcs myVcs;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final GitUserRegistry myUserRegistry;
    @NotNull
    private final VcsLogRefManager myRefSorter;
    @NotNull
    private final VcsLogObjectsFactory myVcsObjectsFactory;

    public GitLogProvider(@NotNull Project project, @NotNull GitRepositoryManager repositoryManager, @NotNull VcsLogObjectsFactory factory, @NotNull GitUserRegistry userRegistry) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/log/GitLogProvider", "<init>"));
        }
        if (repositoryManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryManager", "git4idea/log/GitLogProvider", "<init>"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "git4idea/log/GitLogProvider", "<init>"));
        }
        if (userRegistry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userRegistry", "git4idea/log/GitLogProvider", "<init>"));
        }
        this.myProject = project;
        this.myRepositoryManager = repositoryManager;
        this.myUserRegistry = userRegistry;
        this.myRefSorter = new GitRefManager((RepositoryManager<GitRepository>)this.myRepositoryManager);
        this.myVcsObjectsFactory = factory;
        this.myVcs = (GitVcs)((Object)ObjectUtils.assertNotNull((Object)((Object)GitVcs.getInstance(project))));
    }

    @NotNull
    public VcsLogProvider.DetailedLogData readFirstBlock(@NotNull VirtualFile root, @NotNull VcsLogProvider.Requirements requirements) throws VcsException {
        Collection<Object> allDetails;
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/log/GitLogProvider", "readFirstBlock"));
        }
        if (requirements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requirements", "git4idea/log/GitLogProvider", "readFirstBlock"));
        }
        if (!this.isRepositoryReady(root)) {
            LogDataImpl logDataImpl = LogDataImpl.empty();
            if (logDataImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "readFirstBlock"));
            }
            return logDataImpl;
        }
        GitRepository repository = (GitRepository)ObjectUtils.assertNotNull((Object)this.myRepositoryManager.getRepositoryForRoot(root));
        int commitCount = requirements.getCommitCount() * 2;
        String[] params = new String[]{"HEAD", "--branches", "--remotes", "--max-count=" + commitCount};
        boolean refresh = requirements instanceof VcsLogProviderRequirementsEx && ((VcsLogProviderRequirementsEx)requirements).isRefresh();
        VcsLogProvider.DetailedLogData data = GitHistoryUtils.loadMetadata(this.myProject, root, params);
        Set safeRefs = data.getRefs();
        OpenTHashSet allRefs = new OpenTHashSet((Collection)safeRefs, DONT_CONSIDER_SHA);
        Set<VcsRef> branches = this.readBranches(repository);
        GitLogProvider.addNewElements(allRefs, branches);
        Set<String> currentTagNames = null;
        VcsLogProvider.DetailedLogData commitsFromTags = null;
        if (!refresh) {
            allDetails = data.getCommits();
        } else {
            VcsLogProviderRequirementsEx rex = (VcsLogProviderRequirementsEx)requirements;
            currentTagNames = this.readCurrentTagNames(root);
            GitLogProvider.addOldStillExistingTags((Set<VcsRef>)allRefs, currentTagNames, rex.getPreviousRefs());
            allDetails = GitLogProvider.newHashSet(data.getCommits());
            Set previousTags = GitLogProvider.newHashSet(ContainerUtil.mapNotNull((Collection)rex.getPreviousRefs(), GET_TAG_NAME));
            Set safeTags = GitLogProvider.newHashSet(ContainerUtil.mapNotNull((Collection)safeRefs, GET_TAG_NAME));
            Set<String> newUnmatchedTags = GitLogProvider.remove(currentTagNames, previousTags, safeTags);
            if (!newUnmatchedTags.isEmpty()) {
                commitsFromTags = this.loadSomeCommitsOnTaggedBranches(root, commitCount, newUnmatchedTags);
                GitLogProvider.addNewElements(allDetails, commitsFromTags.getCommits());
                GitLogProvider.addNewElements(allRefs, commitsFromTags.getRefs());
            }
        }
        StopWatch sw = StopWatch.start((String)("sorting commits in " + root.getName()));
        List<VcsCommitMetadata> sortedCommits = VcsLogSorter.sortByDateTopoOrder((Collection)allDetails);
        sortedCommits = sortedCommits.subList(0, Math.min(sortedCommits.size(), requirements.getCommitCount()));
        sw.report();
        if (LOG.isDebugEnabled()) {
            GitLogProvider.validateDataAndReportError(root, (Set<VcsRef>)allRefs, sortedCommits, data, branches, currentTagNames, commitsFromTags);
        }
        LogDataImpl logDataImpl = new LogDataImpl((Set)allRefs, sortedCommits);
        if (logDataImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "readFirstBlock"));
        }
        return logDataImpl;
    }

    private static void validateDataAndReportError(final @NotNull VirtualFile root, final @NotNull Set<VcsRef> allRefs, final @NotNull List<VcsCommitMetadata> sortedCommits, final @NotNull VcsLogProvider.DetailedLogData firstBlockSyncData, final @NotNull Set<VcsRef> manuallyReadBranches, final @Nullable Set<String> currentTagNames, final @Nullable VcsLogProvider.DetailedLogData commitsFromTags) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/log/GitLogProvider", "validateDataAndReportError"));
        }
        if (allRefs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allRefs", "git4idea/log/GitLogProvider", "validateDataAndReportError"));
        }
        if (sortedCommits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sortedCommits", "git4idea/log/GitLogProvider", "validateDataAndReportError"));
        }
        if (firstBlockSyncData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstBlockSyncData", "git4idea/log/GitLogProvider", "validateDataAndReportError"));
        }
        if (manuallyReadBranches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manuallyReadBranches", "git4idea/log/GitLogProvider", "validateDataAndReportError"));
        }
        StopWatch sw = StopWatch.start((String)("validating data in " + root.getName()));
        final Set refs = ContainerUtil.map2Set(allRefs, VcsRef::getCommitHash);
        PermanentGraphImpl.newInstance(sortedCommits, (GraphColorManager)new GraphColorManager<Hash>(){

            public int getColorOfBranch(@NotNull Hash headCommit) {
                if (headCommit == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headCommit", "git4idea/log/GitLogProvider$2", "getColorOfBranch"));
                }
                return 0;
            }

            public int getColorOfFragment(@NotNull Hash headCommit, int magicIndex) {
                if (headCommit == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headCommit", "git4idea/log/GitLogProvider$2", "getColorOfFragment"));
                }
                return 0;
            }

            public int compareHeads(@NotNull Hash head1, @NotNull Hash head2) {
                if (head1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "head1", "git4idea/log/GitLogProvider$2", "compareHeads"));
                }
                if (head2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "head2", "git4idea/log/GitLogProvider$2", "compareHeads"));
                }
                if (!refs.contains(head1) || !refs.contains(head2)) {
                    LOG.error("GitLogProvider returned inconsistent data", new Attachment[]{new Attachment("error-details.txt", GitLogProvider.printErrorDetails(root, allRefs, sortedCommits, firstBlockSyncData, manuallyReadBranches, currentTagNames, commitsFromTags))});
                }
                return 0;
            }
        }, (Set)refs);
        sw.report();
    }

    private static String printErrorDetails(@NotNull VirtualFile root, @NotNull Set<VcsRef> allRefs, @NotNull List<VcsCommitMetadata> sortedCommits, @NotNull VcsLogProvider.DetailedLogData firstBlockSyncData, @NotNull Set<VcsRef> manuallyReadBranches, @Nullable Set<String> currentTagNames, @Nullable VcsLogProvider.DetailedLogData commitsFromTags) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/log/GitLogProvider", "printErrorDetails"));
        }
        if (allRefs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allRefs", "git4idea/log/GitLogProvider", "printErrorDetails"));
        }
        if (sortedCommits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sortedCommits", "git4idea/log/GitLogProvider", "printErrorDetails"));
        }
        if (firstBlockSyncData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstBlockSyncData", "git4idea/log/GitLogProvider", "printErrorDetails"));
        }
        if (manuallyReadBranches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manuallyReadBranches", "git4idea/log/GitLogProvider", "printErrorDetails"));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[" + root.getName() + "]\n");
        sb.append("First block data from Git:\n");
        sb.append(GitLogProvider.printLogData(firstBlockSyncData));
        sb.append("\n\nManually read refs:\n");
        sb.append(GitLogProvider.printRefs(manuallyReadBranches));
        sb.append("\n\nCurrent tag names:\n");
        if (currentTagNames != null) {
            sb.append(StringUtil.join(currentTagNames, (String)", "));
            if (commitsFromTags != null) {
                sb.append(GitLogProvider.printLogData(commitsFromTags));
            } else {
                sb.append("\n\nCommits from new tags were not read.\n");
            }
        } else {
            sb.append("\n\nCurrent tags were not read\n");
        }
        sb.append("\n\nResult:\n");
        sb.append("\nCommits (last 100): \n");
        sb.append(GitLogProvider.printCommits(sortedCommits));
        sb.append("\nAll refs:\n");
        sb.append(GitLogProvider.printRefs(allRefs));
        return sb.toString();
    }

    @NotNull
    private static String printLogData(@NotNull VcsLogProvider.DetailedLogData firstBlockSyncData) {
        if (firstBlockSyncData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstBlockSyncData", "git4idea/log/GitLogProvider", "printLogData"));
        }
        String string = String.format("Last 100 commits:\n%s\nRefs:\n%s", GitLogProvider.printCommits(firstBlockSyncData.getCommits()), GitLogProvider.printRefs(firstBlockSyncData.getRefs()));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "printLogData"));
        }
        return string;
    }

    @NotNull
    private static String printCommits(@NotNull List<VcsCommitMetadata> commits) {
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "git4idea/log/GitLogProvider", "printCommits"));
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < Math.min(commits.size(), 100); ++i) {
            GraphCommit commit = (GraphCommit)commits.get(i);
            sb.append(String.format("%s -> %s\n", ((Hash)commit.getId()).toShortString(), StringUtil.join((Collection)commit.getParents(), Hash::toShortString, (String)", ")));
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "printCommits"));
        }
        return string;
    }

    @NotNull
    private static String printRefs(@NotNull Set<VcsRef> refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "git4idea/log/GitLogProvider", "printRefs"));
        }
        String string = StringUtil.join(refs, ref -> ref.getCommitHash().toShortString() + " : " + ref.getName(), (String)"\n");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "printRefs"));
        }
        return string;
    }

    private static void addOldStillExistingTags(@NotNull Set<VcsRef> allRefs, @NotNull Set<String> currentTags, @NotNull Collection<VcsRef> previousRefs) {
        if (allRefs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allRefs", "git4idea/log/GitLogProvider", "addOldStillExistingTags"));
        }
        if (currentTags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentTags", "git4idea/log/GitLogProvider", "addOldStillExistingTags"));
        }
        if (previousRefs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "previousRefs", "git4idea/log/GitLogProvider", "addOldStillExistingTags"));
        }
        for (VcsRef ref : previousRefs) {
            if (allRefs.contains(ref) || !currentTags.contains(ref.getName())) continue;
            allRefs.add(ref);
        }
    }

    @NotNull
    private Set<String> readCurrentTagNames(@NotNull VirtualFile root) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/log/GitLogProvider", "readCurrentTagNames"));
        }
        StopWatch sw = StopWatch.start((String)("reading tags in " + root.getName()));
        Set<String> tags = GitLogProvider.newHashSet();
        GitTag.listAsStrings(this.myProject, root, tags, null);
        sw.report();
        Set<String> set = tags;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "readCurrentTagNames"));
        }
        return set;
    }

    @NotNull
    private static <T> Set<T> remove(@NotNull Set<T> original, Set<T> ... toRemove) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "git4idea/log/GitLogProvider", "remove"));
        }
        if (toRemove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRemove", "git4idea/log/GitLogProvider", "remove"));
        }
        Set<T> result = GitLogProvider.newHashSet(original);
        for (Set<T> set : toRemove) {
            result.removeAll(set);
        }
        Set<T> set = result;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "remove"));
        }
        return set;
    }

    private static <T> void addNewElements(@NotNull Collection<T> original, @NotNull Collection<T> toAdd) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "git4idea/log/GitLogProvider", "addNewElements"));
        }
        if (toAdd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toAdd", "git4idea/log/GitLogProvider", "addNewElements"));
        }
        for (T item : toAdd) {
            if (original.contains(item)) continue;
            original.add(item);
        }
    }

    @NotNull
    private VcsLogProvider.DetailedLogData loadSomeCommitsOnTaggedBranches(@NotNull VirtualFile root, int commitCount, @NotNull Collection<String> unmatchedTags) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/log/GitLogProvider", "loadSomeCommitsOnTaggedBranches"));
        }
        if (unmatchedTags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unmatchedTags", "git4idea/log/GitLogProvider", "loadSomeCommitsOnTaggedBranches"));
        }
        StopWatch sw = StopWatch.start((String)("loading commits on tagged branch in " + root.getName()));
        ArrayList<String> params = new ArrayList<String>();
        params.add("--max-count=" + commitCount);
        params.addAll(unmatchedTags);
        sw.report();
        VcsLogProvider.DetailedLogData detailedLogData = GitHistoryUtils.loadMetadata(this.myProject, root, ArrayUtil.toStringArray(params));
        if (detailedLogData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "loadSomeCommitsOnTaggedBranches"));
        }
        return detailedLogData;
    }

    @NotNull
    public VcsLogProvider.LogData readAllHashes(@NotNull VirtualFile root, @NotNull Consumer<TimedVcsCommit> commitConsumer) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/log/GitLogProvider", "readAllHashes"));
        }
        if (commitConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitConsumer", "git4idea/log/GitLogProvider", "readAllHashes"));
        }
        if (!this.isRepositoryReady(root)) {
            LogDataImpl logDataImpl = LogDataImpl.empty();
            if (logDataImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "readAllHashes"));
            }
            return logDataImpl;
        }
        ArrayList<String> parameters = new ArrayList<String>(GitHistoryUtils.LOG_ALL);
        parameters.add("--date-order");
        GitBekParentFixer parentFixer = GitBekParentFixer.prepare(root, this);
        Set userRegistry = GitLogProvider.newHashSet();
        Set refs = GitLogProvider.newHashSet();
        GitHistoryUtils.readCommits(this.myProject, root, parameters, (Consumer<VcsUser>)new CollectConsumer(userRegistry), (Consumer<VcsRef>)new CollectConsumer(refs), (Consumer<TimedVcsCommit>)((Consumer)commit -> {
            if (commitConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitConsumer", "git4idea/log/GitLogProvider", "lambda$readAllHashes$2"));
            }
            commitConsumer.consume((Object)parentFixer.fixCommit((TimedVcsCommit)commit));
        }));
        LogDataImpl logDataImpl = new LogDataImpl(refs, userRegistry);
        if (logDataImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "readAllHashes"));
        }
        return logDataImpl;
    }

    public void readAllFullDetails(@NotNull VirtualFile root, @NotNull Consumer<VcsFullCommitDetails> commitConsumer) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/log/GitLogProvider", "readAllFullDetails"));
        }
        if (commitConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitConsumer", "git4idea/log/GitLogProvider", "readAllFullDetails"));
        }
        if (!this.isRepositoryReady(root)) {
            return;
        }
        GitHistoryUtils.loadDetails(this.myProject, root, commitConsumer, ArrayUtil.toStringArray(GitHistoryUtils.LOG_ALL));
    }

    public void readFullDetails(@NotNull VirtualFile root, @NotNull List<String> hashes, @NotNull Consumer<VcsFullCommitDetails> commitConsumer) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/log/GitLogProvider", "readFullDetails"));
        }
        if (hashes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashes", "git4idea/log/GitLogProvider", "readFullDetails"));
        }
        if (commitConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitConsumer", "git4idea/log/GitLogProvider", "readFullDetails"));
        }
        if (!this.isRepositoryReady(root)) {
            return;
        }
        VcsFileUtil.foreachChunk(hashes, (int)1, hashesChunk -> {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/log/GitLogProvider", "lambda$readFullDetails$3"));
            }
            if (commitConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitConsumer", "git4idea/log/GitLogProvider", "lambda$readFullDetails$3"));
            }
            String noWalk = GitVersionSpecialty.NO_WALK_UNSORTED.existsIn(this.myVcs.getVersion()) ? "--no-walk=unsorted" : "--no-walk";
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add(noWalk);
            parameters.addAll((Collection<String>)hashesChunk);
            GitHistoryUtils.loadDetails(this.myProject, root, commitConsumer, ArrayUtil.toStringArray(parameters));
        });
    }

    @NotNull
    public List<? extends VcsShortCommitDetails> readShortDetails(final @NotNull VirtualFile root, @NotNull List<String> hashes) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/log/GitLogProvider", "readShortDetails"));
        }
        if (hashes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashes", "git4idea/log/GitLogProvider", "readShortDetails"));
        }
        List list = VcsFileUtil.foreachChunk(hashes, (ThrowableNotNullFunction)new ThrowableNotNullFunction<List<String>, List<? extends VcsShortCommitDetails>, VcsException>(){

            @NotNull
            public List<? extends VcsShortCommitDetails> fun(@NotNull List<String> hashes) throws VcsException {
                if (hashes == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashes", "git4idea/log/GitLogProvider$3", "fun"));
                }
                List<? extends VcsShortCommitDetails> list = GitHistoryUtils.readMiniDetails(GitLogProvider.this.myProject, root, hashes);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider$3", "fun"));
                }
                return list;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "readShortDetails"));
        }
        return list;
    }

    @NotNull
    private Set<VcsRef> readBranches(@NotNull GitRepository repository) {
        Hash hash;
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/log/GitLogProvider", "readBranches"));
        }
        StopWatch sw = StopWatch.start((String)("readBranches in " + repository.getRoot().getName()));
        VirtualFile root = repository.getRoot();
        repository.update();
        GitBranchesCollection branches = repository.getBranches();
        Collection<GitLocalBranch> localBranches = branches.getLocalBranches();
        Collection<GitRemoteBranch> remoteBranches = branches.getRemoteBranches();
        THashSet refs = new THashSet(localBranches.size() + remoteBranches.size());
        for (GitLocalBranch localBranch : localBranches) {
            hash = branches.getHash(localBranch);
            assert (hash != null);
            refs.add(this.myVcsObjectsFactory.createRef(hash, localBranch.getName(), GitRefManager.LOCAL_BRANCH, root));
        }
        for (GitRemoteBranch remoteBranch : remoteBranches) {
            hash = branches.getHash(remoteBranch);
            assert (hash != null);
            refs.add(this.myVcsObjectsFactory.createRef(hash, remoteBranch.getNameForLocalOperations(), GitRefManager.REMOTE_BRANCH, root));
        }
        String currentRevision = repository.getCurrentRevision();
        if (currentRevision != null) {
            refs.add(this.myVcsObjectsFactory.createRef(HashImpl.build((String)currentRevision), "HEAD", GitRefManager.HEAD, root));
        }
        sw.report();
        THashSet tHashSet = refs;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "readBranches"));
        }
        return tHashSet;
    }

    @NotNull
    public VcsKey getSupportedVcs() {
        VcsKey vcsKey = GitVcs.getKey();
        if (vcsKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "getSupportedVcs"));
        }
        return vcsKey;
    }

    @NotNull
    public VcsLogRefManager getReferenceManager() {
        VcsLogRefManager vcsLogRefManager = this.myRefSorter;
        if (vcsLogRefManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "getReferenceManager"));
        }
        return vcsLogRefManager;
    }

    @NotNull
    public Disposable subscribeToRootRefreshEvents(@NotNull Collection<VirtualFile> roots, @NotNull VcsLogRefresher refresher) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "git4idea/log/GitLogProvider", "subscribeToRootRefreshEvents"));
        }
        if (refresher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refresher", "git4idea/log/GitLogProvider", "subscribeToRootRefreshEvents"));
        }
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
        connection.subscribe(GitRepository.GIT_REPO_CHANGE, repository -> {
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "git4idea/log/GitLogProvider", "lambda$subscribeToRootRefreshEvents$4"));
            }
            if (refresher == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refresher", "git4idea/log/GitLogProvider", "lambda$subscribeToRootRefreshEvents$4"));
            }
            VirtualFile root = repository.getRoot();
            if (roots.contains(root)) {
                refresher.refresh(root);
            }
        });
        MessageBusConnection messageBusConnection = connection;
        if (messageBusConnection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "subscribeToRootRefreshEvents"));
        }
        return messageBusConnection;
    }

    @NotNull
    public List<TimedVcsCommit> getCommitsMatchingFilter(@NotNull VirtualFile root, @NotNull VcsLogFilterCollection filterCollection, int maxCount) throws VcsException {
        Collection files;
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/log/GitLogProvider", "getCommitsMatchingFilter"));
        }
        if (filterCollection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterCollection", "git4idea/log/GitLogProvider", "getCommitsMatchingFilter"));
        }
        if (!this.isRepositoryReady(root)) {
            List<TimedVcsCommit> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "getCommitsMatchingFilter"));
            }
            return list;
        }
        ArrayList filterParameters = ContainerUtil.newArrayList();
        VcsLogBranchFilter branchFilter = filterCollection.getBranchFilter();
        if (branchFilter != null) {
            GitRepository repository = this.getRepository(root);
            assert (repository != null) : "repository is null for root " + root + " but was previously reported as 'ready'";
            ArrayList branches = ContainerUtil.newArrayList((Iterable)ContainerUtil.concat((Iterable[])new Iterable[]{repository.getBranches().getLocalBranches(), repository.getBranches().getRemoteBranches()}));
            Collection<String> branchNames = GitBranchUtil.convertBranchesToNames(branches);
            List predefinedNames = ContainerUtil.list((Object[])new String[]{"HEAD"});
            boolean atLeastOneBranchExists = false;
            for (String branchName : ContainerUtil.concat((Iterable[])new Iterable[]{branchNames, predefinedNames})) {
                if (!branchFilter.matches(branchName)) continue;
                filterParameters.add(branchName);
                atLeastOneBranchExists = true;
            }
            if (!atLeastOneBranchExists) {
                List<TimedVcsCommit> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "getCommitsMatchingFilter"));
                }
                return list;
            }
        } else {
            filterParameters.addAll(GitHistoryUtils.LOG_ALL);
        }
        if (filterCollection.getUserFilter() != null) {
            List authors = ContainerUtil.map((Collection)filterCollection.getUserFilter().getUserNames(root), (Function)UserNameRegex.BASIC_INSTANCE);
            if (GitVersionSpecialty.LOG_AUTHOR_FILTER_SUPPORTS_VERTICAL_BAR.existsIn(this.myVcs.getVersion())) {
                filterParameters.add(GitLogProvider.prepareParameter("author", StringUtil.join((Collection)authors, (String)"\\|")));
            } else {
                filterParameters.addAll(authors.stream().map(a -> GitLogProvider.prepareParameter("author", a)).collect(Collectors.toList()));
            }
        }
        if (filterCollection.getDateFilter() != null) {
            VcsLogDateFilter filter = filterCollection.getDateFilter();
            if (filter.getAfter() != null) {
                filterParameters.add(GitLogProvider.prepareParameter("after", filter.getAfter().toString()));
            }
            if (filter.getBefore() != null) {
                filterParameters.add(GitLogProvider.prepareParameter("before", filter.getBefore().toString()));
            }
        }
        if (filterCollection.getTextFilter() != null) {
            String textFilter = filterCollection.getTextFilter().getText();
            filterParameters.add(GitLogProvider.prepareParameter("grep", StringUtil.escapeChars((String)textFilter, (char[])new char[]{'[', ']'})));
        }
        filterParameters.add("--regexp-ignore-case");
        if (maxCount > 0) {
            filterParameters.add(GitLogProvider.prepareParameter("max-count", String.valueOf(maxCount)));
        }
        if (filterCollection.getStructureFilter() != null && !(files = filterCollection.getStructureFilter().getFiles()).isEmpty()) {
            filterParameters.add("--full-history");
            filterParameters.add("--simplify-merges");
            filterParameters.add("--");
            for (FilePath file : files) {
                filterParameters.add(file.getPath());
            }
        }
        ArrayList commits = ContainerUtil.newArrayList();
        GitHistoryUtils.readCommits(this.myProject, root, filterParameters, (Consumer<VcsUser>)EmptyConsumer.getInstance(), (Consumer<VcsRef>)EmptyConsumer.getInstance(), (Consumer<TimedVcsCommit>)new CollectConsumer((Collection)commits));
        ArrayList arrayList = commits;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "getCommitsMatchingFilter"));
        }
        return arrayList;
    }

    @Nullable
    public VcsUser getCurrentUser(@NotNull VirtualFile root) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/log/GitLogProvider", "getCurrentUser"));
        }
        return this.myUserRegistry.getOrReadUser(root);
    }

    @NotNull
    public Collection<String> getContainingBranches(@NotNull VirtualFile root, @NotNull Hash commitHash) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/log/GitLogProvider", "getContainingBranches"));
        }
        if (commitHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitHash", "git4idea/log/GitLogProvider", "getContainingBranches"));
        }
        Collection<String> collection = GitBranchUtil.getBranches(this.myProject, root, true, true, commitHash.asString());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "getContainingBranches"));
        }
        return collection;
    }

    @Nullable
    public String getCurrentBranch(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/log/GitLogProvider", "getCurrentBranch"));
        }
        GitRepository repository = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root);
        if (repository == null) {
            return null;
        }
        String currentBranchName = repository.getCurrentBranchName();
        if (currentBranchName == null && repository.getCurrentRevision() != null) {
            return "HEAD";
        }
        return currentBranchName;
    }

    @Nullable
    public <T> T getPropertyValue(VcsLogProperties.VcsLogProperty<T> property) {
        if (property == VcsLogProperties.LIGHTWEIGHT_BRANCHES) {
            return (T)Boolean.TRUE;
        }
        if (property == VcsLogProperties.SUPPORTS_INDEXING) {
            return (T)Boolean.valueOf(Registry.is((String)"vcs.log.index.git"));
        }
        return null;
    }

    private static String prepareParameter(String paramName, String value) {
        return "--" + paramName + "=" + value;
    }

    @Nullable
    private GitRepository getRepository(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/log/GitLogProvider", "getRepository"));
        }
        return (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root);
    }

    private boolean isRepositoryReady(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/log/GitLogProvider", "isRepositoryReady"));
        }
        GitRepository repository = this.getRepository(root);
        if (repository == null) {
            LOG.error("Repository not found for root " + root);
            return false;
        }
        if (repository.isFresh()) {
            LOG.info("Fresh repository: " + root);
            return false;
        }
        return true;
    }

    @NotNull
    private static <T> Set<T> newHashSet() {
        THashSet tHashSet = new THashSet();
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "newHashSet"));
        }
        return tHashSet;
    }

    @NotNull
    private static <T> Set<T> newHashSet(@NotNull Collection<T> initialCollection) {
        if (initialCollection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialCollection", "git4idea/log/GitLogProvider", "newHashSet"));
        }
        THashSet tHashSet = new THashSet(initialCollection);
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "newHashSet"));
        }
        return tHashSet;
    }
}

