/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browser;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.vcs.checkout.CheckoutStrategy;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.DepthCombo;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.dialogs.browser.SvnTrunkCheckoutStrategy;
import org.jetbrains.idea.svn.revision.SvnSelectRevisionPanel;
import org.jetbrains.idea.svn.update.SvnRevisionPanel;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class CheckoutOptionsDialog
extends DialogWrapper {
    private JCheckBox myExternalsCheckbox;
    private JLabel myUrlLabel;
    private JPanel myTopPanel;
    private SvnSelectRevisionPanel svnSelectRevisionPanel;
    private DepthCombo myDepthCombo;
    private JLabel myDepthLabel;
    private JList myLocalTargetList;
    private FixedSizeButton mySelectTarget;
    private JBScrollPane myScroll;
    private final String myRelativePath;

    public CheckoutOptionsDialog(final Project project, SVNURL url, File target, VirtualFile root, String relativePath) {
        super(project, true);
        this.myRelativePath = relativePath;
        this.$$$setupUI$$$();
        final String urlText = url.toDecodedString();
        this.myUrlLabel.setText(urlText);
        this.fillTargetList(target);
        this.validateTargetSelected();
        this.mySelectTarget.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor fcd = FileChooserDescriptorFactory.createSingleFolderDescriptor();
                fcd.setShowFileSystemRoots(true);
                fcd.setTitle(SvnBundle.message("checkout.directory.chooser.title", new Object[0]));
                fcd.setDescription(SvnBundle.message("checkout.directory.chooser.prompt", new Object[0]));
                fcd.setHideIgnored(false);
                VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)fcd, (Component)CheckoutOptionsDialog.this.getContentPane(), (Project)project, null);
                if (file == null) {
                    return;
                }
                CheckoutOptionsDialog.this.fillTargetList(new File(file.getPath()));
                CheckoutOptionsDialog.this.validateTargetSelected();
            }
        });
        this.myLocalTargetList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CheckoutOptionsDialog.this.validateTargetSelected();
            }
        });
        this.svnSelectRevisionPanel.setRoot(root);
        this.svnSelectRevisionPanel.setProject(project);
        this.svnSelectRevisionPanel.setUrlProvider(new SvnRevisionPanel.UrlProvider(){

            @Override
            public String getUrl() {
                return urlText;
            }
        });
        this.setTitle(SvnBundle.message("checkout.options.dialog.title", new Object[0]));
        this.myDepthLabel.setLabelFor(this.myDepthCombo);
        this.init();
        this.myScroll.setHorizontalScrollBarPolicy(31);
    }

    private void validateTargetSelected() {
        Object[] objects = this.myLocalTargetList.getSelectedValues();
        boolean disable = objects == null || objects.length != 1;
        this.setOKActionEnabled(!disable);
    }

    private void fillTargetList(File target) {
        DefaultListModel<File> listModel = new DefaultListModel<File>();
        ArrayList<SvnTrunkCheckoutStrategy> strategies = new ArrayList<SvnTrunkCheckoutStrategy>();
        Collections.addAll(strategies, CheckoutStrategy.createAllStrategies((File)target, (File)new File(this.myRelativePath), (boolean)false));
        strategies.add(new SvnTrunkCheckoutStrategy(target, new File(this.myRelativePath), false));
        ArrayList<File> targets = new ArrayList<File>(5);
        for (CheckoutStrategy checkoutStrategy : strategies) {
            File result = checkoutStrategy.getResult();
            if (result == null || targets.contains(result)) continue;
            targets.add(result);
        }
        Collections.sort(targets);
        for (File file : targets) {
            listModel.addElement(file);
        }
        this.myLocalTargetList.setModel(listModel);
        this.myLocalTargetList.setVisibleRowCount(4);
        this.myLocalTargetList.setPreferredSize(new Dimension(20, 80));
        this.myLocalTargetList.setMinimumSize(new Dimension(20, 80));
        this.myLocalTargetList.setSelectedValue(target, true);
        if (this.myLocalTargetList.getSelectedValues() == null && !targets.isEmpty()) {
            this.myLocalTargetList.setSelectedIndex(0);
        }
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "svn4idea.checkout.options";
    }

    @Nullable
    public File getTarget() {
        Object[] objects = this.myLocalTargetList.getSelectedValues();
        return objects == null || objects.length != 1 ? null : (File)objects[0];
    }

    public Depth getDepth() {
        return this.myDepthCombo.getDepth();
    }

    public boolean isIgnoreExternals() {
        return !this.myExternalsCheckbox.isSelected();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myTopPanel;
    }

    @NotNull
    public SVNRevision getRevision() throws ConfigurationException {
        SVNRevision sVNRevision = this.svnSelectRevisionPanel.getRevision();
        if (sVNRevision == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/browser/CheckoutOptionsDialog", "getRevision"));
        }
        return sVNRevision;
    }

    private void createUIComponents() {
        this.mySelectTarget = new FixedSizeButton(20);
        this.myDepthCombo = new DepthCombo(false);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JBScrollPane jBScrollPane;
        JLabel jLabel2;
        SvnSelectRevisionPanel svnSelectRevisionPanel;
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.createUIComponents();
        this.myTopPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, "Center");
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("checkout.options.checkout.label"));
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("checkout.options.destination.label"));
        jPanel2.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        this.myExternalsCheckbox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("checkout.options.externals.label"));
        jCheckBox.setSelected(true);
        jPanel2.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.svnSelectRevisionPanel = svnSelectRevisionPanel = new SvnSelectRevisionPanel();
        JComponent jComponent = svnSelectRevisionPanel.$$$getRootComponent$$$();
        jPanel2.add((Component)jComponent, new GridConstraints(2, 0, 1, 3, 0, 1, 3, 3, null, null, null));
        DepthCombo depthCombo = this.myDepthCombo;
        jPanel2.add((Component)depthCombo, new GridConstraints(3, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myDepthLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("label.depth.text"));
        jLabel2.setToolTipText(ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("label.depth.description"));
        jPanel2.add((Component)jLabel2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myScroll = jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 1, 1, 1, 0, 3, 7, 7, null, null, null));
        JBList jBList = new JBList();
        this.myLocalTargetList = jBList;
        jBList.setSelectionMode(0);
        jBScrollPane.setViewportView((Component)jBList);
        FixedSizeButton fixedSizeButton = this.mySelectTarget;
        jPanel2.add((Component)fixedSizeButton, new GridConstraints(1, 2, 1, 1, 1, 0, 3, 3, null, null, null));
        this.myUrlLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myTopPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

